/*
 * Decompiled with CFR 0.152.
 */
package net.msymbios.monsters_girls.entity.internal;

import java.util.List;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.msymbios.monsters_girls.entity.enums.EntityAnimator;
import net.msymbios.monsters_girls.entity.enums.EntityAttribute;
import net.msymbios.monsters_girls.entity.enums.EntityCategory;
import net.msymbios.monsters_girls.entity.enums.EntityModel;
import net.msymbios.monsters_girls.entity.enums.EntitySound;
import net.msymbios.monsters_girls.entity.enums.EntityState;
import net.msymbios.monsters_girls.entity.enums.EntityTexture;
import net.msymbios.monsters_girls.entity.enums.EntityVariant;
import net.msymbios.monsters_girls.entity.internal.BlockPlanting;
import net.msymbios.monsters_girls.entity.internal.InternalData;
import net.msymbios.monsters_girls.entity.internal.InternalMetric;
import net.msymbios.monsters_girls.entity.internal.InternalParticles;
import net.msymbios.monsters_girls.entity.internal.InternalPlanting;
import net.msymbios.monsters_girls.entity.internal.Utility;
import org.jetbrains.annotations.Nullable;

public abstract class InternalEntity
extends class_1321 {
    protected static final class_2940<String> VARIANT = class_2945.method_12791(InternalEntity.class, (class_2941)class_2943.field_13326);
    protected static final class_2940<Integer> TEXTURE_ID = class_2945.method_12791(InternalEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> MODEL_ID = class_2945.method_12791(InternalEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> STATE = class_2945.method_12791(InternalEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Boolean> LOG = class_2945.method_12791(InternalEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> BELLY = class_2945.method_12791(InternalEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> PLANT = class_2945.method_12791(InternalEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> SOUND = class_2945.method_12791(InternalEntity.class, (class_2941)class_2943.field_13323);
    protected int waryTimer = 0;
    protected int autoHealTimer = 0;
    protected boolean combatMode = false;
    protected boolean autoHeal = false;
    protected boolean canPlant = true;
    protected boolean hasEffects = false;
    protected EntityCategory category;
    protected EntityVariant variant;

    public String getVariant() {
        String value = this.variant.getName();
        try {
            value = (String)this.field_6011.method_12789(VARIANT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public void setVariant(String value) {
        this.field_6011.method_12778(VARIANT, (Object)value);
    }

    public class_2960 getAnimatorByID(int value) {
        return InternalMetric.getAnimator(this.category, this.variant, EntityAnimator.byId(value));
    }

    public class_2960 getAnimator() {
        return InternalMetric.getAnimator(this.category, this.variant);
    }

    public class_2960 getCurrentModelByID(int value) {
        return InternalMetric.getModel(this.category, this.variant, EntityModel.byId(value));
    }

    public class_2960 getCurrentModel() {
        return InternalMetric.getModel(this.category, this.variant);
    }

    public int getModelID() {
        int value = 0;
        try {
            value = (Integer)this.field_6011.method_12789(MODEL_ID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public EntityModel getModel() {
        int value = 0;
        try {
            value = (Integer)this.field_6011.method_12789(MODEL_ID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return EntityModel.byId(value);
    }

    public void setModel(EntityModel value) {
        this.setModel(value.getId());
    }

    public void setModel(int value) {
        this.field_6011.method_12778(MODEL_ID, (Object)value);
    }

    public class_2960 getTextureByID(int value) {
        return InternalMetric.getTexture(this.variant, EntityTexture.byId(value));
    }

    public class_2960 getTexture() {
        return InternalMetric.getTexture(this.variant, EntityTexture.byId(this.getTextureID()));
    }

    public class_2960 getCurrentTexture() {
        class_2960 defaultTexture = InternalMetric.TEXTURE.get((Object)this.variant).get((Object)EntityTexture.DEFAULT);
        if (InternalMetric.checkTextureID(this.variant, EntityTexture.byId(this.getTextureID()))) {
            defaultTexture = InternalMetric.TEXTURE.get((Object)this.variant).get((Object)EntityTexture.byId(this.getTextureID()));
        }
        return defaultTexture;
    }

    public int getTextureID() {
        int value = EntityTexture.DEFAULT.getId();
        try {
            value = (Integer)this.field_6011.method_12789(TEXTURE_ID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public void setTexture(int value) {
        if (InternalMetric.checkTextureID(this.variant, EntityTexture.byId(value))) {
            this.field_6011.method_12778(TEXTURE_ID, (Object)value);
        }
    }

    public void setTexture(EntityTexture value) {
        this.setTexture(value.getId());
    }

    public int getCurrentStateID() {
        int value = EntityState.Sit.getId();
        try {
            value = (Integer)this.field_6011.method_12789(STATE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public EntityState getCurrentState() {
        EntityState value = EntityState.Sit;
        try {
            value = EntityState.byId((Integer)this.field_6011.method_12789(STATE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public void setCurrentState(EntityState value) {
        this.field_6011.method_12778(STATE, (Object)value.getId());
    }

    public void setCurrentState(int value) {
        this.field_6011.method_12778(STATE, (Object)value);
    }

    public float getAttributeRaw(EntityAttribute attribute) {
        return InternalMetric.getAttribute(this.variant, attribute);
    }

    public int getAttribute(EntityAttribute attribute) {
        return (int)this.getAttributeRaw(attribute);
    }

    public int getHpValue() {
        return this.getAttribute(EntityAttribute.MAX_HEALTH);
    }

    public int getAttackValue() {
        return this.getAttribute(EntityAttribute.ATTACK_DAMAGE);
    }

    public int getDefenseValue() {
        return this.getAttribute(EntityAttribute.DEFENSE);
    }

    public double getArmorValue() {
        int armor = this.getDefenseValue();
        if (armor > 30) {
            armor = 30;
        }
        return armor;
    }

    public double getArmorToughnessValue() {
        double armor = this.getArmorValue();
        double armor_tou = 0.0;
        if (armor > 30.0) {
            armor_tou = armor - 30.0;
        }
        return armor_tou;
    }

    public boolean getLog() {
        boolean value = true;
        try {
            value = (Boolean)this.field_6011.method_12789(LOG);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public void setLog(boolean value) {
        this.field_6011.method_12778(LOG, (Object)value);
    }

    public boolean getBelly() {
        boolean value = true;
        try {
            value = (Boolean)this.field_6011.method_12789(BELLY);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public void setBelly(boolean value) {
        this.field_6011.method_12778(BELLY, (Object)value);
    }

    public boolean getPlant() {
        boolean value = true;
        try {
            value = (Boolean)this.field_6011.method_12789(PLANT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public void setPlant(boolean value) {
        this.field_6011.method_12778(PLANT, (Object)value);
    }

    public boolean getSound() {
        boolean value = true;
        try {
            value = (Boolean)this.field_6011.method_12789(SOUND);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public void setSound(boolean value) {
        this.field_6011.method_12778(SOUND, (Object)value);
    }

    protected InternalEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
    }

    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        this.setTexture(InternalMetric.getRandomTextureID(this.variant));
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public void method_5773() {
        super.method_5773();
        if (this.canPlant && this.getPlant() && this.method_6181()) {
            this.handlePlanting((class_1936)this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), (class_1297)this);
        }
        this.handleCombatMode();
        this.handleAutoHeal();
    }

    public void method_6114(class_1297 target) {
        this.handleActivateCombatMode();
        this.method_37908().method_8421((class_1297)this, (byte)4);
        super.method_6114(target);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        if (this.hasEffects) {
            this.handleNegativeEffect((class_1297)this, source.method_5526());
        }
        this.handleActivateCombatMode();
        return super.method_5643(source, amount);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (hand == class_1268.field_5808) {
            if (this.method_35057() != null) {
                this.handleSit(itemStack);
            }
            if (this.method_37908().field_9236) {
                boolean bl = this.method_6171((class_1309)player) || this.method_6181() || itemStack.method_31574(class_1802.field_8423) && !this.method_6181();
                return bl ? class_1269.field_21466 : class_1269.field_5811;
            }
            if (this.method_35057() == null) {
                this.handleTame(itemStack, player);
            }
            if (this.method_35057() != null) {
                if (this.hasEffects) {
                    this.handleEffect((class_1297)this, (class_1297)player, itemStack);
                }
                this.handleState(itemStack, player);
                this.handleTexture(itemStack, player);
                if (itemStack.method_31574(class_1802.field_8780)) {
                    this.setLog(Utility.invertBoolean(this.getLog()));
                    if (this.getLog()) {
                        this.commandDebug("Log: ON", true);
                    } else {
                        this.commandDebug("Log: OFF", true);
                    }
                }
                if (itemStack.method_31574(class_1802.field_8643)) {
                    this.setSound(Utility.invertBoolean(this.getSound()));
                    if (this.getSound()) {
                        this.commandDebug("Sound: ON", true);
                    } else {
                        this.commandDebug("Sound: OFF", true);
                    }
                }
                if (this.canPlant && itemStack.method_31574(class_1802.field_8167)) {
                    this.setPlant(Utility.invertBoolean(this.getPlant()));
                    if (this.getPlant()) {
                        this.commandDebug("Plant: ON", true);
                    } else {
                        this.commandDebug("Plant: OFF", true);
                    }
                }
                return class_1269.field_5812;
            }
        }
        return super.method_5992(player, hand);
    }

    protected class_3414 method_6011(class_1282 source) {
        return InternalMetric.getSound(this.variant, EntitySound.HURT);
    }

    protected class_3414 method_6002() {
        return InternalMetric.getSound(this.variant, EntitySound.DEATH);
    }

    protected class_3414 method_5994() {
        if (this.getSound()) {
            return InternalMetric.getSound(this.variant, EntitySound.DEFAULT);
        }
        return null;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TEXTURE_ID, (Object)EntityTexture.DEFAULT.getId());
        this.field_6011.method_12784(STATE, (Object)EntityState.Move.getId());
        this.field_6011.method_12784(LOG, (Object)false);
        this.field_6011.method_12784(PLANT, (Object)true);
        this.field_6011.method_12784(SOUND, (Object)true);
    }

    public void method_5652(class_2487 dataNBT) {
        super.method_5652(dataNBT);
        dataNBT.method_10582("Variant", this.getVariant());
        dataNBT.method_10569("TextureID", this.getTextureID());
        dataNBT.method_10569("ModelID", this.getModelID());
        dataNBT.method_10569("State", this.getCurrentStateID());
        dataNBT.method_10556("Log", this.getLog());
        dataNBT.method_10556("Belly", this.getBelly());
        dataNBT.method_10556("Plant", this.getPlant());
        dataNBT.method_10556("Sound", this.getSound());
    }

    public void method_5749(class_2487 dataNBT) {
        super.method_5749(dataNBT);
        this.setVariant(dataNBT.method_10558("Variant"));
        this.setTexture(dataNBT.method_10550("TextureID"));
        this.setModel(dataNBT.method_10550("ModelID"));
        this.setCurrentState(dataNBT.method_10550("State"));
        this.setLog(dataNBT.method_10577("Log"));
        this.setBelly(dataNBT.method_10577("Belly"));
        this.setPlant(dataNBT.method_10577("Plant"));
        this.setSound(dataNBT.method_10577("Sound"));
    }

    public boolean canInteract(class_1799 itemStack) {
        if (itemStack.method_31574(class_1802.field_8153) || itemStack.method_31574(class_1802.field_8279) || itemStack.method_31574(class_1802.field_8423) || itemStack.method_31574(class_1802.field_8643) || itemStack.method_31574(class_1802.field_8167) || itemStack.method_31574(class_1802.field_20414) || itemStack.method_31574(class_1802.field_20417)) {
            return false;
        }
        return !itemStack.method_31574(class_1802.field_8529) && !itemStack.method_31574(class_1802.field_8674) && !itemStack.method_31574(class_1802.field_8780);
    }

    protected void handlePlanting(class_1936 world, double x, double y, double z, class_1297 entity) {
        class_2338 blockPos;
        if (entity == null) {
            return;
        }
        if (entity.method_24828() && world.method_18026(new class_238(blockPos = new class_2338((int)x, (int)y, (int)z)))) {
            class_2248 standingBlock = world.method_8320(new class_2338((int)x, (int)y - 1, (int)z)).method_26204();
            InternalPlanting blockToPlant = InternalMetric.PLANTING.get((Object)this.variant);
            boolean canPlantBlock = false;
            if (!blockToPlant.canPlantOn.isEmpty()) {
                for (class_2248 class_22482 : blockToPlant.canPlantOn) {
                    if (standingBlock != class_22482) continue;
                    canPlantBlock = true;
                    break;
                }
            } else {
                canPlantBlock = true;
            }
            if (canPlantBlock) {
                for (BlockPlanting blockPlanting : blockToPlant.toBePlant) {
                    if (!(Math.random() < (double)blockPlanting.condition)) continue;
                    world.method_8652(blockPos, blockPlanting.block.method_9564(), 3);
                }
            }
        }
    }

    protected void handleNegativeEffect(class_1297 entity, class_1297 sourceentity) {
        class_1309 _entity;
        if (entity == null || sourceentity == null) {
            return;
        }
        if (sourceentity instanceof class_1309 && !(_entity = (class_1309)sourceentity).method_37908().method_8608()) {
            List<List<InternalData>> listOfEffects = InternalMetric.HARMFUL_EFFECTS.get((Object)this.variant);
            for (List<InternalData> effect : listOfEffects) {
                _entity.method_6092(new class_1293((class_1291)effect.get(0).getValue(), ((Integer)effect.get(1).getValue()).intValue(), ((Integer)effect.get(2).getValue()).intValue()));
            }
        }
    }

    protected void handleEffect(class_1297 entity, class_1297 sourceentity, class_1799 itemstack) {
        block5: {
            block6: {
                class_1309 _entity;
                class_1321 _tamEnt;
                if (entity == null || sourceentity == null) {
                    return;
                }
                if (!(entity instanceof class_1321) || !(_tamEnt = (class_1321)entity).method_6181() || !(sourceentity instanceof class_1309) || (_entity = (class_1309)sourceentity).method_37908().method_8608()) break block5;
                List<List<InternalData>> listOfEffects = InternalMetric.HELPFUL_EFFECTS.get((Object)this.variant);
                for (List<InternalData> effect : listOfEffects) {
                    if (!itemstack.method_31574((class_1792)effect.get(0).getValue())) continue;
                    _entity.method_6092(new class_1293((class_1291)effect.get(1).getValue(), ((Integer)effect.get(2).getValue()).intValue(), ((Integer)effect.get(3).getValue()).intValue()));
                }
                if (!(sourceentity instanceof class_1657)) break block6;
                class_1657 player = (class_1657)sourceentity;
                if (player.method_31549().field_7477) break block5;
            }
            itemstack.method_7934(1);
        }
    }

    protected void handleAutoHeal() {
        if (this.method_6032() < (float)this.getHpValue()) {
            this.autoHeal = true;
        }
        if (this.method_37908().field_9236 && !this.autoHeal && !InternalMetric.GLOBAL_AUTO_HEAL) {
            return;
        }
        if (this.autoHealTimer != 0) {
            --this.autoHealTimer;
        } else {
            float healValue = (float)this.getHpValue() / 16.0f;
            this.method_6025(healValue);
            this.autoHeal = false;
            this.autoHealTimer = InternalMetric.GLOBAL_HEAL_INTERVAL;
        }
    }

    protected void handleActivateCombatMode() {
        if (!this.combatMode) {
            this.combatMode = true;
        }
        this.waryTimer = InternalMetric.WARY_TIME;
    }

    protected void handleCombatMode() {
        if (this.method_6510()) {
            this.handleActivateCombatMode();
        }
        if (this.method_37908().field_9236 && !this.combatMode) {
            return;
        }
        if (this.waryTimer != 0) {
            --this.waryTimer;
        } else {
            if (this.getModel() != EntityModel.Mushroom) {
                this.setModel(EntityModel.Mushroom);
            }
            this.combatMode = false;
        }
    }

    public void handleTame(class_1799 stack, class_1657 player) {
        boolean canAttemptTame = false;
        List<class_1792> listOfItems = InternalMetric.ENTITY_TAMABLE_ITEM.get((Object)this.variant);
        for (class_1792 item : listOfItems) {
            if (!stack.method_31574(item)) continue;
            canAttemptTame = true;
            break;
        }
        if (canAttemptTame) {
            if (this.field_5974.method_43048(5) == 0) {
                this.method_6170(player);
                this.field_6189.method_6340();
                this.method_5980(null);
                InternalParticles.Heart((class_1297)this);
                this.method_37908().method_8421((class_1297)this, (byte)7);
            } else {
                InternalParticles.Ash((class_1297)this);
                this.method_37908().method_8421((class_1297)this, (byte)6);
            }
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
        }
    }

    public void handleSit(class_1799 itemStack) {
        if (!this.canInteract(itemStack)) {
            return;
        }
        this.method_24346(Utility.invertBoolean(this.method_24345()));
    }

    public void handleTexture(class_1799 items, class_1657 player) {
        int bellyLevel;
        int oldTexture = this.getTextureID();
        if (items.method_31574(class_1802.field_8153) && (bellyLevel = this.getTextureID()) > 0 && bellyLevel <= 3) {
            this.setTexture(EntityTexture.byId(--bellyLevel));
        }
        if (items.method_31574(class_1802.field_8279) && (bellyLevel = this.getTextureID()) >= 0 && bellyLevel < 3) {
            this.setTexture(EntityTexture.byId(++bellyLevel));
        }
        if (oldTexture != this.getTextureID() && !player.method_31549().field_7477) {
            items.method_7934(1);
        }
    }

    public void handleState(class_1799 itemStack, class_1657 player) {
        this.RestState(itemStack);
        this.FollowState(itemStack);
    }

    public void RestState(class_1799 itemStack) {
        if (!this.canInteract(itemStack)) {
            return;
        }
        if (this.method_24345()) {
            this.setCurrentState(EntityState.Sit);
        }
    }

    public void FollowState(class_1799 itemStack) {
        if (!this.canInteract(itemStack)) {
            return;
        }
        if (!this.method_24345()) {
            this.setCurrentState(EntityState.Move);
        }
    }

    public void commandDebug(String message, boolean overlay) {
        if (this.method_35057() != null) {
            class_1657 player = (class_1657)this.method_35057();
            player.method_7353((class_2561)class_2561.method_43470((String)message), overlay);
        }
    }
}

