/*
 * Decompiled with CFR 0.152.
 */
package net.msymbios.monsters_girls.entity.enums;

import java.util.Arrays;
import java.util.Comparator;

public enum EntityTexture {
    SLIM(0, "slim"),
    DEFAULT(1, "default"),
    TUMMY(2, "tummy"),
    INFLATED(3, "inflated"),
    CHUNKY(4, "chunky");

    private static final EntityTexture[] CODEC;
    private final int m_id;
    private final String m_name;

    private EntityTexture(int id, String name) {
        this.m_id = id;
        this.m_name = name;
    }

    public static EntityTexture byId(int id) {
        if (id < 0 || id >= CODEC.length) {
            id = 0;
        }
        return CODEC[id];
    }

    public int getId() {
        return this.m_id;
    }

    public static EntityTexture byName(String name) {
        for (EntityTexture item : CODEC) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        return null;
    }

    public String getName() {
        return this.m_name;
    }

    static {
        CODEC = (EntityTexture[])Arrays.stream(EntityTexture.values()).sorted(Comparator.comparingInt(EntityTexture::getId)).toArray(EntityTexture[]::new);
    }
}

