/*
 * Decompiled with CFR 0.152.
 */
package net.msymbios.monsters_girls.entity.enums;

import java.util.Arrays;
import java.util.Comparator;

public enum EntitySound {
    ATTACK(0, "attack"),
    DEFAULT(1, "default"),
    DEATH(2, "death"),
    HURT(3, "hurt"),
    HUFF(4, "huff"),
    LAUGH(5, "laugh"),
    PUFF(6, "puff"),
    SPECIAL(7, "special");

    private static final EntitySound[] CODEC;
    private final int m_id;
    private final String m_name;

    private EntitySound(int id, String name) {
        this.m_id = id;
        this.m_name = name;
    }

    public static EntitySound byId(int id) {
        if (id < 0 || id >= CODEC.length) {
            id = 0;
        }
        return CODEC[id];
    }

    public int getId() {
        return this.m_id;
    }

    public static EntitySound byName(String name) {
        for (EntitySound item : CODEC) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        return null;
    }

    public String getName() {
        return this.m_name;
    }

    static {
        CODEC = (EntitySound[])Arrays.stream(EntitySound.values()).sorted(Comparator.comparingInt(EntitySound::getId)).toArray(EntitySound[]::new);
    }
}

