/*
 * Decompiled with CFR 0.152.
 */
package net.msymbios.monsters_girls.entity.enums;

import java.util.Arrays;
import java.util.Comparator;

public enum EntityModel {
    Mandrake(0, "mandrake"),
    MandrakeFruit(1, "mandrake_fruit"),
    MandrakeFruitChorus(2, "mandrake_fruit_chorus"),
    Mushroom(3, "mushroom"),
    MushroomFat(4, "mushroom_fat"),
    MushroomFungus(5, "mushroom_fungus"),
    MushroomInflated(6, "mushroom_fungus_inflated"),
    Spook(7, "spook"),
    Wisp(8, "wisp"),
    Slime(9, "slime"),
    Gourdragora(10, "gourdragora"),
    GourdragoraMini(11, "gourdragora_mini"),
    Bee(12, "bee");

    private static final EntityModel[] CODEC;
    private final int m_id;
    private final String m_name;

    private EntityModel(int id, String name) {
        this.m_id = id;
        this.m_name = name;
    }

    public static EntityModel byId(int id) {
        if (id < 0 || id >= CODEC.length) {
            id = 0;
        }
        return CODEC[id];
    }

    public int getId() {
        return this.m_id;
    }

    public static EntityModel byName(String name) {
        for (EntityModel item : CODEC) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        return null;
    }

    public String getName() {
        return this.m_name;
    }

    static {
        CODEC = (EntityModel[])Arrays.stream(EntityModel.values()).sorted(Comparator.comparingInt(EntityModel::getId)).toArray(EntityModel[]::new);
    }
}

