/*
 * Decompiled with CFR 0.152.
 */
package net.msymbios.monsters_girls.entity.enums;

import java.util.Arrays;
import java.util.Comparator;

public enum EntityCategory {
    Endercaris(0, "endercaris"),
    Mandrake(1, "mandrake"),
    Mushroom(2, "mushroom"),
    Slime(3, "slime"),
    Spook(4, "spook"),
    Wisp(5, "wisp"),
    Gourdragora(6, "gourdragora"),
    Bee(7, "bee");

    private static final EntityCategory[] CODEC;
    private final int m_id;
    private final String m_name;

    private EntityCategory(int id, String name) {
        this.m_id = id;
        this.m_name = name;
    }

    public static EntityCategory byId(int id) {
        if (id < 0 || id >= CODEC.length) {
            id = 0;
        }
        return CODEC[id];
    }

    public int getId() {
        return this.m_id;
    }

    public static EntityCategory byName(String name) {
        for (EntityCategory item : CODEC) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        return null;
    }

    public String getName() {
        return this.m_name;
    }

    static {
        CODEC = (EntityCategory[])Arrays.stream(EntityCategory.values()).sorted(Comparator.comparingInt(EntityCategory::getId)).toArray(EntityCategory[]::new);
    }
}

