/*
 * Decompiled with CFR 0.152.
 */
package net.msymbios.monsters_girls.entity.enums;

import java.util.Arrays;
import java.util.Comparator;

public enum EntityAnimation {
    Idle(0, "idle"),
    Walk(1, "walk"),
    Attack(2, "attack"),
    Interact(3, "interact"),
    Rest(4, "rest"),
    Wave(5, "wave"),
    Hurt(5, "hurt");

    private static final EntityAnimation[] CODEC;
    private final int m_id;
    private final String m_name;

    private EntityAnimation(int id, String name) {
        this.m_id = id;
        this.m_name = name;
    }

    public static EntityAnimation byId(int id) {
        if (id < 0 || id >= CODEC.length) {
            id = 0;
        }
        return CODEC[id];
    }

    public int getId() {
        return this.m_id;
    }

    public static EntityAnimation byName(String name) {
        for (EntityAnimation item : CODEC) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        return null;
    }

    public String getName() {
        return this.m_name;
    }

    static {
        CODEC = (EntityAnimation[])Arrays.stream(EntityAnimation.values()).sorted(Comparator.comparingInt(EntityAnimation::getId)).toArray(EntityAnimation[]::new);
    }
}

