/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.client.gui.widgets.lists;

import caeruleusTait.world.preview.client.WorldPreviewClient;
import caeruleusTait.world.preview.client.gui.PreviewDisplayDataProvider;
import caeruleusTait.world.preview.client.gui.screens.PreviewContainer;
import caeruleusTait.world.preview.client.gui.widgets.ToggleButton;
import caeruleusTait.world.preview.client.gui.widgets.lists.BaseObjectSelectionList;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_4185;
import net.minecraft.class_6880;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuresList
extends BaseObjectSelectionList<StructureEntry> {
    public StructuresList(class_310 minecraft, int width, int height, int x, int y) {
        super(minecraft, width, height, x, y, 24);
    }

    public StructureEntry createEntry(short id, class_2960 resourceLocation, class_1011 icon, class_1792 item, String name, boolean show, boolean showByDefault) {
        return new StructureEntry(id, resourceLocation, icon, item, name, show, showByDefault);
    }

    @Override
    public void method_25314(Collection<StructureEntry> entryList) {
        super.method_25314(entryList);
        double maxScroll = Math.max(0.0, (double)(super.method_25340() * this.field_22741 - this.field_22743));
        if (super.method_25341() > maxScroll) {
            super.method_25307(maxScroll);
        }
    }

    public class StructureEntry
    extends BaseObjectSelectionList.Entry<StructureEntry>
    implements PreviewDisplayDataProvider.StructureRenderInfo {
        private final short id;
        private final class_1011 icon;
        private final class_1792 item;
        private final class_1799 itemStack;
        private final class_1043 iconTexture;
        private final int iconWidth;
        private final int iconHeight;
        private final String name;
        private final class_7919 tooltip;
        private final boolean showByDefault;
        private final boolean isPrimaryNamespace;
        private boolean show;
        public final ToggleButton toggleVisible;

        public StructureEntry(short id, @NotNull class_2960 resourceLocation, @Nullable class_1011 icon, class_1792 item, String name, boolean show, boolean showByDefault) {
            this.id = id;
            this.item = item;
            this.itemStack = this.item == null ? null : new class_1799((class_1935)this.item, 1);
            this.icon = icon;
            this.iconTexture = new class_1043(this.icon);
            this.iconWidth = this.icon.method_4307();
            this.iconHeight = this.icon.method_4323();
            this.showByDefault = showByDefault;
            this.show = show;
            this.toggleVisible = new ToggleButton(0, 0, 20, 20, 140, 20, 20, 20, PreviewContainer.BUTTONS_TEXTURE, 320, 60, this::toggleVisible);
            this.iconTexture.method_4524();
            this.toggleVisible.selected = show;
            this.isPrimaryNamespace = resourceLocation.method_12836().equals("minecraft");
            this.name = Objects.equals(resourceLocation.toString(), name) || name == null ? WorldPreviewClient.toTitleCase(resourceLocation.method_12832().replace("_", " ")) : name;
            String tag = "\u00a75\u00a7o" + resourceLocation.method_12836() + "\u00a7r\n\u00a79" + resourceLocation.method_12832() + "\u00a7r";
            this.tooltip = class_7919.method_47407((class_2561)class_2561.method_43470((String)(this.name + "\n\n" + tag)));
        }

        public void reset() {
            this.toggleVisible.selected = this.show = this.showByDefault;
        }

        private void toggleVisible(class_4185 btn) {
            this.show = this.toggleVisible.selected;
        }

        public void setVisible(boolean show) {
            this.show = show;
        }

        @Override
        public class_7919 tooltip() {
            return this.tooltip;
        }

        @NotNull
        public class_2561 method_37006() {
            return class_2561.method_43473();
        }

        public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean bl, float partialTick) {
            int xMin = left + 2;
            int yMin = top + 2;
            int xMax = xMin + this.iconWidth;
            int yMax = yMin + this.iconHeight;
            if (this.item != null) {
                guiGraphics.method_51427(this.itemStack, xMin, yMin);
            } else {
                WorldPreviewClient.renderTexture((class_1044)this.iconTexture, xMin, yMin, xMax, yMax);
            }
            Object formatName = this.isPrimaryNamespace ? this.name : "\u00a7o" + this.name;
            guiGraphics.method_25303(((StructuresList)StructuresList.this).field_22740.field_1772, (String)formatName, left + 16 + 4, top + 6, 0xFFFFFF);
            this.toggleVisible.method_48229(StructuresList.this.method_31383() - 22, top);
            this.toggleVisible.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            StructuresList.this.field_22740.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            if (this.toggleVisible.method_25405(mouseX, mouseY)) {
                this.toggleVisible.method_25348(mouseX, mouseY);
            }
            return true;
        }

        public String name() {
            return this.name;
        }

        public boolean showByDefault() {
            return this.showByDefault;
        }

        @Override
        public boolean show() {
            return this.show;
        }

        public short id() {
            return this.id;
        }

        public class_1792 item() {
            return this.item;
        }

        public class_1799 itemStack() {
            return this.itemStack;
        }
    }
}

