/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.client.gui.widgets.lists;

import caeruleusTait.world.preview.WorldPreview;
import caeruleusTait.world.preview.backend.color.PreviewData;
import caeruleusTait.world.preview.client.WorldPreviewClient;
import caeruleusTait.world.preview.client.gui.screens.PreviewContainer;
import caeruleusTait.world.preview.client.gui.widgets.lists.BaseObjectSelectionList;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1959;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_350;
import net.minecraft.class_6880;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BiomesList
extends BaseObjectSelectionList<BiomeEntry> {
    private Consumer<BiomeEntry> onBiomeSelected;
    private final boolean allowDeselecting;
    private final PreviewContainer previewContainer;

    public BiomesList(PreviewContainer previewContainer, class_310 minecraft, int width, int height, int x, int y, boolean allowDeselecting) {
        super(minecraft, width, height, x, y, 16);
        this.allowDeselecting = allowDeselecting;
        this.previewContainer = previewContainer;
    }

    public BiomeEntry createEntry(class_6880.class_6883<class_1959> entry, short id, int color, int initialColor, boolean isCave, boolean initialIsCave, String explicitName, PreviewData.DataSource dataSource) {
        return new BiomeEntry(entry, id, color, initialColor, isCave, initialIsCave, explicitName, dataSource);
    }

    public void setSelected(@Nullable BiomeEntry entry) {
        this.setSelected(entry, false);
    }

    public void setSelected(@Nullable BiomeEntry entry, boolean centerScroll) {
        super.method_25313((class_350.class_351)entry);
        if (centerScroll) {
            super.method_25324((class_350.class_351)entry);
        }
        this.onBiomeSelected.accept(entry);
    }

    public void setBiomeChangeListener(Consumer<BiomeEntry> onBiomeSelected) {
        this.onBiomeSelected = onBiomeSelected;
    }

    @Override
    public void method_25314(Collection<BiomeEntry> entryList) {
        BiomeEntry oldEntry = (BiomeEntry)this.method_25334();
        super.method_25314(entryList);
        if (entryList.contains((Object)oldEntry)) {
            this.setSelected(oldEntry);
        }
        double maxScroll = Math.max(0.0, (double)(super.method_25340() * this.field_22741 - this.field_22743));
        if (super.method_25341() > maxScroll) {
            super.method_25307(maxScroll);
        }
    }

    public class BiomeEntry
    extends BaseObjectSelectionList.Entry<BiomeEntry> {
        private final short id;
        private final String name;
        private int color;
        private boolean isCave;
        private final int initialColor;
        private final boolean initialIsCave;
        private final class_6880.class_6883<class_1959> entry;
        private PreviewData.DataSource dataSource;
        private final class_7919 tooltip;
        private final PreviewData.DataSource initialDataSource;
        private final boolean isPrimaryNamespace;

        public BiomeEntry(class_6880.class_6883<class_1959> entry, short id, int color, int initialColor, boolean isCave, boolean initialIsCave, String explicitName, PreviewData.DataSource dataSource) {
            this.entry = entry;
            this.id = id;
            this.color = color;
            this.initialColor = initialColor;
            this.isCave = isCave;
            this.initialIsCave = initialIsCave;
            this.dataSource = dataSource;
            this.initialDataSource = dataSource;
            class_2960 resourceLocation = entry.method_40237().method_29177();
            String langKey = resourceLocation.method_42093("biome");
            this.name = class_2477.method_10517().method_4678(langKey) ? class_2561.method_43471((String)langKey).getString() : (explicitName != null && !explicitName.isBlank() ? explicitName : WorldPreviewClient.toTitleCase(resourceLocation.method_12832().replace("_", " ")));
            this.isPrimaryNamespace = resourceLocation.method_12836().equals("minecraft");
            String tag = "\u00a75\u00a7o" + resourceLocation.method_12836() + "\u00a7r\n\u00a79" + resourceLocation.method_12832() + "\u00a7r";
            this.tooltip = class_7919.method_47407((class_2561)class_2561.method_43470((String)(this.name + "\n\n" + tag)));
        }

        public String name() {
            return this.name;
        }

        public class_2561 statusComponent() {
            return class_2561.method_43471((String)("world_preview.settings.biomes.source." + this.dataSource.name()));
        }

        public class_6880.class_6883<class_1959> entry() {
            return this.entry;
        }

        public short id() {
            return this.id;
        }

        public int color() {
            return this.color;
        }

        public boolean isCave() {
            return this.isCave;
        }

        public PreviewData.DataSource dataSource() {
            return this.dataSource;
        }

        public PreviewContainer previewTab() {
            return BiomesList.this.previewContainer;
        }

        @Override
        public class_7919 tooltip() {
            return this.tooltip;
        }

        public void reset() {
            this.color = this.initialColor;
            this.isCave = this.initialIsCave;
            this.dataSource = this.initialDataSource == PreviewData.DataSource.CONFIG ? PreviewData.DataSource.RESOURCE : this.initialDataSource;
        }

        public void changeColor(int newColor) {
            this.color = newColor & 0xFFFFFF;
            this.dataSource = PreviewData.DataSource.CONFIG;
        }

        public void setCave(boolean cave) {
            this.isCave = cave;
        }

        @NotNull
        public class_2561 method_37006() {
            return class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{this.name});
        }

        public void method_25343(@NotNull class_332 guiGraphics, int i, int j, int k, int l, int m, int n, int o, boolean bl, float f) {
            guiGraphics.method_25294(k + 3, j + 1, k + 13, j + 11, WorldPreview.nativeColor(this.color));
            Object formatName = this.isPrimaryNamespace ? this.name : "\u00a7o" + this.name;
            guiGraphics.method_25303(((BiomesList)BiomesList.this).field_22740.field_1772, (String)formatName, k + 16, j + 2, 0xFFFFFF);
        }

        public boolean method_25402(double d, double e, int i) {
            boolean isSelected;
            if (i != 0) {
                return false;
            }
            BiomesList.this.field_22740.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            boolean bl = isSelected = BiomesList.this.method_25334() != null && this.id == ((BiomeEntry)BiomesList.this.method_25334()).id;
            if (isSelected && BiomesList.this.allowDeselecting) {
                BiomesList.this.setSelected(null);
                return false;
            }
            return true;
        }
    }
}

