/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.client.gui.widgets;

import caeruleusTait.world.preview.RenderSettings;
import caeruleusTait.world.preview.WorldPreview;
import caeruleusTait.world.preview.WorldPreviewConfig;
import caeruleusTait.world.preview.backend.WorkManager;
import caeruleusTait.world.preview.backend.color.PreviewData;
import caeruleusTait.world.preview.backend.storage.PreviewSection;
import caeruleusTait.world.preview.backend.storage.PreviewStorage;
import caeruleusTait.world.preview.client.WorldPreviewClient;
import caeruleusTait.world.preview.client.WorldPreviewComponents;
import caeruleusTait.world.preview.client.gui.PreviewDisplayDataProvider;
import caeruleusTait.world.preview.client.gui.widgets.lists.BiomesList;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.shorts.Short2LongMap;
import it.unimi.dsi.fastutil.shorts.Short2LongOpenHashMap;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1144;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3341;
import net.minecraft.class_339;
import net.minecraft.class_3620;
import net.minecraft.class_364;
import net.minecraft.class_5250;
import net.minecraft.class_5742;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_8000;
import net.minecraft.class_8001;
import net.minecraft.class_8251;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class PreviewDisplay
extends class_339
implements AutoCloseable {
    private final class_310 minecraft;
    private final PreviewDisplayDataProvider dataProvider;
    private final WorkManager workManager;
    private final RenderSettings renderSettings;
    private final WorldPreviewConfig config;
    private Short2LongMap visibleBiomes;
    private Short2LongMap visibleStructures;
    private class_1011 previewImg;
    private class_1043 previewTexture;
    private long[] workingVisibleBiomes;
    private long[] workingVisibleStructures;
    private int[] colorMap;
    private int[] colorMapGrayScale;
    private int[] heightColorMap;
    private boolean[] cavesMap;
    private IconData[] structureIcons;
    private IconData playerIcon;
    private IconData spawnIcon;
    private class_1799[] structureItems;
    private PreviewDisplayDataProvider.StructureRenderInfo[] structureRenderInfoMap;
    private final class_1011 dummyIcon;
    private class_2561 coordinatesCopiedMsg = null;
    private Instant coordinatesCopiedTime = null;
    private int texWidth = 100;
    private int texHeight = 100;
    private short selectedBiomeId;
    private boolean highlightCaves;
    private double totalDragX = 0.0;
    private double totalDragZ = 0.0;
    private int scaleBlockPos = 1;
    private StructHoverHelperCell[] hoverHelperGrid;
    private final int hoverHelperGridCellSize = 64;
    private int hoverHelperGridWidth;
    private int hoverHelperGridHeight;
    private Queue<Long> frametimes = new ArrayDeque<Long>();
    private boolean clicked = false;

    public PreviewDisplay(class_310 minecraft, PreviewDisplayDataProvider dataProvider, class_2561 component) {
        super(0, 0, 100, 100, component);
        this.minecraft = minecraft;
        this.workManager = WorldPreview.get().workManager();
        this.dataProvider = dataProvider;
        this.visibleBiomes = new Short2LongOpenHashMap();
        this.visibleStructures = new Short2LongOpenHashMap();
        this.renderSettings = WorldPreview.get().renderSettings();
        this.config = WorldPreview.get().cfg();
        this.dummyIcon = new class_1011(16, 16, true);
        this.structureIcons = new IconData[0];
        this.resizeImage();
    }

    public void resizeImage() {
        this.closeDisplayTextures();
        this.previewImg = new class_1011(class_1011.class_1012.field_4997, this.texWidth, this.texHeight, true);
        this.previewTexture = new class_1043(this.previewImg);
        this.scaleBlockPos = 4 / this.renderSettings.quartExpand() * this.renderSettings.quartStride();
        this.hoverHelperGridWidth = this.texWidth / 64 + 1;
        this.hoverHelperGridHeight = this.texHeight / 64 + 1;
        this.hoverHelperGrid = new StructHoverHelperCell[this.hoverHelperGridWidth * this.hoverHelperGridHeight];
        for (int i = 0; i < this.hoverHelperGrid.length; ++i) {
            this.hoverHelperGrid[i] = new StructHoverHelperCell(new ArrayList<StructHoverHelperEntry>());
        }
    }

    public void setSize(int width, int height) {
        this.field_22758 = width;
        this.field_22759 = height;
        this.texWidth = this.field_22758 * (int)this.minecraft.method_22683().method_4495();
        this.texHeight = this.field_22759 * (int)this.minecraft.method_22683().method_4495();
        this.resizeImage();
    }

    public void reloadData() {
        this.closeIconTextures();
        PreviewData.BiomeData[] rawBiomeMap = this.dataProvider.previewData().biomeId2BiomeData();
        this.structureRenderInfoMap = this.dataProvider.renderStructureMap();
        this.structureItems = this.dataProvider.structureItems();
        this.structureIcons = (IconData[])Arrays.stream(this.dataProvider.structureIcons()).map(x -> new IconData((class_1011)x, new class_1043(x))).toArray(IconData[]::new);
        this.playerIcon = new IconData(this.dataProvider.playerIcon(), new class_1043(this.dataProvider.playerIcon()));
        this.spawnIcon = new IconData(this.dataProvider.spawnIcon(), new class_1043(this.dataProvider.spawnIcon()));
        this.playerIcon.texture.method_4524();
        this.spawnIcon.texture.method_4524();
        Arrays.stream(this.structureIcons).map(IconData::texture).forEach(class_1043::method_4524);
        try {
            this.heightColorMap = this.dataProvider.heightColorMap();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.workingVisibleBiomes = new long[rawBiomeMap.length];
        this.workingVisibleStructures = new long[this.structureIcons.length];
        this.colorMap = new int[rawBiomeMap.length];
        this.colorMapGrayScale = new int[rawBiomeMap.length];
        this.cavesMap = new boolean[rawBiomeMap.length];
        for (int i = 0; i < rawBiomeMap.length; i = (int)((short)(i + 1))) {
            this.colorMap[i] = PreviewDisplay.textureColor(rawBiomeMap[i].color());
            this.colorMapGrayScale[i] = PreviewDisplay.grayScale(this.colorMap[i]);
            this.cavesMap[i] = rawBiomeMap[i].isCave();
        }
    }

    private void closeIconTextures() {
        if (this.structureIcons != null) {
            Arrays.stream(this.structureIcons).forEach(IconData::close);
        }
        if (this.playerIcon != null) {
            this.playerIcon.texture.close();
        }
        if (this.spawnIcon != null) {
            this.spawnIcon.texture.close();
        }
    }

    private void closeDisplayTextures() {
        if (this.previewTexture != null) {
            this.previewTexture.close();
        }
        if (this.previewImg != null) {
            this.previewImg.close();
        }
    }

    @Override
    public void close() {
        this.closeIconTextures();
        this.closeDisplayTextures();
    }

    @NotNull
    protected class_8000 method_47937() {
        return class_8001.field_41687;
    }

    public class_2338 center() {
        if (this.totalDragX == 0.0 && this.totalDragZ == 0.0) {
            return this.renderSettings.center();
        }
        return new class_2338((int)((double)this.renderSettings.center().method_10263() + this.totalDragX), this.renderSettings.center().method_10264(), (int)((double)this.renderSettings.center().method_10260() + this.totalDragZ));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_48579(class_332 guiGraphics, int x, int y, float f) {
        int colorBorder = -10066330;
        int xMin = this.method_46426();
        int yMin = this.method_46427();
        int xMax = xMin + this.field_22758;
        int yMax = yMin + this.field_22759;
        double winWidth = this.minecraft.method_22683().method_4489();
        double winHeight = this.minecraft.method_22683().method_4506();
        double guiScale = this.minecraft.method_22683().method_4495();
        Instant renderStart = Instant.now();
        this.queueGeneration();
        PreviewDisplayDataProvider previewDisplayDataProvider = this.dataProvider;
        synchronized (previewDisplayDataProvider) {
            if (this.dataProvider.setupFailed()) {
                this.previewImg.method_4326(0, 0, this.texWidth, this.texHeight, -16777216);
                this.previewTexture.method_4524();
                WorldPreviewClient.renderTexture((class_1044)this.previewTexture, xMin, yMin, xMax, yMax);
                List<class_5250> lines = WorldPreviewComponents.MSG_ERROR_SETUP_FAILED.getString().lines().map(class_2561::method_43470).toList();
                int centerX = this.method_46426() + this.field_22758 / 2;
                int n = this.method_46427() + this.field_22759 / 2;
                int n2 = lines.size() / 2;
                Objects.requireNonNull(this.minecraft.field_1772);
                int centerY = n - n2 * (9 + 4);
                for (int i = 0; i < lines.size(); ++i) {
                    class_2561 line = (class_2561)lines.get(i);
                    Objects.requireNonNull(this.minecraft.field_1772);
                    int offsetY = i * (9 + 4);
                    guiGraphics.method_27534(this.minecraft.field_1772, line, centerX, centerY + offsetY, 0xFFFFFF);
                }
            } else if (this.dataProvider.isUpdating()) {
                this.previewImg.method_4326(0, 0, this.texWidth, this.texHeight, -16777216);
                this.previewTexture.method_4524();
                WorldPreviewClient.renderTexture((class_1044)this.previewTexture, xMin, yMin, xMax, yMax);
                int centerX = this.method_46426() + this.field_22758 / 2;
                int centerY = this.method_46427() + this.field_22759 / 2;
                guiGraphics.method_27534(this.minecraft.field_1772, WorldPreviewComponents.MSG_PREVIEW_SETUP_LOADING, centerX, centerY, 0xFFFFFF);
            } else {
                Arrays.fill(this.workingVisibleBiomes, 0L);
                Arrays.fill(this.workingVisibleStructures, 0L);
                Arrays.stream(this.hoverHelperGrid).forEach(cell -> cell.entries.clear());
                List<RenderHelper> renderData = this.generateRenderData();
                this.updateTexture(renderData);
                this.previewTexture.method_4524();
                WorldPreviewClient.renderTexture((class_1044)this.previewTexture, xMin, yMin, xMax, yMax);
                guiGraphics.method_44379(xMin, yMin, xMax, yMax);
                Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)winWidth, (float)winHeight, 0.0f, 1000.0f, 21000.0f);
                RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (class_8251)class_8251.field_43361);
                this.renderStructures(renderData, guiGraphics);
                this.renderPlayerAndSpawn();
                matrix4f = new Matrix4f().setOrtho(0.0f, (float)(winWidth / guiScale), (float)(winHeight / guiScale), 0.0f, 1000.0f, 21000.0f);
                RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (class_8251)class_8251.field_43361);
                guiGraphics.method_44380();
                double mouseX = this.minecraft.field_1729.method_1603() * (double)this.minecraft.method_22683().method_4486() / (double)this.minecraft.method_22683().method_4480();
                double mouseZ = this.minecraft.field_1729.method_1604() * (double)this.minecraft.method_22683().method_4502() / (double)this.minecraft.method_22683().method_4507();
                this.biomesChanged();
                this.updateTooltip(mouseX, mouseZ);
            }
        }
        guiGraphics.method_25294(xMin - 1, yMin - 1, xMax + 1, yMin, -10066330);
        guiGraphics.method_25294(xMax, yMin, xMax + 1, yMax, -10066330);
        guiGraphics.method_25294(xMin - 1, yMax, xMax + 1, yMax + 1, -10066330);
        guiGraphics.method_25294(xMin - 1, yMin, xMin, yMax, -10066330);
        if (this.coordinatesCopiedMsg != null) {
            guiGraphics.method_25294(xMin, yMax - 38, xMax, yMax - 19, -1442840576);
            guiGraphics.method_27534(this.minecraft.field_1772, this.coordinatesCopiedMsg, xMin + (xMax - xMin) / 2, yMax - 32, 0xFFFFFF);
            if (Duration.between(this.coordinatesCopiedTime, Instant.now()).toSeconds() >= 8L) {
                this.coordinatesCopiedMsg = null;
                this.coordinatesCopiedTime = null;
            }
        }
        Instant renderEnd = Instant.now();
        this.frametimes.add(Duration.between(renderStart, renderEnd).abs().toMillis());
        while (this.frametimes.size() > 30) {
            this.frametimes.poll();
        }
        long sum = this.frametimes.stream().reduce(0L, Long::sum);
        if (this.config.showFrameTime) {
            guiGraphics.method_25303(this.minecraft.field_1772, sum / (long)this.frametimes.size() + " ms", 5, 5, 0xFFFFFF);
        }
    }

    private TextureCoordinate blockToTexture(class_2338 blockPos) {
        class_2338 center = this.center();
        int xMin = center.method_10263() - this.texWidth * this.scaleBlockPos / 2 - 1;
        int zMin = center.method_10260() - this.texHeight * this.scaleBlockPos / 2 - 1;
        return new TextureCoordinate((blockPos.method_10263() - xMin) / 4 * 4 / this.scaleBlockPos, (blockPos.method_10260() - zMin) / 4 * 4 / this.scaleBlockPos);
    }

    private void putHoverStructEntry(TextureCoordinate pos, StructHoverHelperEntry entry) {
        int cellX = Math.max(0, Math.min(this.hoverHelperGridWidth - 1, pos.x / 64));
        int cellZ = Math.max(0, Math.min(this.hoverHelperGridHeight - 1, pos.z / 64));
        this.hoverHelperGrid[cellX * this.hoverHelperGridHeight + cellZ].entries.add(entry);
    }

    private void queueGeneration() {
        class_2338 center = this.center();
        int xMin = center.method_10263() - this.texWidth * this.scaleBlockPos / 2 - 1;
        int xMax = center.method_10263() + this.texWidth * this.scaleBlockPos / 2 + 1;
        int zMin = center.method_10260() - this.texHeight * this.scaleBlockPos / 2 - 1;
        int zMax = center.method_10260() + this.texHeight * this.scaleBlockPos / 2 + 1;
        int y = center.method_10264();
        this.workManager.queueRange(new class_2338(xMin, y, zMin), new class_2338(xMax, y, zMax));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RenderHelper> generateRenderData() {
        PreviewStorage storage;
        class_2338 center = this.center();
        int xMin = center.method_10263() - this.texWidth * this.scaleBlockPos / 2 - 1;
        int zMin = center.method_10260() - this.texHeight * this.scaleBlockPos / 2 - 1;
        int quartExpand = this.renderSettings.quartExpand();
        int quartStride = this.renderSettings.quartStride();
        int quartsInWidth = this.texWidth / quartExpand * quartStride;
        int quartsInHeight = this.texHeight / quartExpand * quartStride;
        int minQuartX = class_5742.method_33100((int)xMin);
        int minQuartZ = class_5742.method_33100((int)zMin);
        int maxQuartX = minQuartX + quartsInWidth;
        int maxQuartZ = minQuartZ + quartsInHeight;
        int quartX = minQuartX;
        int quartY = class_5742.method_33100((int)center.method_10264());
        int quartZ = minQuartZ;
        int sectionStartTexX = 0;
        int sectionStartTexZ = 0;
        ArrayList<RenderHelper> res = new ArrayList<RenderHelper>((quartsInWidth / 64 + 2) * (quartsInHeight / 64 + 2));
        PreviewStorage previewStorage = storage = this.workManager.previewStorage();
        synchronized (previewStorage) {
            while (true) {
                long flag = this.renderSettings.showHeightMap ? 2L : 0L;
                flag = this.renderSettings.showIntersections ? 3L : flag;
                int useY = this.renderSettings.showHeightMap ? 0 : quartY;
                PreviewSection dataSection = storage.section4(quartX, useY, quartZ, flag);
                PreviewSection structureSection = storage.section4(quartX, 0, quartZ, 1L);
                PreviewSection.AccessData accessData = dataSection.calcQuartOffsetData(quartX, quartZ, maxQuartX, maxQuartZ);
                res.add(new RenderHelper(dataSection, structureSection, accessData, sectionStartTexX, sectionStartTexZ));
                if (accessData.continueX()) {
                    int quartDiffX = accessData.maxX() - accessData.minX();
                    quartX += quartDiffX;
                    sectionStartTexX += quartDiffX * quartExpand / quartStride;
                    continue;
                }
                if (!accessData.continueZ()) break;
                int quartDiffZ = accessData.maxZ() - accessData.minZ();
                quartX = minQuartX;
                quartZ += quartDiffZ;
                sectionStartTexZ += quartDiffZ * quartExpand / quartStride;
                sectionStartTexX = 0;
            }
        }
        return res;
    }

    private void updateTexture(List<RenderHelper> renderData) {
        int texX = 0;
        int texZ = 0;
        int quartExpand = this.renderSettings.quartExpand();
        int quartStride = this.renderSettings.quartStride();
        for (RenderHelper r : renderData) {
            texX = r.sectionStartTexX;
            for (int x = r.accessData.minX(); x < r.accessData.maxX(); x += quartStride) {
                texZ = r.sectionStartTexZ;
                for (int z = r.accessData.minZ(); z < r.accessData.maxZ(); z += quartStride) {
                    short rawData = r.dataSection.get(x, z);
                    int color = -16777216;
                    if (rawData >= 0 && !this.renderSettings.showHeightMap && !this.renderSettings.showIntersections) {
                        int n = color = this.selectedBiomeId >= 0 || this.highlightCaves ? this.colorMapGrayScale[rawData] : this.colorMap[rawData];
                        if (this.selectedBiomeId == rawData || this.highlightCaves && this.cavesMap[rawData]) {
                            color = this.colorMap[rawData];
                        }
                        short s = rawData;
                        this.workingVisibleBiomes[s] = this.workingVisibleBiomes[s] + 1L;
                    } else if (rawData > Short.MIN_VALUE && this.renderSettings.showHeightMap) {
                        color = this.heightColorMap[rawData - this.dataProvider.yMin()];
                    } else if (this.renderSettings.showIntersections && rawData >= 0) {
                        color = class_3620.method_38479((int)rawData).field_16011;
                        color = PreviewDisplay.textureColor(color == 0 ? 0xFFFFFF : color);
                    } else if (this.renderSettings.showIntersections && rawData > Short.MIN_VALUE) {
                        color = class_3620.method_38479((int)(-rawData)).field_16011;
                        color = PreviewDisplay.highlightColor(PreviewDisplay.textureColor(color == 0 ? 0xFFFFFF : color));
                    }
                    if (quartExpand > 1) {
                        this.previewImg.method_4326(texX, texZ, Math.min(this.texWidth - texX, quartExpand), Math.min(this.texHeight - texZ, quartExpand), color);
                    } else {
                        this.previewImg.method_4305(texX, texZ, color);
                    }
                    texZ += quartExpand;
                }
                texX += quartExpand;
            }
        }
    }

    private void renderStructures(List<RenderHelper> renderData, class_332 guiGraphics) {
        if (!this.config.sampleStructures) {
            return;
        }
        double guiScale = this.minecraft.method_22683().method_4495();
        for (RenderHelper r : renderData) {
            for (PreviewSection.PreviewStruct structure : r.structureSection.structures()) {
                short id = structure.structureId();
                TextureCoordinate texCenter = this.blockToTexture(structure.center());
                IconData iconData = this.structureIcons[id];
                class_1011 icon = iconData.img;
                class_1043 iconTexture = iconData.texture;
                class_1799 item = this.structureItems[id];
                if (icon == null && item == null) continue;
                if (icon == null) {
                    icon = this.dummyIcon;
                }
                int xMin = -(icon.method_4307() / 2);
                int xMax = icon.method_4307() / 2 + 1 + this.texWidth;
                int zMin = -(icon.method_4323() / 2);
                int zMax = icon.method_4323() / 2 + 1 + this.texHeight;
                if (texCenter.x < xMin || texCenter.z < zMin || texCenter.x > xMax || texCenter.z > zMax) continue;
                short s = id;
                this.workingVisibleStructures[s] = this.workingVisibleStructures[s] + 1L;
                if (!this.structureRenderInfoMap[id].show() || this.renderSettings.hideAllStructures) continue;
                int texStartX = texCenter.x - icon.method_4307() / 2;
                int texStartZ = texCenter.z - icon.method_4323() / 2;
                int rXMin = (int)((double)texStartX + (double)this.method_46426() * guiScale);
                int rZMin = (int)((double)texStartZ + (double)this.method_46427() * guiScale);
                int rXMax = rXMin + icon.method_4307();
                int rZMax = rZMin + icon.method_4323();
                if (item != null) {
                    guiGraphics.method_51427(item, rXMin, rZMin);
                } else if (iconTexture != null) {
                    WorldPreviewClient.renderTexture((class_1044)iconTexture, rXMin, rZMin, rXMax, rZMax);
                }
                this.putHoverStructEntry(texCenter, new StructHoverHelperEntry(new class_3341(texStartX, 0, texStartZ, texStartX + icon.method_4307(), 0, texStartZ + icon.method_4323()), structure));
            }
        }
    }

    private void renderPlayerAndSpawn() {
        if (!this.config.showPlayer) {
            return;
        }
        PreviewDisplayDataProvider.PlayerData playerData = this.dataProvider.getPlayerData(this.minecraft.method_1548().method_44717());
        if (playerData.currentPos() != null) {
            this.renderStickyIcon(this.playerIcon, playerData.currentPos());
        }
        if (playerData.spawnPos() != null) {
            this.renderStickyIcon(this.spawnIcon, playerData.spawnPos());
        }
    }

    private void renderStickyIcon(IconData iconData, class_2338 pos) {
        double guiScale = this.minecraft.method_22683().method_4495();
        class_1011 icon = iconData.img;
        TextureCoordinate texCenter = this.blockToTexture(pos);
        texCenter = new TextureCoordinate(Math.max(0, Math.min(this.texWidth, texCenter.x)), Math.max(0, Math.min(this.texHeight, texCenter.z)));
        int texStartX = texCenter.x - icon.method_4307();
        int texStartZ = texCenter.z - icon.method_4323();
        int rXMin = (int)((double)texStartX + (double)this.method_46426() * guiScale);
        int rZMin = (int)((double)texStartZ + (double)this.method_46427() * guiScale);
        int rXMax = rXMin + icon.method_4307() * 2;
        int rZMax = rZMin + icon.method_4323() * 2;
        WorldPreviewClient.renderTexture((class_1044)iconData.texture, rXMin, rZMin, rXMax, rZMax);
    }

    private void biomesChanged() {
        short i;
        Short2LongOpenHashMap tempBiomesSet = new Short2LongOpenHashMap(this.workingVisibleBiomes.length);
        Short2LongOpenHashMap tempStructuresSet = new Short2LongOpenHashMap(this.workingVisibleStructures.length);
        for (i = 0; i < this.workingVisibleBiomes.length; i = (short)((short)(i + 1))) {
            if (this.workingVisibleBiomes[i] <= 0L) continue;
            tempBiomesSet.put(i, this.workingVisibleBiomes[i]);
        }
        for (i = 0; i < this.workingVisibleStructures.length; i = (short)(i + 1)) {
            if (this.workingVisibleStructures[i] <= 0L) continue;
            tempStructuresSet.put(i, this.workingVisibleStructures[i]);
        }
        if (!tempBiomesSet.equals(this.visibleBiomes)) {
            this.dataProvider.onVisibleBiomesChanged((Short2LongMap)tempBiomesSet);
        }
        if (!tempStructuresSet.equals(this.visibleStructures)) {
            this.dataProvider.onVisibleStructuresChanged((Short2LongMap)tempStructuresSet);
        }
        this.visibleBiomes = tempBiomesSet;
        this.visibleStructures = tempStructuresSet;
    }

    private HoverInfo hoveredBiome(double mouseX, double mouseY) {
        if (!this.field_22762 || this.workManager.previewStorage() == null) {
            return null;
        }
        int guiScale = (int)this.minecraft.method_22683().method_4495();
        class_2338 center = this.center();
        int xMin = center.method_10263() - this.texWidth / 2 * this.scaleBlockPos - 1;
        int zMin = center.method_10260() - this.texHeight / 2 * this.scaleBlockPos - 1;
        int xPos = (int)((mouseX - (double)this.method_46426()) * (double)guiScale * (double)this.scaleBlockPos);
        int zPos = (int)((mouseY - (double)this.method_46427()) * (double)guiScale * (double)this.scaleBlockPos);
        int quartX = class_5742.method_33100((int)(xMin + xPos));
        int quartY = class_5742.method_33100((int)center.method_10264());
        int quartZ = class_5742.method_33100((int)(zMin + zPos));
        short biome = this.workManager.previewStorage().getRawData4(quartX, quartY, quartZ, 0L);
        short height = this.workManager.previewStorage().getRawData4(quartX, 0, quartZ, 2L);
        if (biome < 0) {
            return new HoverInfo(xMin + xPos, center.method_10264(), zMin + zPos, null, height);
        }
        return new HoverInfo(xMin + xPos, center.method_10264(), zMin + zPos, this.dataProvider.biome4Id(biome), height);
    }

    private List<StructHoverHelperEntry> hoveredStructures(double mouseX, double mouseY) {
        if (!this.field_22762) {
            return List.of();
        }
        int guiScale = (int)this.minecraft.method_22683().method_4495();
        int xTexPos = (int)(mouseX - (double)this.method_46426()) * guiScale;
        int zTexPos = (int)(mouseY - (double)this.method_46427()) * guiScale;
        int xGridPos = xTexPos / 64;
        int zGridPos = zTexPos / 64;
        ArrayList<StructHoverHelperEntry> res = new ArrayList<StructHoverHelperEntry>();
        for (int x = xGridPos - 1; x <= xGridPos + 1; ++x) {
            for (int z = zGridPos - 1; z <= zGridPos + 1; ++z) {
                if (x < 0 || x >= this.hoverHelperGridWidth || z < 0 || z >= this.hoverHelperGridHeight) continue;
                StructHoverHelperCell cell = this.hoverHelperGrid[x * this.hoverHelperGridHeight + z];
                for (StructHoverHelperEntry entry : cell.entries) {
                    if (!entry.boundingBox.method_47593(xTexPos, 0, zTexPos)) continue;
                    res.add(entry);
                }
            }
        }
        return res;
    }

    private static String nameFormatter(String s) {
        int idx = s.indexOf(58);
        if (idx < 0) {
            return "\u00a7e" + s + "\u00a7r";
        }
        return String.format("\u00a75\u00a7o%s\u00a7r\u00a75:%s\u00a7r", s.substring(0, idx), s.substring(idx + 1));
    }

    private void updateTooltip(double mouseX, double mouseY) {
        String height;
        HoverInfo hoverInfo = this.hoveredBiome(mouseX, mouseY);
        List<StructHoverHelperEntry> structuresInfos = this.hoveredStructures(mouseX, mouseY);
        if (hoverInfo == null && structuresInfos.isEmpty()) {
            this.method_47400(null);
            return;
        }
        String blockPosTemplate = "\u00a73X=\u00a7b%d\u00a7r\u00a0\u00a73Y=\u00a7b%d\u00a7r\u00a0\u00a73Z=\u00a7b%d\u00a7r";
        if (!structuresInfos.isEmpty()) {
            PreviewSection.PreviewStruct structure = structuresInfos.get((int)0).structure;
            if (this.config.showControls) {
                this.method_47400(class_7919.method_47407((class_2561)class_2561.method_43469((String)"world_preview.preview-display.struct.tooltip.controls", (Object[])new Object[]{PreviewDisplay.nameFormatter(this.dataProvider.structure4Id(structure.structureId()).name()), blockPosTemplate.formatted(structure.center().method_10263(), structure.center().method_10264(), structure.center().method_10260())})));
            } else {
                this.method_47400(class_7919.method_47407((class_2561)class_2561.method_43469((String)"world_preview.preview-display.struct.tooltip", (Object[])new Object[]{PreviewDisplay.nameFormatter(this.dataProvider.structure4Id(structure.structureId()).name()), blockPosTemplate.formatted(structure.center().method_10263(), structure.center().method_10264(), structure.center().method_10260())})));
            }
            return;
        }
        String string = height = hoverInfo.height > Short.MIN_VALUE ? String.format("\u00a7b%d\u00a7r", hoverInfo.height) : "\u00a77<N/A>\u00a7r";
        if (this.config.showControls) {
            this.method_47400(class_7919.method_47407((class_2561)class_2561.method_43469((String)"world_preview.preview-display.tooltip.controls", (Object[])new Object[]{PreviewDisplay.nameFormatter(hoverInfo.entry == null ? "<N/A>" : hoverInfo.entry.name()), blockPosTemplate.formatted(hoverInfo.blockX, hoverInfo.blockY, hoverInfo.blockZ), height})));
        } else {
            this.method_47400(class_7919.method_47407((class_2561)class_2561.method_43469((String)"world_preview.preview-display.tooltip", (Object[])new Object[]{PreviewDisplay.nameFormatter(hoverInfo.entry == null ? "<N/A>" : hoverInfo.entry.name()), blockPosTemplate.formatted(hoverInfo.blockX, hoverInfo.blockY, hoverInfo.blockZ), height})));
        }
    }

    public void method_25354(class_1144 handler) {
    }

    public void method_25348(double mouseX, double mouseY) {
        if (this.minecraft.field_1755 != null) {
            this.minecraft.field_1755.method_25395((class_364)this);
        }
        this.clicked = true;
    }

    protected void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        double guiScale = this.minecraft.method_22683().method_4495();
        this.totalDragX -= dragX * guiScale * (double)this.scaleBlockPos;
        this.totalDragZ -= dragY * guiScale * (double)this.scaleBlockPos;
    }

    public void method_25357(double mouseX, double mouseY) {
        if (!this.clicked) {
            return;
        }
        this.clicked = false;
        if (Math.abs(this.totalDragX) <= 4.0 && Math.abs(this.totalDragZ) <= 4.0) {
            HoverInfo hoverInfo = this.hoveredBiome(mouseX, mouseY);
            if (hoverInfo == null || hoverInfo.entry == null) {
                return;
            }
            super.method_25354(this.minecraft.method_1483());
            if (this.selectedBiomeId == hoverInfo.entry.id()) {
                this.dataProvider.onBiomeVisuallySelected(null);
            } else {
                this.dataProvider.onBiomeVisuallySelected(hoverInfo.entry);
            }
        }
        this.renderSettings.setCenter(this.center());
        this.totalDragX = 0.0;
        this.totalDragZ = 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean method_25401(double mouseX, double mouseY, double delta) {
        PreviewDisplayDataProvider previewDisplayDataProvider = this.dataProvider;
        synchronized (previewDisplayDataProvider) {
            if (this.dataProvider.isUpdating()) {
                return true;
            }
            if (delta > 0.0) {
                this.renderSettings.decrementY();
            } else if (delta < 0.0) {
                this.renderSettings.incrementY();
            }
            return true;
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25361(mouseX, mouseY) && button == 1) {
            this.method_25354(this.minecraft.method_1483());
            HoverInfo hoverInfo = this.hoveredBiome(mouseX, mouseY);
            if (hoverInfo == null) {
                return true;
            }
            String coordinates = String.format("%s %s %s", hoverInfo.blockX, hoverInfo.height == Short.MIN_VALUE ? "~" : Short.valueOf(hoverInfo.height), hoverInfo.blockZ);
            this.minecraft.field_1774.method_1455(coordinates);
            this.coordinatesCopiedTime = Instant.now();
            this.coordinatesCopiedMsg = class_2561.method_43469((String)"world_preview.preview-display.coordinates.copied", (Object[])new Object[]{coordinates});
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private static int textureColor(int orig) {
        int R = orig >> 16 & 0xFF;
        int G = orig >> 8 & 0xFF;
        int B = orig >> 0 & 0xFF;
        return R << 0 | G << 8 | B << 16 | 0xFF000000;
    }

    private static int highlightColor(int orig) {
        int R = orig >> 16 & 0xFF;
        int G = orig >> 8 & 0xFF;
        int B = orig >> 0 & 0xFF;
        int diff = (R + G + B) / 3 > 200 ? -100 : 100;
        R += diff;
        G += diff;
        B += diff;
        R = Math.max(Math.min(R, 255), 0);
        G = Math.max(Math.min(G, 255), 0);
        B = Math.max(Math.min(B, 255), 0);
        return 0xFF000000 | R << 16 | G << 8 | B;
    }

    private static int grayScale(int orig) {
        int R = orig >> 16 & 0xFF;
        int G = orig >> 8 & 0xFF;
        int B = orig >> 0 & 0xFF;
        int gray = Math.max(32, Math.min(224, (R + G + B) / 3));
        return 0xFF000000 | gray << 16 | gray << 8 | gray;
    }

    public void setSelectedBiomeId(short biomeId) {
        this.selectedBiomeId = biomeId;
    }

    public void setHighlightCaves(boolean highlightCaves) {
        this.highlightCaves = highlightCaves;
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    private record IconData(@NotNull class_1011 img, @NotNull class_1043 texture) {
        public void close() {
            this.texture.close();
            this.img.close();
        }
    }

    private record StructHoverHelperCell(List<StructHoverHelperEntry> entries) {
    }

    private record TextureCoordinate(int x, int z) {
    }

    private record RenderHelper(PreviewSection dataSection, PreviewSection structureSection, PreviewSection.AccessData accessData, int sectionStartTexX, int sectionStartTexZ) {
    }

    private record StructHoverHelperEntry(class_3341 boundingBox, PreviewSection.PreviewStruct structure) {
    }

    private record HoverInfo(int blockX, int blockY, int blockZ, BiomesList.BiomeEntry entry, short height) {
    }
}

