/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.client.gui.widgets;

import caeruleusTait.world.preview.client.WorldPreviewClient;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import org.joml.Matrix4f;

public class ColorChooser
extends class_339 {
    public static final int INITIAL_SV_SQUARE_SIZE = 128;
    public static final int INITIAL_H_BAR_WIDTH = 16;
    public static final int SEPARATOR = 10;
    public static final int INITIAL_FINAL_COLOR_HEIGHT = 20;
    private int svSquareSize = 128;
    private int hBarWidth = 16;
    private int finalColorHeight = 20;
    private float hue = 0.0f;
    private float saturation = 0.0f;
    private float value = 0.0f;
    private int argbColor = -16777216;
    private int argbHueOnly = -16777216;
    private ColorUpdater updater;

    public ColorChooser(int x, int y) {
        super(x, y, 10, 10, class_5244.field_39003);
        this.recalculateSize();
    }

    private void recalculateSize() {
        this.field_22758 = this.svSquareSize + 10 + this.hBarWidth;
        this.field_22759 = this.svSquareSize + 10 + this.finalColorHeight;
    }

    public void setSquareSize(int squareSize) {
        float scalor = (float)squareSize / 128.0f;
        this.svSquareSize = squareSize;
        this.hBarWidth = (int)(16.0f * scalor);
        this.finalColorHeight = (int)(20.0f * scalor);
        this.recalculateSize();
    }

    public void method_48579(class_332 guiGraphics, int i, int j, float f) {
        guiGraphics.method_25294(this.method_46426() - 2, this.method_46427() - 2, this.method_46426() + this.field_22758 + 2, this.method_46427() + this.field_22759 + 2, 0x77000000);
        RenderSystem.setShader(() -> WorldPreviewClient.HSV_SHADER);
        Matrix4f posMatrix = guiGraphics.method_51448().method_23760().method_23761();
        int leftX = this.method_46426();
        int topY = this.method_46427();
        int rightX = leftX + this.svSquareSize;
        int botY = topY + this.svSquareSize;
        class_287 buffer = class_289.method_1348().method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22918(posMatrix, (float)leftX, (float)topY, 0.0f).method_22915(this.hue, 0.0f, 1.0f, 1.0f).method_1344();
        buffer.method_22918(posMatrix, (float)leftX, (float)botY, 0.0f).method_22915(this.hue, 0.0f, 0.0f, 1.0f).method_1344();
        buffer.method_22918(posMatrix, (float)rightX, (float)botY, 0.0f).method_22915(this.hue, 1.0f, 0.0f, 1.0f).method_1344();
        buffer.method_22918(posMatrix, (float)rightX, (float)topY, 0.0f).method_22915(this.hue, 1.0f, 1.0f, 1.0f).method_1344();
        class_289.method_1348().method_1350();
        int satX = leftX + Math.round(this.saturation * (float)this.svSquareSize);
        int valY = topY + Math.round((1.0f - this.value) * (float)this.svSquareSize);
        guiGraphics.method_25294(satX - 4, valY - 4, satX + 4, valY + 4, (double)this.value > 0.3 ? -16777216 : -1);
        guiGraphics.method_25294(satX - 3, valY - 3, satX + 3, valY + 3, this.argbColor);
        RenderSystem.setShader(() -> WorldPreviewClient.HSV_SHADER);
        leftX = rightX + 10;
        rightX = leftX + this.hBarWidth;
        buffer = class_289.method_1348().method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22918(posMatrix, (float)leftX, (float)topY, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_22918(posMatrix, (float)leftX, (float)botY, 0.0f).method_22915(0.0f, 1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_22918(posMatrix, (float)rightX, (float)botY, 0.0f).method_22915(0.0f, 1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_22918(posMatrix, (float)rightX, (float)topY, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
        class_289.method_1348().method_1350();
        int hueY = topY + Math.round((1.0f - this.hue) * (float)this.svSquareSize);
        guiGraphics.method_25294(leftX - 2, hueY - 4, rightX + 2, hueY + 4, -16777216);
        guiGraphics.method_25294(leftX - 1, hueY - 3, rightX + 1, hueY + 3, this.argbHueOnly);
        guiGraphics.method_25294(this.method_46426(), botY + 10, this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, this.argbColor);
    }

    public boolean mouseEvent(double mouseX, double mouseY, int button, boolean playSound) {
        if (!(this.field_22763 && this.field_22764 && this.method_25351(button) && this.method_25405(mouseX, mouseY))) {
            return false;
        }
        if (class_310.method_1551().field_1755 != null) {
            class_310.method_1551().field_1755.method_25395((class_364)this);
        }
        double leftX = this.method_46426();
        double topY = this.method_46427();
        double rightX = leftX + (double)this.svSquareSize;
        double botY = topY + (double)this.svSquareSize;
        boolean updated = false;
        if (mouseX >= leftX && mouseX <= rightX && mouseY >= topY && mouseY <= botY) {
            if (playSound) {
                this.method_25354(class_310.method_1551().method_1483());
            }
            this.value = 1.0f - (float)((mouseY - topY) / (botY - topY));
            this.saturation = (float)((mouseX - leftX) / (rightX - leftX));
            updated = true;
        }
        leftX = rightX + 10.0;
        rightX = leftX + (double)this.hBarWidth;
        if (mouseX >= leftX && mouseX <= rightX && mouseY >= topY && mouseY <= botY) {
            if (playSound) {
                this.method_25354(class_310.method_1551().method_1483());
            }
            this.hue = 1.0f - (float)((mouseY - topY) / (botY - topY));
            updated = true;
        }
        this.argbColor = Color.HSBtoRGB(this.hue, this.saturation, this.value);
        this.argbHueOnly = Color.HSBtoRGB(this.hue, 1.0f, 1.0f);
        if (updated) {
            this.runUpdater();
        }
        return updated;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.mouseEvent(mouseX, mouseY, button, true);
    }

    protected void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        this.mouseEvent(mouseX, mouseY, 0, false);
    }

    public void runUpdater() {
        if (this.updater == null) {
            return;
        }
        this.updater.doUpdate((int)(this.hue * 360.0f), (int)(this.saturation * 100.0f), (int)(this.value * 100.0f));
    }

    public void setUpdater(ColorUpdater updater) {
        this.updater = updater;
    }

    public void updateHSV(int h, int s, int v) {
        this.hue = (float)h / 360.0f;
        this.saturation = (float)s / 100.0f;
        this.value = (float)v / 100.0f;
        this.argbColor = Color.HSBtoRGB(this.hue, this.saturation, this.value);
        this.argbHueOnly = Color.HSBtoRGB(this.hue, 1.0f, 1.0f);
        this.runUpdater();
    }

    public void updateRGB(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb >> 0 & 0xFF;
        float[] hsv = Color.RGBtoHSB(r, g, b, null);
        this.hue = hsv[0];
        this.saturation = hsv[1];
        this.value = hsv[2];
        this.argbColor = Color.HSBtoRGB(this.hue, this.saturation, this.value);
        this.argbHueOnly = Color.HSBtoRGB(this.hue, 1.0f, 1.0f);
        this.runUpdater();
    }

    public int colorRGB() {
        return this.argbColor & 0xFFFFFF;
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public static interface ColorUpdater {
        public void doUpdate(int var1, int var2, int var3);
    }
}

