/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.client.gui.screens.settings;

import caeruleusTait.world.preview.WorldPreview;
import caeruleusTait.world.preview.WorldPreviewConfig;
import caeruleusTait.world.preview.backend.color.ColorMap;
import caeruleusTait.world.preview.backend.color.PreviewData;
import caeruleusTait.world.preview.client.WorldPreviewClient;
import caeruleusTait.world.preview.client.WorldPreviewComponents;
import caeruleusTait.world.preview.client.gui.widgets.WGCheckbox;
import caeruleusTait.world.preview.client.gui.widgets.WGLabel;
import caeruleusTait.world.preview.client.gui.widgets.lists.AbstractSelectionListHolder;
import caeruleusTait.world.preview.client.gui.widgets.lists.BaseObjectSelectionList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_6880;
import net.minecraft.class_7919;
import net.minecraft.class_8030;
import net.minecraft.class_8087;
import org.jetbrains.annotations.NotNull;

public class HeightmapTab
implements class_8087 {
    private final WorldPreviewConfig cfg;
    private final WGLabel disabledWarning;
    private final WGLabel presetsHead;
    private final HeightPresetList heightPresetList;
    private final AbstractSelectionListHolder<HeightPresetList.HeightPresetEntry, HeightPresetList> heightPresetListHolder;
    private final class_342 minYBox;
    private final class_342 maxYBox;
    private final WGLabel minYLabel;
    private final WGLabel maxYLabel;
    private final WGCheckbox visualYRange;
    private final WGLabel colormapHead;
    private final ColormapList colormapList;
    private final AbstractSelectionListHolder<ColormapList.ColormapEntry, ColormapList> colormapListHolder;
    private final List<class_339> toRender = new ArrayList<class_339>();

    public HeightmapTab(class_310 minecraft, PreviewData previewData) {
        this.cfg = WorldPreview.get().cfg();
        class_327 font = minecraft.field_1772;
        this.disabledWarning = new WGLabel(font, 0, 0, 100, 20, WGLabel.TextAlignment.CENTER, WorldPreviewComponents.SETTINGS_HEIGHTMAP_DISABLED, 0xFFFFFF);
        this.toRender.add(this.disabledWarning);
        this.presetsHead = new WGLabel(font, 0, 0, 100, 10, WGLabel.TextAlignment.CENTER, WorldPreviewComponents.SETTINGS_HEIGHTMAP_PRESETS, 0xFFFFFF);
        this.colormapHead = new WGLabel(font, 0, 0, 100, 10, WGLabel.TextAlignment.CENTER, WorldPreviewComponents.SETTINGS_HEIGHTMAP_COLORMAP, 0xFFFFFF);
        this.toRender.add(this.presetsHead);
        this.toRender.add(this.colormapHead);
        this.minYBox = new class_342(font, 0, 0, 100, 20, WorldPreviewComponents.SETTINGS_HEIGHTMAP_MIN_Y);
        this.maxYBox = new class_342(font, 0, 0, 100, 20, WorldPreviewComponents.SETTINGS_HEIGHTMAP_MAX_Y);
        this.minYBox.method_47400(class_7919.method_47407((class_2561)WorldPreviewComponents.SETTINGS_HEIGHTMAP_MIN_Y_TOOLTIP));
        this.maxYBox.method_47400(class_7919.method_47407((class_2561)WorldPreviewComponents.SETTINGS_HEIGHTMAP_MAX_Y_TOOLTIP));
        this.minYBox.method_1890(HeightmapTab::isInteger);
        this.maxYBox.method_1890(HeightmapTab::isInteger);
        this.minYBox.method_1852(String.valueOf(this.cfg.heightmapMinY));
        this.maxYBox.method_1852(String.valueOf(this.cfg.heightmapMaxY));
        this.minYBox.method_1863(x -> {
            this.cfg.heightmapMinY = x.isBlank() ? 0 : Integer.parseInt(x);
        });
        this.maxYBox.method_1863(x -> {
            this.cfg.heightmapMaxY = x.isBlank() ? 0 : Integer.parseInt(x);
        });
        this.toRender.add((class_339)this.minYBox);
        this.toRender.add((class_339)this.maxYBox);
        this.minYLabel = new WGLabel(font, 0, 0, 64, 20, WGLabel.TextAlignment.LEFT, WorldPreviewComponents.SETTINGS_HEIGHTMAP_MIN_Y, 0xFFFFFF);
        this.maxYLabel = new WGLabel(font, 0, 0, 64, 20, WGLabel.TextAlignment.LEFT, WorldPreviewComponents.SETTINGS_HEIGHTMAP_MAX_Y, 0xFFFFFF);
        this.minYLabel.method_47400(class_7919.method_47407((class_2561)WorldPreviewComponents.SETTINGS_HEIGHTMAP_MIN_Y_TOOLTIP));
        this.maxYLabel.method_47400(class_7919.method_47407((class_2561)WorldPreviewComponents.SETTINGS_HEIGHTMAP_MAX_Y_TOOLTIP));
        this.toRender.add(this.minYLabel);
        this.toRender.add(this.maxYLabel);
        this.visualYRange = new WGCheckbox(0, 0, 100, 20, WorldPreviewComponents.SETTINGS_HEIGHTMAP_VISUAL, x -> {
            this.cfg.onlySampleInVisualRange = x.method_20372();
        }, this.cfg.onlySampleInVisualRange);
        this.visualYRange.method_47400(class_7919.method_47407((class_2561)WorldPreviewComponents.SETTINGS_HEIGHTMAP_VISUAL_TOOLTIP));
        this.toRender.add((class_339)this.visualYRange);
        this.heightPresetList = new HeightPresetList(minecraft, 100, 100, 0, 0);
        this.heightPresetList.method_25314(previewData.heightmapPresets().stream().map(entry -> this.heightPresetList.createEntry(entry.name(), entry.minY(), entry.maxY(), x -> {
            this.cfg.heightmapMinY = x.minY;
            this.cfg.heightmapMaxY = x.maxY;
            this.minYBox.method_1852(String.valueOf(x.minY));
            this.maxYBox.method_1852(String.valueOf(x.maxY));
        })).toList());
        this.heightPresetListHolder = new AbstractSelectionListHolder(this.heightPresetList, 0, 0, 100, 100, (class_2561)class_2561.method_43473());
        this.toRender.add(this.heightPresetListHolder);
        this.colormapList = new ColormapList(minecraft, 100, 100, 0, 0);
        Map<String, ColormapList.ColormapEntry> colormaps = previewData.colorMaps().values().stream().map(colorMap -> this.colormapList.createEntry((ColorMap)colorMap, x -> {
            this.cfg.colorMap = x.colorMap.key().toString();
        })).collect(Collectors.toMap(x -> x.colorMap.key().toString(), x -> x));
        this.colormapList.method_25314(colormaps.values().stream().sorted(Comparator.comparing(x -> x.name)).toList());
        this.colormapList.method_25313((class_350.class_351)colormaps.get(this.cfg.colorMap));
        this.colormapListHolder = new AbstractSelectionListHolder(this.colormapList, 0, 0, 100, 100, (class_2561)class_2561.method_43473());
        this.toRender.add(this.colormapListHolder);
    }

    private static boolean isInteger(String s) {
        if (s.isBlank()) {
            return true;
        }
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @NotNull
    public class_2561 method_48610() {
        return WorldPreviewComponents.SETTINGS_HEIGHTMAP_TITLE;
    }

    public void method_48612(Consumer<class_339> consumer) {
        this.toRender.forEach(consumer);
    }

    public void method_48611(class_8030 screenRectangle) {
        int bottomL;
        int topL;
        int center = screenRectangle.comp_1196() / 2;
        int leftL = screenRectangle.method_49620() + 3;
        int leftR = center + 3;
        int topR = topL = screenRectangle.method_49618() + 2;
        int bottomR = bottomL = screenRectangle.method_49619() - 36;
        int secWidth = screenRectangle.comp_1196() / 2 - leftL - 4;
        if (this.cfg.sampleHeightmap) {
            this.disabledWarning.field_22764 = false;
        } else {
            this.disabledWarning.field_22764 = true;
            this.disabledWarning.method_48229(screenRectangle.method_49620(), topL);
            this.disabledWarning.method_25358(screenRectangle.comp_1196());
            topR = topL += 24;
        }
        int labelWidth = 100;
        this.visualYRange.method_48229(leftL, bottomL);
        this.visualYRange.method_25358(secWidth);
        this.maxYLabel.method_48229(leftL, bottomL -= 24);
        this.maxYLabel.method_25358(100);
        this.maxYBox.method_48229(leftL + 100, bottomL);
        this.maxYBox.method_25358(secWidth - 100);
        this.minYLabel.method_48229(leftL, bottomL -= 24);
        this.minYLabel.method_25358(100);
        this.minYBox.method_48229(leftL + 100, bottomL);
        this.minYBox.method_25358(secWidth - 100);
        this.presetsHead.method_48229(leftL, topL);
        this.presetsHead.method_25358(secWidth);
        this.heightPresetListHolder.method_48229(leftL, topL += 14);
        this.heightPresetListHolder.setSize(secWidth, bottomL - topL - 4);
        this.heightPresetList.method_31322(true);
        this.heightPresetList.method_31323(false);
        this.colormapHead.method_48229(leftR, topR);
        this.colormapHead.method_25358(secWidth);
        this.colormapListHolder.method_48229(leftR, topR += 14);
        this.colormapListHolder.setSize(secWidth, bottomR - topR + 20);
        this.colormapList.method_31322(true);
        this.colormapList.method_31323(false);
    }

    public static class HeightPresetList
    extends BaseObjectSelectionList<HeightPresetEntry> {
        public HeightPresetList(class_310 minecraft, int width, int height, int x, int y) {
            super(minecraft, width, height, x, y, 16);
        }

        public HeightPresetEntry createEntry(String name, int minY, int maxY, Consumer<HeightPresetEntry> onClick) {
            return new HeightPresetEntry(name, minY, maxY, onClick);
        }

        public class HeightPresetEntry
        extends BaseObjectSelectionList.Entry<HeightPresetEntry> {
            public final String name;
            public final int minY;
            public final int maxY;
            private final Consumer<HeightPresetEntry> onClick;
            private final String displayString;

            public HeightPresetEntry(String name, int minY, int maxY, Consumer<HeightPresetEntry> onClick) {
                this.name = name;
                this.minY = minY;
                this.maxY = maxY;
                this.onClick = onClick;
                this.displayString = String.format("%s: \u00a73y=\u00a7b%d\u00a7r\u00a73-\u00a7b%d\u00a7r", this.name, this.minY, this.maxY);
            }

            @NotNull
            public class_2561 method_37006() {
                return class_2561.method_43473();
            }

            public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean bl, float partialTick) {
                guiGraphics.method_25303(((HeightPresetList)HeightPresetList.this).field_22740.field_1772, this.displayString, left + 4, top + 2, 0xFFFFFF);
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                HeightPresetList.this.field_22740.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                this.onClick.accept(this);
                return true;
            }
        }
    }

    public static class ColormapList
    extends BaseObjectSelectionList<ColormapEntry> {
        public ColormapList(class_310 minecraft, int width, int height, int x, int y) {
            super(minecraft, width, height, x, y, 32);
        }

        public ColormapEntry createEntry(ColorMap colorMap, Consumer<ColormapEntry> onClick) {
            return new ColormapEntry(colorMap, onClick);
        }

        public class ColormapEntry
        extends BaseObjectSelectionList.Entry<ColormapEntry> {
            public final String name;
            public final ColorMap colorMap;
            private final Consumer<ColormapEntry> onClick;
            private final class_1011 colormapImg;
            private final class_1043 colormapTexture;

            public ColormapEntry(ColorMap colorMap, Consumer<ColormapEntry> onClick) {
                this.name = colorMap.name();
                this.colorMap = colorMap;
                this.onClick = onClick;
                this.colormapImg = new class_1011(class_1011.class_1012.field_4997, 1024, 1, true);
                this.colormapTexture = new class_1043(this.colormapImg);
                for (int i = 0; i < 1024; ++i) {
                    this.colormapImg.method_4305(i, 0, colorMap.getARGB((float)i / 1024.0f));
                }
                this.colormapTexture.method_4524();
            }

            @NotNull
            public class_2561 method_37006() {
                return class_2561.method_43473();
            }

            public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean bl, float partialTick) {
                guiGraphics.method_25303(((ColormapList)ColormapList.this).field_22740.field_1772, this.name, left + 4, top + 2, 0xFFFFFF);
                int xMin = left + 5;
                int yMin = top + 14;
                int xMax = left + width - 5;
                int yMax = top + height - 3;
                WorldPreviewClient.renderTexture((class_1044)this.colormapTexture, xMin, yMin, xMax, yMax);
                int colorBorder = -6710887;
                guiGraphics.method_25294(xMin - 1, yMin - 1, xMax + 1, yMin, -6710887);
                guiGraphics.method_25294(xMax, yMin, xMax + 1, yMax, -6710887);
                guiGraphics.method_25294(xMin - 1, yMax, xMax + 1, yMax + 1, -6710887);
                guiGraphics.method_25294(xMin - 1, yMin, xMin, yMax, -6710887);
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                ColormapList.this.field_22740.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                this.onClick.accept(this);
                return true;
            }
        }
    }
}

