/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.client.gui.screens.settings;

import caeruleusTait.world.preview.WorldPreview;
import caeruleusTait.world.preview.backend.color.PreviewData;
import caeruleusTait.world.preview.client.WorldPreviewComponents;
import caeruleusTait.world.preview.client.gui.screens.PreviewContainer;
import caeruleusTait.world.preview.client.gui.widgets.ColorChooser;
import caeruleusTait.world.preview.client.gui.widgets.WGCheckbox;
import caeruleusTait.world.preview.client.gui.widgets.WGLabel;
import caeruleusTait.world.preview.client.gui.widgets.lists.AbstractSelectionListHolder;
import caeruleusTait.world.preview.client.gui.widgets.lists.BiomesList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5676;
import net.minecraft.class_6880;
import net.minecraft.class_7843;
import net.minecraft.class_7845;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import net.minecraft.class_8087;
import org.jetbrains.annotations.NotNull;

public class BiomesTab
implements class_8087 {
    private final PreviewContainer previewContainer;
    private final class_310 minecraft;
    private final class_7845 layout = new class_7845();
    private final BiomesList biomesList;
    private final AbstractSelectionListHolder<BiomesList.BiomeEntry, BiomesList> biomesListHolder;
    private final class_5676<BiomeListFilter> filterCycleButton;
    private final List<class_339> toRender = new ArrayList<class_339>();
    private final ColorChooser colorChooser;
    private BiomesList.BiomeEntry selectedEntry;
    private boolean blockUpdates = false;
    private final class_4185 resetBtn;
    private final class_4185 applyBtn;
    private final WGCheckbox isCaveCB;

    public BiomesTab(class_310 _minecraft, PreviewContainer _previewTab) {
        this.previewContainer = _previewTab;
        this.minecraft = _minecraft;
        class_327 font = this.minecraft.field_1772;
        this.biomesList = new BiomesList(this.previewContainer, this.minecraft, 100, 100, 0, 0, false);
        this.biomesListHolder = new AbstractSelectionListHolder(this.biomesList, 0, 0, 100, 100, WorldPreviewComponents.SETTINGS_BIOMES_TITLE);
        this.toRender.add(this.biomesListHolder);
        this.colorChooser = new ColorChooser(0, 0);
        this.toRender.add(this.colorChooser);
        int EDIT_WIDTH = 36;
        int LABEL_WIDTH = 75;
        int COLUMN_SPACING = 8;
        int FULL_WIDTH = 120;
        this.filterCycleButton = class_5676.method_32606(BiomeListFilter::toComponent).method_32624((Object[])BiomeListFilter.values()).method_32619((Object)BiomeListFilter.DIMENSION).method_32617(0, 0, 120, 20, WorldPreviewComponents.COLOR_LIST_FILTER, (b, v) -> this.biomesList.method_25314((Collection<BiomesList.BiomeEntry>)v.apply(this.previewContainer.allBiomes())));
        this.toRender.add((class_339)this.filterCycleButton);
        WGLabel statusLabel = new WGLabel(font, 0, 0, 120, 20, WGLabel.TextAlignment.CENTER, (class_2561)class_2561.method_43470((String)""), -5592406);
        class_342 hueBox = new class_342(font, 0, 0, 36, 20, WorldPreviewComponents.COLOR_HUE);
        class_342 satBox = new class_342(font, 0, 0, 36, 20, WorldPreviewComponents.COLOR_SAT);
        class_342 valBox = new class_342(font, 0, 0, 36, 20, WorldPreviewComponents.COLOR_VAL);
        this.isCaveCB = new WGCheckbox(0, 0, 120, 20, WorldPreviewComponents.COLOR_CAVE, x -> this.updateStatus(), false);
        this.resetBtn = class_4185.method_46430((class_2561)WorldPreviewComponents.COLOR_RESET, x -> {
            this.selectedEntry.reset();
            this.isCaveCB.setSelected(this.selectedEntry.isCave());
            this.colorChooser.updateRGB(this.selectedEntry.color());
            statusLabel.setText(this.selectedEntry.statusComponent());
        }).method_46432(120).method_46431();
        this.applyBtn = class_4185.method_46430((class_2561)WorldPreviewComponents.COLOR_APPLY, x -> {
            this.selectedEntry.changeColor(this.colorChooser.colorRGB());
            this.selectedEntry.setCave(this.isCaveCB.method_20372());
            this.colorChooser.updateRGB(this.selectedEntry.color());
            statusLabel.setText(this.selectedEntry.statusComponent());
        }).method_46432(120).method_46431();
        hueBox.method_1890(x -> this.validateMaxInt((String)x, 360));
        satBox.method_1890(x -> this.validateMaxInt((String)x, 100));
        valBox.method_1890(x -> this.validateMaxInt((String)x, 100));
        Consumer<String> hsvConsumer = x -> {
            if (!this.blockUpdates) {
                this.colorChooser.updateHSV(this.intOrZero(hueBox.method_1882()), this.intOrZero(satBox.method_1882()), this.intOrZero(valBox.method_1882()));
                this.colorChooser.runUpdater();
            }
        };
        hueBox.method_1863(hsvConsumer);
        satBox.method_1863(hsvConsumer);
        valBox.method_1863(hsvConsumer);
        this.colorChooser.setUpdater((h, s, v) -> {
            try {
                this.blockUpdates = true;
                this.updateIfChanged(hueBox, h);
                this.updateIfChanged(satBox, s);
                this.updateIfChanged(valBox, v);
                this.updateStatus();
            }
            finally {
                this.blockUpdates = false;
            }
        });
        this.biomesList.setBiomeChangeListener(biomeEntry -> {
            this.selectedEntry = biomeEntry;
            if (this.selectedEntry != null) {
                this.colorChooser.updateRGB(this.selectedEntry.color());
                this.isCaveCB.setSelected(this.selectedEntry.isCave());
                statusLabel.setText(this.selectedEntry.statusComponent());
            }
        });
        this.biomesList.setSelected(this.previewContainer.allBiomes().isEmpty() ? null : this.previewContainer.allBiomes().get(0));
        this.layout.method_48636(4).method_48635(8);
        class_7845.class_7939 rowHelper = this.layout.method_47610(2);
        rowHelper.method_47612((class_8021)new WGLabel(font, 0, 0, 75, 20, WGLabel.TextAlignment.LEFT, WorldPreviewComponents.COLOR_HUE, -1));
        rowHelper.method_47612((class_8021)hueBox);
        rowHelper.method_47612((class_8021)new WGLabel(font, 0, 0, 75, 20, WGLabel.TextAlignment.LEFT, WorldPreviewComponents.COLOR_SAT, -1));
        rowHelper.method_47612((class_8021)satBox);
        rowHelper.method_47612((class_8021)new WGLabel(font, 0, 0, 75, 20, WGLabel.TextAlignment.LEFT, WorldPreviewComponents.COLOR_VAL, -1));
        rowHelper.method_47612((class_8021)valBox);
        rowHelper.method_47612((class_8021)new WGLabel(font, 0, 0, 75, 10, WGLabel.TextAlignment.LEFT, (class_2561)class_2561.method_43470((String)""), 0xFFFFFF));
        rowHelper.method_47613((class_8021)this.isCaveCB, 2);
        rowHelper.method_47613((class_8021)this.resetBtn, 2);
        rowHelper.method_47613((class_8021)this.applyBtn, 2);
        rowHelper.method_47612((class_8021)new WGLabel(font, 0, 0, 75, 10, WGLabel.TextAlignment.LEFT, (class_2561)class_2561.method_43470((String)""), 0xFFFFFF));
        rowHelper.method_47613((class_8021)statusLabel, 2);
    }

    private void updateStatus() {
        if (this.selectedEntry != null) {
            this.resetBtn.field_22763 = this.selectedEntry.color() != this.colorChooser.colorRGB() || this.selectedEntry.isCave() != this.isCaveCB.method_20372() || this.selectedEntry.dataSource() == PreviewData.DataSource.CONFIG;
            this.applyBtn.field_22763 = this.selectedEntry.color() != this.colorChooser.colorRGB() || this.selectedEntry.isCave() != this.isCaveCB.method_20372();
            this.isCaveCB.field_22763 = true;
        } else {
            this.resetBtn.field_22763 = false;
            this.applyBtn.field_22763 = false;
            this.isCaveCB.field_22763 = false;
        }
    }

    @NotNull
    public class_2561 method_48610() {
        return WorldPreviewComponents.SETTINGS_BIOMES_TITLE;
    }

    public void method_48612(Consumer<class_339> consumer) {
        this.toRender.forEach(consumer);
        this.layout.method_48206(consumer);
    }

    public void method_48611(class_8030 screenRectangle) {
        int leftWidth = screenRectangle.comp_1196() / 3;
        int left = screenRectangle.method_49620() + 3;
        int top = screenRectangle.method_49618() + 2;
        int bottom = screenRectangle.method_49619() - 8;
        this.filterCycleButton.method_48229(left, top);
        this.filterCycleButton.method_25358(leftWidth);
        int listTop = top + 20 + 4;
        this.biomesListHolder.method_48229(left, listTop);
        this.biomesListHolder.setSize(leftWidth, bottom - listTop - 4);
        this.biomesList.method_31322(true);
        this.biomesList.method_31323(false);
        this.biomesList.method_25314((Collection<BiomesList.BiomeEntry>)((BiomeListFilter)((Object)this.filterCycleButton.method_32603())).apply(this.previewContainer.allBiomes()));
        this.colorChooser.setSquareSize(screenRectangle.comp_1196() / 4);
        this.colorChooser.method_48229(left + leftWidth + 8, top + (bottom - top) / 2 - this.colorChooser.method_25364() / 2);
        this.layout.method_48222();
        left = this.colorChooser.method_46426() + this.colorChooser.method_25368();
        class_8030 controlRectangle = new class_8030(left, top + 2, screenRectangle.method_49621() - left + 16, bottom - top - 2);
        class_7843.method_49617((class_8021)this.layout, (class_8030)controlRectangle, (float)0.5f, (float)0.5f);
    }

    private boolean validateMaxInt(String in, int max) {
        if (in.isBlank()) {
            return true;
        }
        try {
            int i = Integer.parseInt(in);
            return i >= 0 && i <= max;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private int intOrZero(String src) {
        return src.isBlank() ? 0 : Integer.parseInt(src);
    }

    private void updateIfChanged(class_342 box, int value) {
        String strValue = String.valueOf(value);
        if (!box.method_1882().equals(strValue)) {
            box.method_1852(strValue);
        }
    }

    public static enum BiomeListFilter {
        DIMENSION(x -> {
            class_5363 levelStem = (class_5363)x.previewTab().levelStemRegistry().method_10223(WorldPreview.get().renderSettings().dimension);
            if (levelStem == null) {
                return true;
            }
            Set supportedBiomes = levelStem.comp_1013().method_12098().method_28443().stream().map(class_6880::method_40230).map(Optional::orElseThrow).map(class_5321::method_29177).collect(Collectors.toSet());
            return supportedBiomes.contains(x.entry().method_40237().method_29177());
        }),
        ALL(x -> true),
        MISSING(x -> x.dataSource() == PreviewData.DataSource.MISSING),
        CUSTOM(x -> x.dataSource() == PreviewData.DataSource.CONFIG),
        MISSING_CUSTOM(x -> x.dataSource() == PreviewData.DataSource.MISSING || x.dataSource() == PreviewData.DataSource.CONFIG),
        DATA_PACK(x -> x.dataSource() == PreviewData.DataSource.RESOURCE),
        DATA_PACK_CUSTOM(x -> x.dataSource() == PreviewData.DataSource.RESOURCE || x.dataSource() == PreviewData.DataSource.CONFIG);

        private final Predicate<BiomesList.BiomeEntry> filterFn;

        private BiomeListFilter(Predicate<BiomesList.BiomeEntry> filterFn) {
            this.filterFn = filterFn;
        }

        public List<BiomesList.BiomeEntry> apply(List<BiomesList.BiomeEntry> orig) {
            return orig.stream().filter(this.filterFn).toList();
        }

        public static class_2561 toComponent(BiomeListFilter x) {
            return class_2561.method_43471((String)("world_preview.settings.biomes.filter." + x.name()));
        }
    }
}

