/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.client.gui.screens;

import caeruleusTait.world.preview.WorldPreview;
import caeruleusTait.world.preview.backend.storage.PreviewStorage;
import caeruleusTait.world.preview.client.WorldPreviewComponents;
import caeruleusTait.world.preview.client.gui.PreviewContainerDataProvider;
import caeruleusTait.world.preview.client.gui.screens.PreviewCacheLoadingScreen;
import caeruleusTait.world.preview.client.gui.screens.PreviewContainer;
import caeruleusTait.world.preview.mixin.client.CreateWorldScreenAccessor;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3283;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_525;
import net.minecraft.class_5285;
import net.minecraft.class_5317;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_7145;
import net.minecraft.class_7193;
import net.minecraft.class_7237;
import net.minecraft.class_7659;
import net.minecraft.class_7712;
import net.minecraft.class_7723;
import net.minecraft.class_7726;
import net.minecraft.class_7780;
import net.minecraft.class_7924;
import net.minecraft.class_8030;
import net.minecraft.class_8087;
import net.minecraft.class_8100;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreviewTab
implements class_8087,
AutoCloseable,
PreviewContainerDataProvider {
    private final class_525 createWorldScreen;
    private final class_8100 uiState;
    private final PreviewContainer previewContainer;
    private final WorldPreview worldPreview = WorldPreview.get();
    private final class_310 minecraft;
    private final Executor loadingExecutor = Executors.newFixedThreadPool(2);

    public PreviewTab(class_525 screen, class_310 _minecraft) {
        this.createWorldScreen = screen;
        this.minecraft = _minecraft;
        this.uiState = ((CreateWorldScreenAccessor)screen).getUiState();
        this.previewContainer = new PreviewContainer((class_437)screen, this);
    }

    @NotNull
    public class_2561 method_48610() {
        return WorldPreviewComponents.TITLE;
    }

    public void method_48612(Consumer<class_339> consumer) {
        this.previewContainer.widgets().forEach(consumer);
    }

    public void method_48611(class_8030 screenRectangle) {
        this.previewContainer.doLayout(screenRectangle);
    }

    @Override
    public void close() {
        this.previewContainer.close();
    }

    @Override
    @Nullable
    public class_7193 previewWorldCreationContext() {
        record Cookie(class_7726 worldGenSettings) {
        }
        class_7193 wcContext = this.uiState.method_48728();
        class_7712 worldDataConfiguration = wcContext.comp_1030();
        class_3283 packRepository = (class_3283)((CreateWorldScreenAccessor)this.createWorldScreen).invokeGetDataPackSelectionSettings(worldDataConfiguration).getSecond();
        class_7237.class_7238 packConfig = new class_7237.class_7238(packRepository, worldDataConfiguration, false, true);
        class_7237.class_6906 initConfig = new class_7237.class_6906(packConfig, class_2170.class_5364.field_25421, 2);
        CompletableFuture completableFuture = class_7237.method_42098((class_7237.class_6906)initConfig, dataLoadContext -> {
            class_7723 worldDimensions;
            try {
                class_5321 worldPresetKey = (class_5321)this.uiState.method_48730().comp_1238().method_40230().orElseThrow();
                class_7145 worldPreset = (class_7145)dataLoadContext.comp_989().method_30530(class_7924.field_41250).method_31140(worldPresetKey);
                worldDimensions = worldPreset.method_45546();
            }
            catch (IllegalStateException | NullPointerException | NoSuchElementException ex) {
                worldDimensions = class_5317.method_41598((class_5455)dataLoadContext.comp_989());
            }
            class_7726 worldGenSettings = new class_7726(wcContext.comp_616(), worldDimensions);
            return new class_7237.class_7661((Object)new Cookie(worldGenSettings), dataLoadContext.comp_990());
        }, (closeableResourceManager, reloadableServerResources, layeredRegistryAccess, cookie) -> {
            closeableResourceManager.close();
            return new class_7193(cookie.worldGenSettings, layeredRegistryAccess, reloadableServerResources, worldDataConfiguration);
        }, (Executor)this.loadingExecutor, (Executor)this.loadingExecutor);
        try {
            return (class_7193)completableFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path cacheDir() {
        Path previewDir = this.worldPreview.configDir().resolve("world-preview");
        previewDir.toFile().mkdirs();
        return previewDir;
    }

    private String filename(long seed) {
        return String.format("%s-%s.zip", seed, this.cacheFileCompatPart());
    }

    @Override
    public void storePreviewStorage(long seed, PreviewStorage storage) {
        if (!this.worldPreview.cfg().cacheInNew) {
            return;
        }
        this.minecraft.method_29970((class_437)new PreviewCacheLoadingScreen(WorldPreviewComponents.SAVING_PREVIEW));
        this.writeCacheFile(this.previewContainer.workManager().previewStorage(), this.cacheDir().resolve(this.filename(seed)));
        this.minecraft.method_29970((class_437)this.createWorldScreen);
    }

    @Override
    public PreviewStorage loadPreviewStorage(long seed, int yMin, int yMax) {
        if (!this.worldPreview.cfg().cacheInNew) {
            return new PreviewStorage(yMin, yMax);
        }
        this.minecraft.method_29970((class_437)new PreviewCacheLoadingScreen(WorldPreviewComponents.LOADING_PREVIEW));
        PreviewStorage res = this.readCacheFile(yMin, yMax, this.cacheDir().resolve(this.filename(seed)));
        this.minecraft.method_29970((class_437)this.createWorldScreen);
        return res;
    }

    public PreviewContainer mainScreenWidget() {
        return this.previewContainer;
    }

    @Override
    public void registerSettingsChangeListener(Runnable listener) {
        this.uiState.method_48712(x -> listener.run());
    }

    @Override
    public String seed() {
        return this.uiState.method_48725();
    }

    @Override
    public void updateSeed(String newSeed) {
        this.uiState.method_48716(newSeed);
    }

    @Override
    public boolean seedIsEditable() {
        return true;
    }

    @Override
    @Nullable
    public Path tempDataPackDir() {
        return ((CreateWorldScreenAccessor)this.createWorldScreen).invokeGetTempDataPackDir();
    }

    @Override
    @Nullable
    public MinecraftServer minecraftServer() {
        return null;
    }

    @Override
    public class_5285 worldOptions(@Nullable class_7193 wcContext) {
        if (wcContext == null) {
            throw new AssertionError();
        }
        return wcContext.comp_616();
    }

    @Override
    public class_7712 worldDataConfiguration(@Nullable class_7193 wcContext) {
        if (wcContext == null) {
            throw new AssertionError();
        }
        return wcContext.comp_1030();
    }

    @Override
    public class_5455.class_6890 registryAccess(@Nullable class_7193 wcContext) {
        if (wcContext == null) {
            throw new AssertionError();
        }
        return wcContext.method_45689();
    }

    @Override
    public class_2378<class_5363> levelStemRegistry(@Nullable class_7193 wcContext) {
        if (wcContext == null) {
            throw new AssertionError();
        }
        class_7723.class_7725 worldDimensions = wcContext.comp_1028().method_45518(wcContext.comp_1027());
        return worldDimensions.comp_1017();
    }

    @Override
    public class_7780<class_7659> layeredRegistryAccess(@Nullable class_7193 wcContext) {
        if (wcContext == null) {
            throw new AssertionError();
        }
        class_7723.class_7725 worldDimensions = wcContext.comp_1028().method_45518(wcContext.comp_1027());
        return wcContext.comp_1029().method_45930((Object)class_7659.field_39973, new class_5455.class_6890[]{worldDimensions.method_45537()});
    }
}

