/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.client.gui.screens;

import caeruleusTait.world.preview.RenderSettings;
import caeruleusTait.world.preview.WorldPreview;
import caeruleusTait.world.preview.WorldPreviewConfig;
import caeruleusTait.world.preview.backend.WorkManager;
import caeruleusTait.world.preview.backend.color.ColorMap;
import caeruleusTait.world.preview.backend.color.PreviewData;
import caeruleusTait.world.preview.backend.color.PreviewMappingData;
import caeruleusTait.world.preview.client.WorldPreviewComponents;
import caeruleusTait.world.preview.client.gui.PreviewContainerDataProvider;
import caeruleusTait.world.preview.client.gui.PreviewDisplayDataProvider;
import caeruleusTait.world.preview.client.gui.screens.SettingsScreen;
import caeruleusTait.world.preview.client.gui.widgets.PreviewDisplay;
import caeruleusTait.world.preview.client.gui.widgets.ToggleButton;
import caeruleusTait.world.preview.client.gui.widgets.lists.AbstractSelectionListHolder;
import caeruleusTait.world.preview.client.gui.widgets.lists.BiomesList;
import caeruleusTait.world.preview.client.gui.widgets.lists.SeedsList;
import caeruleusTait.world.preview.client.gui.widgets.lists.StructuresList;
import caeruleusTait.world.preview.mixin.client.ScreenAccessor;
import it.unimi.dsi.fastutil.shorts.Short2LongMap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_1011;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3195;
import net.minecraft.class_3222;
import net.minecraft.class_327;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_350;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7193;
import net.minecraft.class_7659;
import net.minecraft.class_7712;
import net.minecraft.class_7780;
import net.minecraft.class_7919;
import net.minecraft.class_7924;
import net.minecraft.class_8030;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreviewContainer
implements AutoCloseable,
PreviewDisplayDataProvider {
    public static final class_6862<class_1959> C_CAVE = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960("c", "caves"));
    public static final class_6862<class_1959> C_IS_CAVE = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960("c", "is_cave"));
    public static final class_6862<class_1959> FORGE_CAVE = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960("forge", "caves"));
    public static final class_6862<class_1959> FORGE_IS_CAVE = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960("forge", "is_cave"));
    public static final class_6862<class_3195> DISPLAY_BY_DEFAULT = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)new class_2960("c", "display_on_map_by_default"));
    public static final class_2960 BUTTONS_TEXTURE = new class_2960("world_preview:textures/gui/buttons.png");
    public static final int BUTTONS_TEX_WIDTH = 320;
    public static final int BUTTONS_TEX_HEIGHT = 60;
    public static final int LINE_HEIGHT = 20;
    public static final int LINE_VSPACE = 4;
    private final PreviewContainerDataProvider dataProvider;
    private final class_310 minecraft;
    private final WorldPreview worldPreview;
    private final WorldPreviewConfig cfg;
    private final WorkManager workManager;
    private final RenderSettings renderSettings;
    private final PreviewMappingData previewMappingData;
    private PreviewData previewData;
    private List<class_2960> levelStemKeys;
    private class_2378<class_5363> levelStemRegistry;
    private final class_342 seedEdit;
    private final class_4185 randomSeedButton;
    private final class_4185 saveSeed;
    private final class_4185 settings;
    private final class_4185 resetToZeroZero;
    private final ToggleButton toggleCaves;
    private final ToggleButton toggleShowStructures;
    private final ToggleButton toggleHeightmap;
    private final ToggleButton toggleIntersections;
    private final class_4185 resetDefaultStructureVisibility;
    private final class_4185 switchBiomes;
    private final class_4185 switchStructures;
    private final class_4185 switchSeeds;
    private final PreviewDisplay previewDisplay;
    private final BiomesList biomesList;
    private final StructuresList structuresList;
    private final SeedsList seedsList;
    private final AbstractSelectionListHolder<BiomesList.BiomeEntry, BiomesList> biomesListHolder;
    private final AbstractSelectionListHolder<StructuresList.StructureEntry, StructuresList> structuresListHolder;
    private final AbstractSelectionListHolder<SeedsList.SeedEntry, SeedsList> seedsListHolder;
    private BiomesList.BiomeEntry[] allBiomes;
    private StructuresList.StructureEntry[] allStructures;
    private class_1011[] allStructureIcons;
    private class_1011 playerIcon;
    private class_1011 spawnIcon;
    private List<SeedsList.SeedEntry> seedEntries;
    private boolean inhibitUpdates = true;
    private boolean isUpdating = false;
    private boolean setupFailed = false;
    private final Executor reloadExecutor = Executors.newSingleThreadExecutor();
    private final Executor serverThreadPoolExecutor;
    private final AtomicInteger reloadRevision = new AtomicInteger(0);
    private final List<class_339> toRender = new ArrayList<class_339>();

    public PreviewContainer(class_437 screen, PreviewContainerDataProvider previewContainerDataProvider) {
        class_327 font = ((ScreenAccessor)screen).getFont();
        this.dataProvider = previewContainerDataProvider;
        this.minecraft = ((ScreenAccessor)screen).getMinecraft();
        this.allBiomes = new BiomesList.BiomeEntry[0];
        this.worldPreview = WorldPreview.get();
        this.cfg = this.worldPreview.cfg();
        this.workManager = this.worldPreview.workManager();
        this.previewMappingData = this.worldPreview.biomeColorMap();
        this.renderSettings = this.worldPreview.renderSettings();
        this.serverThreadPoolExecutor = this.worldPreview.serverThreadPoolExecutor();
        this.seedEdit = new class_342(font, 0, 0, 100, 18, WorldPreviewComponents.SEED_FIELD);
        this.seedEdit.method_47404(WorldPreviewComponents.SEED_FIELD);
        this.seedEdit.method_1852(this.dataProvider.seed());
        this.seedEdit.method_1863(this::setSeed);
        this.seedEdit.method_47400(class_7919.method_47407((class_2561)WorldPreviewComponents.SEED_LABEL));
        this.seedEdit.field_22763 = this.dataProvider.seedIsEditable();
        this.toRender.add((class_339)this.seedEdit);
        this.randomSeedButton = new class_344(0, 0, 20, 20, 0, 20, 20, BUTTONS_TEXTURE, 320, 60, this::randomizeSeed);
        this.randomSeedButton.method_47400(class_7919.method_47407((class_2561)WorldPreviewComponents.BTN_RANDOM));
        this.randomSeedButton.field_22763 = this.dataProvider.seedIsEditable();
        this.toRender.add((class_339)this.randomSeedButton);
        this.saveSeed = new class_344(0, 0, 20, 20, 20, 20, 20, BUTTONS_TEXTURE, 320, 60, this::saveCurrentSeed);
        this.saveSeed.method_47400(class_7919.method_47407((class_2561)WorldPreviewComponents.BTN_SAVE_SEED));
        this.saveSeed.field_22763 = false;
        this.toRender.add((class_339)this.saveSeed);
        this.settings = new class_344(0, 0, 20, 20, 60, 20, 20, BUTTONS_TEXTURE, 320, 60, x -> {
            this.workManager.cancel();
            this.minecraft.method_1507((class_437)new SettingsScreen(screen, this));
        });
        this.settings.method_47400(class_7919.method_47407((class_2561)WorldPreviewComponents.BTN_SETTINGS));
        this.settings.field_22763 = false;
        this.toRender.add((class_339)this.settings);
        this.resetToZeroZero = new class_344(0, 0, 20, 20, 120, 20, 20, BUTTONS_TEXTURE, 320, 60, x -> this.renderSettings.resetCenter());
        this.resetToZeroZero.method_47400(class_7919.method_47407((class_2561)WorldPreviewComponents.BTN_HOME));
        this.toRender.add((class_339)this.resetToZeroZero);
        this.resetDefaultStructureVisibility = class_4185.method_46430((class_2561)WorldPreviewComponents.BTN_RESET_STRUCTURES, x -> Arrays.stream(this.allStructures).forEach(StructuresList.StructureEntry::reset)).method_46431();
        this.resetDefaultStructureVisibility.method_47400(class_7919.method_47407((class_2561)WorldPreviewComponents.BTN_RESET_STRUCTURES_TOOLTIP));
        this.resetDefaultStructureVisibility.field_22764 = false;
        this.toRender.add((class_339)this.resetDefaultStructureVisibility);
        this.switchBiomes = class_4185.method_46430((class_2561)DisplayType.BIOMES.component(), x -> this.onTabButtonChange(x, DisplayType.BIOMES)).method_46437(100, 20).method_46431();
        this.switchStructures = class_4185.method_46430((class_2561)DisplayType.STRUCTURES.component(), x -> this.onTabButtonChange(x, DisplayType.STRUCTURES)).method_46437(100, 20).method_46431();
        this.switchSeeds = class_4185.method_46430((class_2561)DisplayType.SEEDS.component(), x -> this.onTabButtonChange(x, DisplayType.SEEDS)).method_46437(100, 20).method_46431();
        this.toRender.add((class_339)this.switchBiomes);
        this.toRender.add((class_339)this.switchStructures);
        this.toRender.add((class_339)this.switchSeeds);
        this.biomesList = new BiomesList(this, this.minecraft, 200, 300, 4, 100, true);
        this.biomesListHolder = new AbstractSelectionListHolder(this.biomesList, 0, 0, screen.field_22789, screen.field_22790, WorldPreviewComponents.TITLE);
        this.biomesListHolder.field_22764 = true;
        this.toRender.add(this.biomesListHolder);
        this.structuresList = new StructuresList(this.minecraft, 200, 300, 4, 100);
        this.structuresListHolder = new AbstractSelectionListHolder(this.structuresList, 0, 0, screen.field_22789, screen.field_22790, WorldPreviewComponents.TITLE);
        this.structuresListHolder.field_22764 = false;
        this.toRender.add(this.structuresListHolder);
        this.seedsList = new SeedsList(this.minecraft, this);
        this.seedsListHolder = new AbstractSelectionListHolder(this.seedsList, 0, 0, screen.field_22789, screen.field_22790, WorldPreviewComponents.TITLE);
        this.seedsListHolder.field_22764 = false;
        this.updateSeedListWidget();
        this.toRender.add(this.seedsListHolder);
        this.previewDisplay = new PreviewDisplay(this.minecraft, this, WorldPreviewComponents.TITLE);
        this.toRender.add(this.previewDisplay);
        this.toggleCaves = new ToggleButton(0, 0, 20, 20, 80, 20, 20, 20, BUTTONS_TEXTURE, 320, 60, x -> {
            this.biomesList.setSelected(null);
            this.previewDisplay.setSelectedBiomeId((short)-1);
            this.previewDisplay.setHighlightCaves(((ToggleButton)x).selected);
        });
        this.toggleCaves.method_47400(class_7919.method_47407((class_2561)WorldPreviewComponents.BTN_CAVES));
        this.toRender.add((class_339)this.toggleCaves);
        this.toggleShowStructures = new ToggleButton(0, 0, 20, 20, 140, 20, 20, 20, BUTTONS_TEXTURE, 320, 60, x -> {
            this.renderSettings.hideAllStructures = !((ToggleButton)x).selected;
        });
        this.toggleShowStructures.selected = !this.renderSettings.hideAllStructures;
        this.toggleShowStructures.field_22763 = false;
        this.toRender.add((class_339)this.toggleShowStructures);
        this.toggleHeightmap = new ToggleButton(0, 0, 20, 20, 200, 20, 20, 20, BUTTONS_TEXTURE, 320, 60, x -> {
            this.renderSettings.showHeightMap = ((ToggleButton)x).selected;
            if (this.renderSettings.showHeightMap) {
                this.renderSettings.showIntersections = false;
                this.toggleIntersections().selected = false;
            }
        });
        this.toggleHeightmap.selected = this.renderSettings.showHeightMap && this.cfg.sampleHeightmap;
        this.toggleHeightmap.field_22763 = false;
        this.toRender.add((class_339)this.toggleHeightmap);
        this.toggleIntersections = new ToggleButton(0, 0, 20, 20, 240, 20, 20, 20, BUTTONS_TEXTURE, 320, 60, x -> {
            this.renderSettings.showIntersections = ((ToggleButton)x).selected;
            if (this.renderSettings.showIntersections) {
                this.renderSettings.showHeightMap = false;
                this.toggleHeightmap().selected = false;
            }
        });
        this.toggleIntersections.selected = this.renderSettings.showIntersections && this.cfg.sampleIntersections;
        this.toggleIntersections.field_22763 = false;
        this.toRender.add((class_339)this.toggleIntersections);
        this.biomesList.setBiomeChangeListener(x -> {
            this.previewDisplay.setSelectedBiomeId(x == null ? (short)-1 : (short)x.id());
            this.toggleCaves.selected = x == null && this.toggleCaves.selected;
            this.previewDisplay.setHighlightCaves(x == null && this.toggleCaves.selected);
        });
        this.dataProvider.registerSettingsChangeListener(this::updateSettings);
        this.onTabButtonChange(this.switchBiomes, DisplayType.BIOMES);
    }

    public void patchColorData() {
        Map<class_2960, PreviewMappingData.ColorEntry> configured = Arrays.stream(this.allBiomes).filter(x -> x.dataSource() == PreviewData.DataSource.CONFIG).collect(Collectors.toMap(x -> x.entry().method_40237().method_29177(), x -> new PreviewMappingData.ColorEntry(PreviewData.DataSource.MISSING, x.color(), x.isCave(), x.name())));
        Map<class_2960, PreviewMappingData.ColorEntry> defaults = Arrays.stream(this.allBiomes).filter(x -> x.dataSource() == PreviewData.DataSource.RESOURCE).collect(Collectors.toMap(x -> x.entry().method_40237().method_29177(), x -> new PreviewMappingData.ColorEntry(PreviewData.DataSource.RESOURCE, x.color(), x.isCave(), x.name())));
        Map<class_2960, PreviewMappingData.ColorEntry> missing = Arrays.stream(this.allBiomes).filter(x -> x.dataSource() == PreviewData.DataSource.MISSING).collect(Collectors.toMap(x -> x.entry().method_40237().method_29177(), x -> new PreviewMappingData.ColorEntry(PreviewData.DataSource.CONFIG, x.color(), x.isCave(), x.name())));
        this.previewMappingData.update(missing);
        this.previewMappingData.update(defaults);
        this.previewMappingData.update(configured);
        this.updateSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateSettings() {
        if (this.inhibitUpdates) {
            return;
        }
        this.inhibitUpdates = true;
        try {
            int revision;
            AtomicInteger atomicInteger = this.reloadRevision;
            synchronized (atomicInteger) {
                revision = this.reloadRevision.incrementAndGet();
            }
            this.isUpdating = true;
            ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                if (this.reloadRevision.get() > revision) {
                    return null;
                }
                return this.dataProvider.previewWorldCreationContext();
            }, this.reloadExecutor).thenAcceptAsync(x -> {
                if (this.reloadRevision.get() > revision) {
                    return;
                }
                this.updateSettings_real((class_7193)x);
                AtomicInteger atomicInteger = this.reloadRevision;
                synchronized (atomicInteger) {
                    if (this.reloadRevision.get() <= revision) {
                        this.isUpdating = false;
                    }
                }
            }, (Executor)this.minecraft)).handle((r, e) -> {
                if (e == null) {
                    this.setupFailed = false;
                } else {
                    e.printStackTrace();
                    this.setupFailed = true;
                }
                return null;
            });
        }
        finally {
            this.inhibitUpdates = false;
        }
    }

    private void updateSettings_real(@Nullable class_7193 wcContext) {
        this.saveSeed.field_22763 = !this.dataProvider.seed().isEmpty() && !this.cfg.savedSeeds.contains(this.dataProvider.seed());
        this.updateSeedListWidget();
        this.seedEdit.method_1852(this.dataProvider.seed());
        if (!this.seedEdit.method_25370()) {
            this.seedEdit.method_1870();
        }
        if (this.cfg.heightmapMinY == this.cfg.heightmapMaxY) {
            ++this.cfg.heightmapMaxY;
        } else if (this.cfg.heightmapMaxY < this.cfg.heightmapMinY) {
            int tmp = this.cfg.heightmapMaxY;
            this.cfg.heightmapMaxY = this.cfg.heightmapMinY;
            this.cfg.heightmapMinY = tmp;
        }
        class_7712 worldDataConfiguration = this.dataProvider.worldDataConfiguration(wcContext);
        class_2378 biomeRegistry = this.dataProvider.registryAccess(wcContext).method_30530(class_7924.field_41236);
        class_2378 strucutreRegistry = this.dataProvider.registryAccess(wcContext).method_30530(class_7924.field_41246);
        this.levelStemRegistry = this.dataProvider.levelStemRegistry(wcContext);
        this.levelStemKeys = this.levelStemRegistry.method_10235().stream().sorted(Comparator.comparing(Object::toString)).toList();
        this.settings.field_22763 = true;
        if (this.renderSettings.dimension == null || !this.levelStemRegistry.method_10250(this.renderSettings.dimension)) {
            this.renderSettings.dimension = this.levelStemRegistry.method_35842(class_5363.field_25412) ? class_5363.field_25412.method_29177() : (class_2960)this.levelStemRegistry.method_10235().iterator().next();
        }
        class_5363 levelStem = (class_5363)this.levelStemRegistry.method_10223(this.renderSettings.dimension);
        HashSet<class_2960> caveBiomes = new HashSet<class_2960>();
        for (class_6862<class_1959> tagKey : List.of(C_CAVE, C_IS_CAVE, FORGE_CAVE, FORGE_IS_CAVE)) {
            caveBiomes.addAll(StreamSupport.stream(biomeRegistry.method_40286(tagKey).spliterator(), false).map(x -> ((class_5321)x.method_40230().orElseThrow()).method_29177()).toList());
        }
        this.previewData = this.previewMappingData.generateMapData(biomeRegistry.method_10235(), caveBiomes, strucutreRegistry.method_10235(), StreamSupport.stream(strucutreRegistry.method_40286(DISPLAY_BY_DEFAULT).spliterator(), false).map(x -> ((class_5321)x.method_40230().orElseThrow()).method_29177()).collect(Collectors.toSet()));
        ColorMap colorMap = this.previewData.colorMaps().get(this.cfg.colorMap);
        if (colorMap == null) {
            this.cfg.colorMap = "world_preview:inferno";
        }
        class_7780<class_7659> layeredRegistryAccess = this.dataProvider.layeredRegistryAccess(wcContext);
        this.workManager.cancel();
        Runnable changeWorldGenState = () -> this.workManager.changeWorldGenState(levelStem, layeredRegistryAccess, this.previewData, this.dataProvider.worldOptions(wcContext), worldDataConfiguration, this.dataProvider, this.minecraft.method_1487(), this.dataProvider.tempDataPackDir(), this.dataProvider.minecraftServer());
        if (this.serverThreadPoolExecutor != null) {
            try {
                CompletableFuture.runAsync(changeWorldGenState, this.serverThreadPoolExecutor).get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        } else {
            changeWorldGenState.run();
        }
        this.workManager.postChangeWorldGenState();
        List<String> missing = Arrays.stream(this.previewData.biomeId2BiomeData()).filter(x -> x.dataSource() == PreviewData.DataSource.MISSING).map(PreviewData.BiomeData::tag).map(class_2960::toString).toList();
        this.worldPreview.writeMissingColors(missing);
        this.allBiomes = (BiomesList.BiomeEntry[])biomeRegistry.method_40270().map(x -> {
            short id = this.previewData.biome2Id().getShort((Object)x.method_40237().method_29177().toString());
            PreviewData.BiomeData biomeData = this.previewData.biomeId2BiomeData()[id];
            int color = biomeData.color();
            int initialColor = biomeData.resourceOnlyColor();
            boolean isCave = biomeData.isCave();
            boolean initialIsCave = biomeData.resourceOnlyIsCave();
            String explicitName = biomeData.name();
            PreviewData.DataSource dataSource = biomeData.dataSource();
            return this.biomesList.createEntry((class_6880.class_6883<class_1959>)x, id, color, initialColor, isCave, initialIsCave, explicitName, dataSource);
        }).sorted(Comparator.comparing(BiomesList.BiomeEntry::id)).toArray(BiomesList.BiomeEntry[]::new);
        this.biomesList.method_25314((Collection<BiomesList.BiomeEntry>)new ArrayList<BiomesList.BiomeEntry>());
        this.biomesList.setSelected(null);
        missing = Arrays.stream(this.previewData.structId2StructData()).filter(x -> x.dataSource() == PreviewData.DataSource.MISSING).map(PreviewData.StructureData::tag).map(class_2960::toString).toList();
        this.worldPreview.writeMissingStructures(missing);
        this.freeStructureIcons();
        class_3300 builtinResourceManager = this.minecraft.method_1478();
        HashMap<class_2960, class_1011> icons = new HashMap<class_2960, class_1011>();
        this.allStructureIcons = new class_1011[this.previewData.structId2StructData().length];
        for (int i = 0; i < this.previewData.structId2StructData().length; ++i) {
            PreviewData.StructureData data = this.previewData.structId2StructData()[i];
            this.allStructureIcons[i] = icons.computeIfAbsent(data.icon(), x -> {
                class_1011 class_10112;
                block12: {
                    Optional resource;
                    if (x == null) {
                        x = new class_2960("world_preview:textures/structure/unknown.png");
                    }
                    if ((resource = builtinResourceManager.method_14486(x)).isEmpty()) {
                        resource = this.workManager.sampleResourceManager().method_14486(x);
                    }
                    if (resource.isEmpty()) {
                        WorldPreview.LOGGER.error("Failed to load structure icon: '{}'", x);
                        resource = builtinResourceManager.method_14486(new class_2960("world_preview:textures/structure/unknown.png"));
                    }
                    if (resource.isEmpty()) {
                        WorldPreview.LOGGER.error("FATAL ERROR LOADING: '{}' -- unable to load fallback!", x);
                        return new class_1011(16, 16, true);
                    }
                    InputStream in = ((class_3298)resource.get()).method_14482();
                    try {
                        class_10112 = class_1011.method_4309((InputStream)in);
                        if (in == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            return new class_1011(16, 16, true);
                        }
                    }
                    in.close();
                }
                return class_10112;
            });
        }
        Optional playerResource = builtinResourceManager.method_14486(new class_2960("world_preview:textures/etc/player.png"));
        Optional spawnResource = builtinResourceManager.method_14486(new class_2960("world_preview:textures/etc/bed.png"));
        try (InputStream inPlayer = ((class_3298)playerResource.orElseThrow()).method_14482();
             InputStream inSpawn = ((class_3298)spawnResource.orElseThrow()).method_14482();){
            this.playerIcon = class_1011.method_4309((InputStream)inPlayer);
            this.spawnIcon = class_1011.method_4309((InputStream)inSpawn);
        }
        catch (IOException e) {
            this.playerIcon = new class_1011(16, 16, true);
            this.spawnIcon = new class_1011(16, 16, true);
            e.printStackTrace();
        }
        class_2378 itemRegistry = layeredRegistryAccess.method_45926().method_30530(class_7924.field_41197);
        this.allStructures = (StructuresList.StructureEntry[])strucutreRegistry.method_40270().map(x -> {
            short id = this.previewData.struct2Id().getShort((Object)x.method_40237().method_29177().toString());
            PreviewData.StructureData structureData = this.previewData.structId2StructData()[id];
            return this.structuresList.createEntry(id, x.method_40237().method_29177(), this.allStructureIcons[id], structureData.item() == null ? null : (class_1792)itemRegistry.method_10223(structureData.item()), structureData.name(), structureData.showByDefault(), structureData.showByDefault());
        }).sorted(Comparator.comparing(StructuresList.StructureEntry::id)).toArray(StructuresList.StructureEntry[]::new);
        this.structuresList.method_25314((Collection<StructuresList.StructureEntry>)new ArrayList<StructuresList.StructureEntry>());
        this.renderSettings.resetCenter();
        if (this.cfg.sampleStructures) {
            this.toggleShowStructures.field_22763 = true;
            this.toggleShowStructures.method_47400(class_7919.method_47407((class_2561)WorldPreviewComponents.BTN_TOGGLE_STRUCTURES));
        } else {
            this.toggleShowStructures.field_22763 = false;
            this.toggleShowStructures.method_47400(class_7919.method_47407((class_2561)WorldPreviewComponents.BTN_TOGGLE_STRUCTURES_DISABLED));
        }
        if (this.cfg.sampleHeightmap) {
            this.toggleHeightmap.field_22763 = true;
            this.toggleHeightmap.method_47400(class_7919.method_47407((class_2561)WorldPreviewComponents.BTN_TOGGLE_HEIGHTMAP));
        } else {
            this.toggleHeightmap.field_22763 = false;
            this.toggleHeightmap.method_47400(class_7919.method_47407((class_2561)WorldPreviewComponents.BTN_TOGGLE_HEIGHTMAP_DISABLED));
            this.renderSettings.showHeightMap = false;
        }
        if (this.cfg.sampleIntersections) {
            this.toggleIntersections.field_22763 = true;
            this.toggleIntersections.method_47400(class_7919.method_47407((class_2561)WorldPreviewComponents.BTN_TOGGLE_INTERSECT));
        } else {
            this.toggleIntersections.field_22763 = false;
            this.toggleIntersections.method_47400(class_7919.method_47407((class_2561)WorldPreviewComponents.BTN_TOGGLE_INTERSECT_DISABLED));
            this.renderSettings.showIntersections = false;
        }
        this.previewDisplay.reloadData();
        this.previewDisplay.setSelectedBiomeId((short)-1);
        this.previewDisplay.setHighlightCaves(false);
        this.toggleCaves.selected = false;
    }

    @Override
    public void onVisibleBiomesChanged(Short2LongMap visibleBiomes) {
        List<BiomesList.BiomeEntry> res = visibleBiomes.short2LongEntrySet().stream().sorted(Comparator.comparing(Short2LongMap.Entry::getLongValue).reversed()).map(Short2LongMap.Entry::getShortKey).map(x -> this.allBiomes[x]).toList();
        this.biomesList.method_25314((Collection<BiomesList.BiomeEntry>)res);
    }

    @Override
    public void onVisibleStructuresChanged(Short2LongMap visibleStructures) {
        List<StructuresList.StructureEntry> res = visibleStructures.short2LongEntrySet().stream().sorted(Comparator.comparing(Short2LongMap.Entry::getLongValue)).map(Short2LongMap.Entry::getShortKey).map(x -> this.allStructures[x]).toList();
        this.structuresList.method_25314((Collection<StructuresList.StructureEntry>)res);
    }

    private void randomizeSeed(class_4185 btn) {
        UUID uuid = UUID.randomUUID();
        ByteBuffer bb = ByteBuffer.allocate(16);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        String uuidSeed = Base64.getEncoder().encodeToString(bb.array()).substring(0, 16);
        this.setSeed(uuidSeed);
    }

    private void saveCurrentSeed(class_4185 btn) {
        this.cfg.savedSeeds.add(this.dataProvider.seed());
        this.saveSeed.field_22763 = false;
        this.updateSeedListWidget();
    }

    public void deleteSeed(String seed) {
        this.cfg.savedSeeds.remove(seed);
        this.updateSeedListWidget();
    }

    public void setSeed(String seed) {
        if (Objects.equals(this.dataProvider.seed(), seed) || !this.dataProvider.seedIsEditable()) {
            return;
        }
        boolean initialInhibitUpdates = this.inhibitUpdates;
        this.inhibitUpdates = true;
        try {
            this.dataProvider.updateSeed(seed);
        }
        finally {
            this.inhibitUpdates = initialInhibitUpdates;
        }
        this.updateSettings();
    }

    private void updateSeedListWidget() {
        this.seedEntries = this.cfg.savedSeeds.stream().map(this.seedsList::createEntry).toList();
        this.seedsList.method_25314(this.seedEntries);
        int idx = this.cfg.savedSeeds.indexOf(this.dataProvider.seed());
        if (idx >= 0) {
            this.seedsList.method_25313((class_350.class_351)this.seedEntries.get(idx));
        }
    }

    public void resetTabs() {
        this.onTabButtonChange(this.switchBiomes, DisplayType.BIOMES);
    }

    private void onTabButtonChange(class_4185 btn, DisplayType type) {
        this.biomesListHolder.field_22764 = false;
        this.structuresListHolder.field_22764 = false;
        this.seedsListHolder.field_22764 = false;
        this.switchBiomes.field_22763 = true;
        this.switchStructures.field_22763 = true;
        this.switchSeeds.field_22763 = true;
        this.resetDefaultStructureVisibility.field_22764 = false;
        if (this.cfg.sampleStructures) {
            this.switchStructures.method_47400(null);
        } else {
            this.switchStructures.method_47400(class_7919.method_47407((class_2561)WorldPreviewComponents.BTN_SWITCH_STRUCT_DISABLED));
            this.switchStructures.field_22763 = false;
        }
        btn.field_22763 = false;
        switch (type) {
            case BIOMES: {
                this.biomesListHolder.field_22764 = true;
                break;
            }
            case STRUCTURES: {
                this.resetDefaultStructureVisibility.field_22764 = true;
                this.structuresListHolder.field_22764 = true;
                break;
            }
            case SEEDS: {
                this.seedsListHolder.field_22764 = true;
            }
        }
    }

    public synchronized void start() {
        WorldPreview.LOGGER.info("Start generating biome data...");
        if (this.dataProvider.seed().isEmpty()) {
            this.randomizeSeed(null);
        }
        this.inhibitUpdates = false;
        this.updateSettings();
    }

    public synchronized void stop() {
        WorldPreview.LOGGER.info("Stop generating biome data...");
        this.inhibitUpdates = true;
        this.workManager.cancel();
    }

    public void doLayout(class_8030 screenRectangle) {
        int leftWidth = Math.max(130, Math.min(180, screenRectangle.comp_1196() / 3));
        int left = screenRectangle.method_49620() + 3;
        int top = screenRectangle.method_49618() + 2;
        int bottom = screenRectangle.method_49619() - 32;
        this.previewDisplay.method_48229(left + leftWidth + 3, top + 1);
        this.previewDisplay.setSize(screenRectangle.method_49621() - this.previewDisplay.method_46426() - 4, screenRectangle.method_49619() - this.previewDisplay.method_46427() - 14);
        this.seedEdit.method_25358(leftWidth - 1 - 44);
        this.seedEdit.method_46421(left);
        this.seedEdit.method_46419(bottom + 1);
        this.randomSeedButton.method_46421(left + leftWidth - 20);
        this.randomSeedButton.method_46419(bottom);
        this.saveSeed.method_46421(left + leftWidth - 22 - 20);
        this.saveSeed.method_46419(bottom);
        int cycleWith = leftWidth - 110;
        int btnStart = left + cycleWith + 2;
        this.settings.method_48229(left, top);
        int i = 0;
        this.toggleIntersections.method_48229(btnStart + 22 * i++, top);
        this.toggleHeightmap.method_48229(btnStart + 22 * i++, top);
        this.toggleShowStructures.method_48229(btnStart + 22 * i++, top);
        this.toggleCaves.method_48229(btnStart + 22 * i++, top);
        this.resetToZeroZero.method_48229(btnStart + 22 * i++, top);
        int switchBiomesWidth = 45;
        int switchSeedsWidth = 45;
        int switchStructuresWidth = leftWidth - switchBiomesWidth - switchSeedsWidth - 4;
        this.switchBiomes.method_48229(left, top += 24);
        this.switchStructures.method_48229(left + switchBiomesWidth + 2, top);
        this.switchSeeds.method_48229(left + switchBiomesWidth + switchStructuresWidth + 4, top);
        this.switchBiomes.method_25358(switchBiomesWidth);
        this.switchStructures.method_25358(switchStructuresWidth);
        this.switchSeeds.method_25358(switchSeedsWidth);
        this.biomesListHolder.method_48229(left, top += 24);
        this.biomesListHolder.setSize(leftWidth, bottom - top - 4);
        this.biomesList.method_31322(true);
        this.biomesList.method_31323(false);
        this.seedsListHolder.method_48229(left, top);
        this.seedsListHolder.setSize(leftWidth, bottom - top - 4);
        this.seedsList.method_31322(true);
        this.seedsList.method_31323(false);
        this.resetDefaultStructureVisibility.method_48229(left, bottom -= 24);
        this.resetDefaultStructureVisibility.method_25358(leftWidth);
        this.structuresListHolder.method_48229(left, top);
        this.structuresListHolder.setSize(leftWidth, bottom - top - 4);
        this.structuresList.method_31322(true);
        this.structuresList.method_31323(false);
    }

    @Override
    public void close() {
        this.workManager.cancel();
        this.previewDisplay.close();
        this.freeStructureIcons();
    }

    private void freeStructureIcons() {
        if (this.allStructureIcons == null) {
            return;
        }
        Arrays.stream(this.allStructureIcons).filter(Objects::nonNull).forEach(class_1011::close);
    }

    public List<BiomesList.BiomeEntry> allBiomes() {
        return Arrays.stream(this.allBiomes).sorted(Comparator.comparing(BiomesList.BiomeEntry::name)).toList();
    }

    public List<class_2960> levelStemKeys() {
        return this.levelStemKeys;
    }

    public class_2378<class_5363> levelStemRegistry() {
        return this.levelStemRegistry;
    }

    @Override
    public BiomesList.BiomeEntry biome4Id(int id) {
        return this.allBiomes[id];
    }

    @Override
    public StructuresList.StructureEntry structure4Id(int id) {
        return this.allStructures[id];
    }

    @Override
    public class_1011[] structureIcons() {
        return this.allStructureIcons;
    }

    @Override
    public class_1011 playerIcon() {
        return this.playerIcon;
    }

    @Override
    public class_1011 spawnIcon() {
        return this.spawnIcon;
    }

    @Override
    public class_1799[] structureItems() {
        return (class_1799[])Arrays.stream(this.allStructures).map(StructuresList.StructureEntry::itemStack).toArray(class_1799[]::new);
    }

    @Override
    public void onBiomeVisuallySelected(BiomesList.BiomeEntry entry) {
        this.biomesList.setSelected(entry, true);
        this.toggleCaves.selected = false;
        this.previewDisplay.setHighlightCaves(false);
    }

    @Override
    public PreviewData previewData() {
        return this.previewData;
    }

    public WorkManager workManager() {
        return this.workManager;
    }

    @Override
    public PreviewDisplayDataProvider.StructureRenderInfo[] renderStructureMap() {
        return this.allStructures;
    }

    @Override
    public int[] heightColorMap() {
        ColorMap colorMap = this.previewData.colorMaps().get(this.cfg.colorMap);
        if (colorMap == null) {
            int[] black = new int[this.workManager.yMax() - this.workManager.yMin()];
            Arrays.fill(black, -16777216);
            return black;
        }
        return colorMap.bake(this.workManager.yMin(), this.workManager.yMax(), this.cfg.heightmapMinY, this.cfg.heightmapMaxY);
    }

    @Override
    public int yMin() {
        return this.workManager.yMin();
    }

    @Override
    public int yMax() {
        return this.workManager.yMax();
    }

    @Override
    public boolean isUpdating() {
        return this.isUpdating;
    }

    @Override
    public boolean setupFailed() {
        return this.setupFailed;
    }

    @Override
    @NotNull
    public PreviewDisplayDataProvider.PlayerData getPlayerData(UUID playerId) {
        if (this.workManager == null || this.workManager.sampleUtils() == null) {
            return new PreviewDisplayDataProvider.PlayerData(null, null);
        }
        class_3222 player = this.workManager.sampleUtils().getPlayers(playerId);
        if (player == null) {
            return new PreviewDisplayDataProvider.PlayerData(null, null);
        }
        class_5321 playerDimension = player.method_37908().method_27983();
        class_5321 respawnDimension = player.method_26281();
        class_5321<class_1937> currentDimension = this.workManager.sampleUtils().dimension();
        return new PreviewDisplayDataProvider.PlayerData(currentDimension.equals((Object)playerDimension) ? player.method_24515() : null, currentDimension.equals((Object)respawnDimension) ? player.method_26280() : null);
    }

    public ToggleButton toggleCaves() {
        return this.toggleCaves;
    }

    public ToggleButton toggleShowStructures() {
        return this.toggleShowStructures;
    }

    public ToggleButton toggleHeightmap() {
        return this.toggleHeightmap;
    }

    public ToggleButton toggleIntersections() {
        return this.toggleIntersections;
    }

    public PreviewContainerDataProvider dataProvider() {
        return this.dataProvider;
    }

    public List<class_339> widgets() {
        return this.toRender;
    }

    public static enum DisplayType {
        BIOMES,
        STRUCTURES,
        SEEDS;


        public class_2561 component() {
            return DisplayType.toComponent(this);
        }

        public static class_2561 toComponent(DisplayType x) {
            return class_2561.method_43471((String)("world_preview.preview.btn-cycle." + x.name()));
        }
    }
}

