/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.backend.worker;

import caeruleusTait.world.preview.backend.color.PreviewData;
import caeruleusTait.world.preview.backend.storage.PreviewSection;
import caeruleusTait.world.preview.backend.worker.WorkResult;
import caeruleusTait.world.preview.backend.worker.WorkUnit;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_2960;
import net.minecraft.class_3449;
import net.minecraft.class_5742;

public class WorkBatch {
    public final List<WorkUnit> workUnits;
    private final Object completedSynchro;
    private final PreviewData previewData;
    private boolean isCanceled = false;

    public WorkBatch(List<WorkUnit> workUnits, Object completedSynchro, PreviewData previewData) {
        this.workUnits = workUnits;
        this.completedSynchro = completedSynchro;
        this.previewData = previewData;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void cancel() {
        this.isCanceled = true;
        this.workUnits.forEach(WorkUnit::cancel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        try {
            if (this.isCanceled()) {
                return;
            }
            ArrayList<WorkResult> res = new ArrayList<WorkResult>();
            for (WorkUnit unit : this.workUnits) {
                res.addAll(unit.work());
                if (!this.isCanceled()) continue;
                return;
            }
            Object object = this.completedSynchro;
            synchronized (object) {
                this.workUnits.forEach(WorkUnit::markCompleted);
            }
            this.applyChunkResult(res);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void applyChunkResult(List<WorkResult> workResultList) {
        try {
            for (WorkResult workResult : workResultList) {
                if (workResult == null) {
                    return;
                }
                class_1923 chunkPos = workResult.workUnit().chunk();
                int qStartX = class_5742.method_33102((int)chunkPos.field_9181);
                int qStartZ = class_5742.method_33102((int)chunkPos.field_9180);
                PreviewSection section = workResult.section();
                PreviewSection.AccessData offsetData = section.calcQuartOffsetData(qStartX, qStartZ, qStartX + 4, qStartZ + 4);
                for (WorkResult.BlockResult blockResult : workResult.results()) {
                    section.set(offsetData.minX() + blockResult.quartX() - qStartX, offsetData.minZ() + blockResult.quartZ() - qStartZ, blockResult.value());
                }
                for (Pair pair : workResult.structures()) {
                    class_3449 structureStart = (class_3449)pair.getSecond();
                    short id = this.previewData.struct2Id().getShort((Object)((class_2960)pair.getFirst()).toString());
                    section.addStructure(new PreviewSection.PreviewStruct(structureStart.method_14969().method_22874(), id, structureStart.method_14969()));
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

