/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.backend.worker;

import caeruleusTait.world.preview.backend.color.PreviewData;
import caeruleusTait.world.preview.backend.sampler.ChunkSampler;
import caeruleusTait.world.preview.backend.worker.SampleUtils;
import caeruleusTait.world.preview.backend.worker.WorkResult;
import caeruleusTait.world.preview.backend.worker.WorkUnit;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4966;
import net.minecraft.class_5742;

public class SlowIntersectionWorkUnit
extends WorkUnit {
    private final ChunkSampler sampler;
    private final int yMin;
    private final int yMax;
    private final int yStride;

    public SlowIntersectionWorkUnit(ChunkSampler sampler, SampleUtils sampleUtils, class_1923 chunkPos, PreviewData previewData, int yMin, int yMax, int yStride) {
        super(sampleUtils, chunkPos, previewData, 0);
        this.sampler = sampler;
        this.yMin = yMin;
        this.yMax = yMax;
        this.yStride = yStride;
    }

    @Override
    protected List<WorkResult> doWork() {
        ArrayList<WorkResult> results = new ArrayList<WorkResult>((this.yMax - this.yMin) / this.yStride);
        for (int y = this.yMin; y <= this.yMax; y += this.yStride) {
            results.add(new WorkResult(this, class_5742.method_33100((int)y), y == this.y ? this.primarySection : this.storage.section4(this.chunkPos, y, this.flags()), new ArrayList<WorkResult.BlockResult>(16), List.of()));
        }
        for (class_2338 p : this.sampler.blocksForChunk(this.chunkPos, 0)) {
            if (this.isCanceled()) break;
            class_4966 nc = this.sampleUtils.doIntersectionsSlow(p);
            int lastColorId = 0;
            for (int y = this.yMin; y <= this.yMax; y += this.yStride) {
                WorkResult res = (WorkResult)results.get((y - this.yMin) / this.yStride);
                class_2680 bs = nc.method_32892(y);
                short currId = (short)bs.method_26205(null, null).field_16021;
                if (currId == 0 && lastColorId > 0) {
                    currId = (short)(-lastColorId);
                    lastColorId = 0;
                } else {
                    lastColorId = currId;
                }
                this.sampler.expandRaw(p, currId, res);
            }
        }
        return results;
    }

    @Override
    public long flags() {
        return 3L;
    }
}

