/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.backend.worker;

import caeruleusTait.world.preview.WorldPreview;
import caeruleusTait.world.preview.backend.storage.PreviewLevel;
import caeruleusTait.world.preview.backend.stubs.DummyMinecraftServer;
import caeruleusTait.world.preview.backend.stubs.EmptyAquifer;
import caeruleusTait.world.preview.mixin.MinecraftServerAccessor;
import caeruleusTait.world.preview.mixin.NoiseBasedChunkGeneratorAccessor;
import caeruleusTait.world.preview.mixin.NoiseChunkAccessor;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Lifecycle;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import net.minecraft.class_1267;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1940;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_27;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2806;
import net.minecraft.class_2839;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_31;
import net.minecraft.class_3195;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3283;
import net.minecraft.class_3286;
import net.minecraft.class_3300;
import net.minecraft.class_3449;
import net.minecraft.class_3485;
import net.minecraft.class_3551;
import net.minecraft.class_3754;
import net.minecraft.class_3949;
import net.minecraft.class_4239;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5218;
import net.minecraft.class_5219;
import net.minecraft.class_5268;
import net.minecraft.class_5284;
import net.minecraft.class_5285;
import net.minecraft.class_5309;
import net.minecraft.class_5321;
import net.minecraft.class_5350;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_5742;
import net.minecraft.class_6568;
import net.minecraft.class_6748;
import net.minecraft.class_6832;
import net.minecraft.class_6860;
import net.minecraft.class_6904;
import net.minecraft.class_6916;
import net.minecraft.class_7138;
import net.minecraft.class_7225;
import net.minecraft.class_7237;
import net.minecraft.class_7497;
import net.minecraft.class_7659;
import net.minecraft.class_7699;
import net.minecraft.class_7712;
import net.minecraft.class_7780;
import net.minecraft.class_7869;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_8580;
import net.minecraft.class_8582;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SampleUtils
implements AutoCloseable {
    private final Path tempDir;
    private final DataFixer dataFixer;
    private final class_32.class_5143 levelStorageAccess;
    private final class_5539 levelHeightAccessor;
    private final class_6860 resourceManager;
    private final class_1966 biomeSource;
    private final class_7138 randomState;
    private final class_2794 chunkGenerator;
    private final class_5455 registryAccess;
    private final class_7869 chunkGeneratorStructureState;
    private final class_6832 structureCheck;
    private final class_5138 structureManager;
    private final class_3485 structureTemplateManager;
    private final PreviewLevel previewLevel;
    private final class_2378<class_3195> structureRegistry;
    private final class_5321<class_1937> dimension;
    private final class_5284 noiseGeneratorSettings;
    private final MinecraftServer minecraftServer;

    public SampleUtils(@NotNull MinecraftServer server, class_1966 biomeSource, class_2794 chunkGenerator, class_5285 worldOptions, class_5363 levelStem, class_5539 levelHeightAccessor) throws IOException {
        class_3754 noiseBasedChunkGenerator;
        this.tempDir = null;
        this.minecraftServer = server;
        this.dataFixer = this.minecraftServer.method_3855();
        this.levelStorageAccess = ((MinecraftServerAccessor)this.minecraftServer).getStorageSource();
        this.levelHeightAccessor = levelHeightAccessor;
        this.resourceManager = (class_6860)this.minecraftServer.method_34864();
        this.biomeSource = biomeSource;
        this.chunkGenerator = chunkGenerator;
        this.registryAccess = this.minecraftServer.method_30611();
        this.structureRegistry = this.registryAccess.method_30530(class_7924.field_41246);
        this.structureTemplateManager = this.minecraftServer.method_27727();
        this.previewLevel = new PreviewLevel(this.registryAccess, this.levelHeightAccessor);
        class_5321 levelStemResourceKey = (class_5321)this.registryAccess.method_30530(class_7924.field_41224).method_29113((Object)levelStem).orElseThrow();
        this.dimension = class_7924.method_47516((class_5321)levelStemResourceKey);
        if (chunkGenerator instanceof class_3754) {
            noiseBasedChunkGenerator = (class_3754)chunkGenerator;
            this.randomState = class_7138.method_41556((class_5284)((class_5284)noiseBasedChunkGenerator.method_41541().comp_349()), (class_7871)this.registryAccess.method_46762(class_7924.field_41244), (long)worldOptions.method_28028());
        } else {
            this.randomState = class_7138.method_41556((class_5284)class_5284.method_44323(), (class_7871)this.registryAccess.method_46762(class_7924.field_41244), (long)worldOptions.method_28028());
        }
        this.structureCheck = new class_6832(null, this.registryAccess, this.structureTemplateManager, this.dimension, this.chunkGenerator, this.randomState, this.levelHeightAccessor, chunkGenerator.method_12098(), worldOptions.method_28028(), this.dataFixer);
        this.structureManager = new class_5138((class_1936)this.previewLevel, worldOptions, this.structureCheck);
        this.chunkGeneratorStructureState = this.chunkGenerator.method_46696((class_7225)this.registryAccess.method_46762(class_7924.field_41248), this.randomState, worldOptions.method_28028());
        if (chunkGenerator instanceof class_3754) {
            noiseBasedChunkGenerator = (class_3754)chunkGenerator;
            this.noiseGeneratorSettings = (class_5284)noiseBasedChunkGenerator.method_41541().comp_349();
        } else {
            this.noiseGeneratorSettings = null;
        }
    }

    public SampleUtils(class_1966 biomeSource, class_2794 chunkGenerator, class_7780<class_7659> layeredRegistryAccess, class_5285 worldOptions, class_5363 levelStem, class_5539 levelHeightAccessor, class_7712 worldDataConfiguration, Proxy proxy, @Nullable Path tempDataPackDir) throws IOException {
        try {
            this.tempDir = Files.createTempDirectory("world_preview", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.dataFixer = class_3551.method_15450();
        class_32 levelStorageSource = new class_32(this.tempDir, this.tempDir.resolve("backups"), new class_8580(new class_8582(List.of())), this.dataFixer);
        this.levelStorageAccess = levelStorageSource.method_27002("world_preview");
        this.levelHeightAccessor = levelHeightAccessor;
        Path dataPackDir = this.levelStorageAccess.method_27010(class_5218.field_24186);
        class_4239.method_47525((Path)dataPackDir);
        if (tempDataPackDir != null) {
            try (Stream<Path> stream = Files.walk(tempDataPackDir, new FileVisitOption[0]);){
                stream.filter(x -> !x.equals(tempDataPackDir)).forEach(x -> {
                    try {
                        class_156.method_29775((Path)tempDataPackDir, (Path)dataPackDir, (Path)x);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
        }
        this.biomeSource = biomeSource;
        this.chunkGenerator = chunkGenerator;
        this.registryAccess = layeredRegistryAccess.method_45926();
        this.structureRegistry = this.registryAccess.method_30530(class_7924.field_41246);
        this.previewLevel = new PreviewLevel(this.registryAccess, this.levelHeightAccessor);
        class_3283 packRepository = class_3286.method_45285((class_32.class_5143)this.levelStorageAccess);
        this.resourceManager = (class_6860)new class_7237.class_7238(packRepository, worldDataConfiguration, false, false).method_42099().getSecond();
        class_7225 holderGetter = this.registryAccess.method_30530(class_7924.field_41254).method_46771().method_45919(worldDataConfiguration.comp_1011());
        this.structureTemplateManager = new class_3485((class_3300)this.resourceManager, this.levelStorageAccess, this.dataFixer, (class_7871)holderGetter);
        class_5321 levelStemResourceKey = (class_5321)this.registryAccess.method_30530(class_7924.field_41224).method_29113((Object)levelStem).orElseThrow();
        this.dimension = class_7924.method_47516((class_5321)levelStemResourceKey);
        class_1940 levelSettings = new class_1940("temp", class_1934.field_9220, false, class_1267.field_5802, true, new class_1928(), worldDataConfiguration);
        class_31 primaryLevelData = new class_31(levelSettings, worldOptions, class_31.class_7729.field_40373, Lifecycle.stable());
        class_5350 reloadableServerResources = new class_5350(layeredRegistryAccess.method_45926(), class_7699.method_45397(), class_2170.class_5364.field_25419, 0);
        class_6904 worldStem = new class_6904(this.resourceManager, reloadableServerResources, layeredRegistryAccess, (class_5219)primaryLevelData);
        this.minecraftServer = new DummyMinecraftServer(new Thread(() -> {}), this.levelStorageAccess, packRepository, worldStem, proxy, this.dataFixer, new class_7497(null, null, null, null), i -> new class_3949(){

            public void method_17669(class_1923 center) {
            }

            public void method_17670(class_1923 chunkPosition, @Nullable class_2806 newStatus) {
            }

            public void method_17675() {
            }

            public void method_17671() {
            }
        });
        WorldPreview.get().loaderSpecificSetup(this.minecraftServer);
        new class_3218(this.minecraftServer, (Executor)Executors.newSingleThreadExecutor(), this.levelStorageAccess, (class_5268)new class_27(worldStem.comp_359(), worldStem.comp_359().method_27859()), this.dimension, levelStem, new class_3949(){

            public void method_17669(class_1923 center) {
            }

            public void method_17670(class_1923 chunkPosition, @Nullable class_2806 newStatus) {
            }

            public void method_17675() {
            }

            public void method_17671() {
            }
        }, false, class_4543.method_27984((long)worldOptions.method_28028()), List.of(), false, null);
        if (chunkGenerator instanceof class_3754) {
            class_3754 noiseBasedChunkGenerator = (class_3754)chunkGenerator;
            this.noiseGeneratorSettings = (class_5284)noiseBasedChunkGenerator.method_41541().comp_349();
            this.randomState = class_7138.method_41556((class_5284)((class_5284)noiseBasedChunkGenerator.method_41541().comp_349()), (class_7871)this.registryAccess.method_46762(class_7924.field_41244), (long)worldOptions.method_28028());
        } else {
            this.noiseGeneratorSettings = null;
            this.randomState = class_7138.method_41556((class_5284)class_5284.method_44323(), (class_7871)this.registryAccess.method_46762(class_7924.field_41244), (long)worldOptions.method_28028());
        }
        this.structureCheck = new class_6832(null, this.registryAccess, this.structureTemplateManager, this.dimension, this.chunkGenerator, this.randomState, this.levelHeightAccessor, chunkGenerator.method_12098(), worldOptions.method_28028(), this.dataFixer);
        this.structureManager = new class_5138((class_1936)this.previewLevel, worldOptions, this.structureCheck);
        this.chunkGeneratorStructureState = this.chunkGenerator.method_46696((class_7225)this.registryAccess.method_46762(class_7924.field_41248), this.randomState, worldOptions.method_28028());
        this.chunkGeneratorStructureState.method_46712();
    }

    @Nullable
    public class_3222 getPlayers(UUID playerId) {
        if (this.minecraftServer instanceof DummyMinecraftServer) {
            return null;
        }
        return this.minecraftServer.method_3760().method_14602(playerId);
    }

    public class_5321<class_1959> doSample(class_2338 pos) {
        return (class_5321)this.biomeSource.method_38109(class_5742.method_33100((int)pos.method_10263()), class_5742.method_33100((int)pos.method_10264()), class_5742.method_33100((int)pos.method_10260()), this.randomState.method_42371()).method_40230().orElseThrow();
    }

    public List<Pair<class_2960, class_3449>> doStructures(class_1923 chunkPos) {
        class_2839 protoChunk = (class_2839)this.previewLevel.method_8402(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12803, false);
        this.chunkGenerator.method_16129(this.registryAccess, this.chunkGeneratorStructureState, this.structureManager, (class_2791)protoChunk, this.structureTemplateManager);
        Map raw = protoChunk.method_12016();
        ArrayList<Pair<class_2960, class_3449>> res = new ArrayList<Pair<class_2960, class_3449>>(raw.size());
        for (Map.Entry x : protoChunk.method_12016().entrySet()) {
            res.add((Pair<class_2960, class_3449>)new Pair((Object)this.structureRegistry.method_10221((Object)((class_3195)x.getKey())), (Object)((class_3449)x.getValue())));
        }
        return res;
    }

    public class_6568 getNoiseChunk(class_1923 startChunk, int numChunks, boolean keepAquifer) {
        class_5309 noiseSettings = this.noiseGeneratorSettings.comp_474();
        class_6568 noiseChunk = new class_6568(numChunks * 16 / noiseSettings.method_39546(), this.randomState, startChunk.method_8326(), startChunk.method_8328(), noiseSettings, (class_6916.class_7050)class_6916.class_7049.field_37076, this.noiseGeneratorSettings, ((NoiseBasedChunkGeneratorAccessor)this.chunkGenerator).getGlobalFluidPicker().get(), class_6748.method_39336());
        if (!keepAquifer) {
            ((NoiseChunkAccessor)noiseChunk).setAquifer(new EmptyAquifer());
        }
        return noiseChunk;
    }

    public class_5284 noiseGeneratorSettings() {
        return this.noiseGeneratorSettings;
    }

    public short doHeightSlow(class_2338 pos) {
        return (short)this.chunkGenerator.method_16397(pos.method_10263(), pos.method_10260(), class_2902.class_2903.field_13195, this.levelHeightAccessor, this.randomState);
    }

    public class_4966 doIntersectionsSlow(class_2338 pos) {
        return this.chunkGenerator.method_26261(pos.method_10263(), pos.method_10260(), this.levelHeightAccessor, this.randomState);
    }

    @Override
    public void close() throws Exception {
        if (this.minecraftServer instanceof DummyMinecraftServer) {
            WorldPreview.get().loaderSpecificTeardown(this.minecraftServer);
        }
        if (this.tempDir != null) {
            SampleUtils.deleteDirectoryLegacyIO(this.tempDir.toFile());
        }
    }

    public static void deleteDirectoryLegacyIO(File file) {
        File[] list = file.listFiles();
        if (list != null) {
            for (File temp : list) {
                SampleUtils.deleteDirectoryLegacyIO(temp);
            }
        }
        if (!file.delete()) {
            WorldPreview.LOGGER.warn("Unable to delete file or directory : {}", (Object)file);
        }
    }

    public class_6860 resourceManager() {
        return this.resourceManager;
    }

    public class_5455 registryAccess() {
        return this.registryAccess;
    }

    public class_5321<class_1937> dimension() {
        return this.dimension;
    }
}

