/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.backend.worker;

import caeruleusTait.world.preview.backend.color.PreviewData;
import caeruleusTait.world.preview.backend.sampler.ChunkSampler;
import caeruleusTait.world.preview.backend.worker.SampleUtils;
import caeruleusTait.world.preview.backend.worker.WorkResult;
import caeruleusTait.world.preview.backend.worker.WorkUnit;
import caeruleusTait.world.preview.mixin.NoiseChunkAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5284;
import net.minecraft.class_5309;
import net.minecraft.class_5742;
import net.minecraft.class_6568;

public class IntersectionWorkUnit
extends WorkUnit {
    private final ChunkSampler sampler;
    private final int numChunks;
    private final int yStride;

    public IntersectionWorkUnit(ChunkSampler sampler, SampleUtils sampleUtils, class_1923 chunkPos, int numChunks, PreviewData previewData, int yStride) {
        super(sampleUtils, chunkPos, previewData, 0);
        this.sampler = sampler;
        this.numChunks = numChunks;
        this.yStride = yStride;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<WorkResult> doWork() {
        class_5284 noiseGeneratorSettings = this.sampleUtils.noiseGeneratorSettings();
        if (noiseGeneratorSettings == null) {
            return List.of();
        }
        class_5309 noiseSettings = noiseGeneratorSettings.comp_474();
        class_6568 noiseChunk = this.sampleUtils.getNoiseChunk(this.chunkPos, this.numChunks, true);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        int yMin = noiseSettings.comp_173();
        int yMax = yMin + noiseSettings.comp_174();
        int cellWidth = noiseSettings.method_39546();
        int cellHeight = noiseSettings.method_39545();
        int cellMinY = class_3532.method_48116((int)yMin, (int)noiseSettings.method_39545());
        int cellCountY = class_3532.method_48116((int)noiseSettings.comp_174(), (int)noiseSettings.method_39545());
        int minBlockX = this.chunkPos.method_8326();
        int minBlockZ = this.chunkPos.method_8328();
        int cellCountXZ = 16 * this.numChunks / cellWidth;
        int cellStrideXZ = Math.max(1, this.sampler.blockStride() / cellWidth);
        int todoArraySize = Math.max(1, cellWidth / this.sampler.blockStride()) * Math.max(1, cellWidth / this.sampler.blockStride());
        ArrayList<WorkResult> results = new ArrayList<WorkResult>((yMax - yMin) / this.yStride);
        for (int y = yMin; y <= yMax; y += this.yStride) {
            results.add(new WorkResult(this, class_5742.method_33100((int)y), y == this.y ? this.primarySection : this.storage.section4(this.chunkPos, y, this.flags()), new ArrayList<WorkResult.BlockResult>(this.numChunks * this.numChunks * 4 * 4), List.of()));
        }
        noiseChunk.method_38336();
        try {
            for (int cellX = 0; cellX < cellCountXZ && !this.isCanceled(); cellX += cellStrideXZ) {
                noiseChunk.method_38339(cellX);
                for (int cellZ = 0; cellZ < cellCountXZ && !this.isCanceled(); cellZ += cellStrideXZ) {
                    ArrayList<XZPair> positions = new ArrayList<XZPair>(todoArraySize);
                    for (int xInCell = 0; xInCell < cellWidth; xInCell += this.sampler.blockStride()) {
                        for (int zInCell = 0; zInCell < cellWidth; zInCell += this.sampler.blockStride()) {
                            int x = minBlockX + cellX * cellWidth + xInCell;
                            int z = minBlockZ + cellZ * cellWidth + zInCell;
                            positions.add(new XZPair(x, (double)xInCell / (double)cellWidth, z, (double)zInCell / (double)cellWidth, new AtomicInteger(0)));
                        }
                    }
                    int lastCellY = Integer.MIN_VALUE;
                    for (int yTemp = yMin; yTemp <= yMax; yTemp += this.yStride) {
                        int y = Math.min(yTemp, yMax - 1);
                        int cellY = Math.min(Math.floorDiv(y - yMin, cellHeight), cellCountY - 1);
                        int yInCell = y % cellHeight;
                        if (cellY != lastCellY) {
                            noiseChunk.method_38362(cellY, cellZ);
                        }
                        noiseChunk.method_38337(y, (double)yInCell / (double)cellHeight);
                        lastCellY = cellY;
                        WorkResult res = (WorkResult)results.get((yTemp - yMin) / this.yStride);
                        for (XZPair curr : positions) {
                            noiseChunk.method_38349(curr.x, curr.dX);
                            noiseChunk.method_38355(curr.z, curr.dZ);
                            class_2680 blockState = ((NoiseChunkAccessor)noiseChunk).invokeGetInterpolatedState();
                            if (blockState == null) {
                                blockState = noiseGeneratorSettings.comp_475();
                            }
                            short colorId = (short)blockState.method_26205(null, null).field_16021;
                            short lastId = (short)curr.mutableLastValue.getAndSet(colorId);
                            if (colorId == 0 && lastId > 0) {
                                colorId = -lastId;
                            }
                            mutableBlockPos.method_10103(curr.x, yTemp, curr.z);
                            this.sampler.expandRaw((class_2338)mutableBlockPos, colorId, res);
                        }
                    }
                }
                noiseChunk.method_38348();
            }
        }
        finally {
            noiseChunk.method_40537();
        }
        return results;
    }

    @Override
    public long flags() {
        return 3L;
    }

    private record XZPair(int x, double dX, int z, double dZ, AtomicInteger mutableLastValue) {
    }
}

