/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.backend.worker;

import caeruleusTait.world.preview.WorldPreviewConfig;
import caeruleusTait.world.preview.backend.color.PreviewData;
import caeruleusTait.world.preview.backend.sampler.ChunkSampler;
import caeruleusTait.world.preview.backend.worker.SampleUtils;
import caeruleusTait.world.preview.backend.worker.WorkResult;
import caeruleusTait.world.preview.backend.worker.WorkUnit;
import caeruleusTait.world.preview.mixin.NoiseChunkAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3532;
import net.minecraft.class_5284;
import net.minecraft.class_5309;
import net.minecraft.class_5742;
import net.minecraft.class_6568;

public class HeightmapWorkUnit
extends WorkUnit {
    private final ChunkSampler sampler;
    private final int numChunks;

    public HeightmapWorkUnit(ChunkSampler sampler, SampleUtils sampleUtils, class_1923 chunkPos, int numChunks, PreviewData previewData) {
        super(sampleUtils, chunkPos, previewData, 0);
        this.sampler = sampler;
        this.numChunks = numChunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<WorkResult> doWork() {
        WorkResult res = new WorkResult(this, class_5742.method_33100((int)0), this.primarySection, new ArrayList<WorkResult.BlockResult>(this.numChunks * this.numChunks * 4 * 4), List.of());
        class_5284 noiseGeneratorSettings = this.sampleUtils.noiseGeneratorSettings();
        WorldPreviewConfig config = this.workManager.config();
        if (noiseGeneratorSettings == null) {
            return List.of(res);
        }
        class_5309 noiseSettings = noiseGeneratorSettings.comp_474();
        class_6568 noiseChunk = this.sampleUtils.getNoiseChunk(this.chunkPos, this.numChunks, false);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        int cellWidth = noiseSettings.method_39546();
        int cellHeight = noiseSettings.method_39545();
        int minY = config.onlySampleInVisualRange ? config.heightmapMinY : noiseSettings.comp_173();
        int maxY = config.onlySampleInVisualRange ? config.heightmapMaxY : minY + noiseSettings.comp_174();
        int cellMinY = class_3532.method_48116((int)minY, (int)noiseSettings.method_39545());
        int cellCountY = class_3532.method_48116((int)(maxY - minY), (int)noiseSettings.method_39545());
        int cellOffsetY = config.onlySampleInVisualRange ? cellMinY - class_3532.method_48116((int)noiseSettings.comp_173(), (int)noiseSettings.method_39545()) : 0;
        int minBlockX = this.chunkPos.method_8326();
        int minBlockZ = this.chunkPos.method_8328();
        int cellCountXZ = 16 * this.numChunks / cellWidth;
        int cellStrideXZ = Math.max(1, this.sampler.blockStride() / cellWidth);
        int todoArraySize = Math.max(1, cellWidth / this.sampler.blockStride()) * Math.max(1, cellWidth / this.sampler.blockStride());
        Predicate predicate = class_2902.class_2903.field_13195.method_16402();
        noiseChunk.method_38336();
        try {
            for (int cellX = 0; cellX < cellCountXZ && !this.isCanceled(); cellX += cellStrideXZ) {
                noiseChunk.method_38339(cellX);
                for (int cellZ = 0; cellZ < cellCountXZ && !this.isCanceled(); cellZ += cellStrideXZ) {
                    ArrayList<XZPair> positions = new ArrayList<XZPair>(todoArraySize);
                    for (int xInCell = 0; xInCell < cellWidth; xInCell += this.sampler.blockStride()) {
                        for (int zInCell = 0; zInCell < cellWidth; zInCell += this.sampler.blockStride()) {
                            int x = minBlockX + cellX * cellWidth + xInCell;
                            int z = minBlockZ + cellZ * cellWidth + zInCell;
                            positions.add(new XZPair(x, (double)xInCell / (double)cellWidth, z, (double)zInCell / (double)cellWidth));
                        }
                    }
                    for (int cellY = cellCountY - 1; cellY >= 0 && !positions.isEmpty() && !this.isCanceled(); --cellY) {
                        noiseChunk.method_38362(cellY + cellOffsetY, cellZ);
                        for (int yInCell = cellHeight - 1; yInCell >= 0 && !positions.isEmpty(); --yInCell) {
                            int y = (cellMinY + cellY) * cellHeight + yInCell;
                            noiseChunk.method_38337(y, (double)yInCell / (double)cellHeight);
                            for (int idx = 0; idx < positions.size(); ++idx) {
                                XZPair curr = (XZPair)positions.get(idx);
                                noiseChunk.method_38349(curr.x, curr.dX);
                                noiseChunk.method_38355(curr.z, curr.dZ);
                                class_2680 blockState = ((NoiseChunkAccessor)noiseChunk).invokeGetInterpolatedState();
                                if (blockState == null) {
                                    blockState = noiseGeneratorSettings.comp_475();
                                }
                                if (!predicate.test(blockState)) continue;
                                mutableBlockPos.method_10103(curr.x, 0, curr.z);
                                this.sampler.expandRaw((class_2338)mutableBlockPos, (short)(y + 1), res);
                                positions.remove(idx--);
                            }
                        }
                    }
                }
                noiseChunk.method_38348();
            }
        }
        finally {
            noiseChunk.method_40537();
        }
        return List.of(res);
    }

    @Override
    public long flags() {
        return 2L;
    }

    private record XZPair(int x, double dX, int z, double dZ) {
    }
}

