/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.backend.storage;

import caeruleusTait.world.preview.backend.storage.PreviewBlock;
import caeruleusTait.world.preview.backend.storage.PreviewSection;
import caeruleusTait.world.preview.backend.storage.PreviewSectionCompressed;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_5742;

public class PreviewStorage
implements Serializable {
    private static final long serialVersionUID = -275836689822028264L;
    public static final long FLAG_BITS = 4L;
    public static final long FLAG_MASK = 15L;
    public static final long XZ_BITS = 30L;
    public static final long XZ_MASK = 0x3FFFFFFFL;
    public static final long XZ_OFFSET = 0x20000000L;
    public static final long FLAG_SHIFT = 0L;
    public static final long Z_SHIFT = 4L;
    public static final long X_SHIFT = 34L;
    public static final long FLAG_BIOME = 0L;
    public static final long FLAG_STRUCT_START = 1L;
    public static final long FLAG_HEIGHT = 2L;
    public static final long FLAG_INTERSECT = 3L;
    public static final long FLAG_STRUCT_REF = 15L;
    private transient Long2ObjectMap<PreviewBlock>[] blocks;
    private final int yMin;
    private final int yMax;

    public PreviewStorage(int yMin, int yMax) {
        this.blocks = new Long2ObjectMap[(yMax - yMin >> 3) + 1];
        for (int i = 0; i < this.blocks.length; ++i) {
            this.blocks[i] = new Long2ObjectOpenHashMap(1024, 0.5f);
        }
        this.yMin = yMin;
        this.yMax = yMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreviewSection section4(class_2338 bp, long flags) {
        PreviewBlock block;
        int quartX = class_5742.method_33100((int)bp.method_10263());
        int indexY = bp.method_10264() - this.yMin >> 3;
        int quartZ = class_5742.method_33100((int)bp.method_10260());
        Long2ObjectMap<PreviewBlock> long2ObjectMap = this.blocks[indexY];
        synchronized (long2ObjectMap) {
            block = (PreviewBlock)this.blocks[indexY].computeIfAbsent(PreviewStorage.quartPosToSectionLong(quartX, quartZ, flags), x -> new PreviewBlock(flags));
        }
        return block.get(quartX, quartZ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreviewSection section4(class_1923 chunkPos, int y, long flags) {
        PreviewBlock block;
        int quartX = class_5742.method_33102((int)chunkPos.field_9181);
        int indexY = y - this.yMin >> 3;
        int quartZ = class_5742.method_33102((int)chunkPos.field_9180);
        Long2ObjectMap<PreviewBlock> long2ObjectMap = this.blocks[indexY];
        synchronized (long2ObjectMap) {
            block = (PreviewBlock)this.blocks[indexY].computeIfAbsent(PreviewStorage.quartPosToSectionLong(quartX, quartZ, flags), x -> new PreviewBlock(flags));
        }
        return block.get(quartX, quartZ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreviewSection section4(int quartX, int quartY, int quartZ, long flags) {
        PreviewBlock block;
        int indexY = class_5742.method_33101((int)quartY) - this.yMin >> 3;
        Long2ObjectMap<PreviewBlock> long2ObjectMap = this.blocks[indexY];
        synchronized (long2ObjectMap) {
            block = (PreviewBlock)this.blocks[indexY].computeIfAbsent(PreviewStorage.quartPosToSectionLong(quartX, quartZ, flags), x -> new PreviewBlock(flags));
        }
        return block.get(quartX, quartZ);
    }

    public short getBiome4(class_2338 bp) {
        int quartX = class_5742.method_33100((int)bp.method_10263());
        int quartY = class_5742.method_33100((int)bp.method_10264());
        int quartZ = class_5742.method_33100((int)bp.method_10260());
        return this.getRawData4(quartX, quartY, quartZ, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getRawData4(int quartX, int quartY, int quartZ, long flags) {
        PreviewBlock block;
        int indexY = class_5742.method_33101((int)quartY) - this.yMin >> 3;
        Long2ObjectMap<PreviewBlock> long2ObjectMap = this.blocks[indexY];
        synchronized (long2ObjectMap) {
            block = (PreviewBlock)this.blocks[indexY].get(PreviewStorage.quartPosToSectionLong(quartX, quartZ, flags));
        }
        if (block == null) {
            return Short.MIN_VALUE;
        }
        PreviewSection section = block.get(quartX, quartZ);
        return section.get(quartX - section.quartX(), quartZ - section.quartZ());
    }

    public static long blockPos2SectionLong(class_2338 bp, long flags) {
        return PreviewStorage.quartPosToSectionLong(class_5742.method_33100((int)bp.method_10263()), class_5742.method_33100((int)bp.method_10260()), flags);
    }

    public static long quartPosToSectionLong(long quartX, long quartZ, long flags) {
        long sX = quartX >> 11;
        long sZ = quartZ >> 11;
        return (sX & 0x3FFFFFFFL) << 34 | (sZ & 0x3FFFFFFFL) << 4 | (flags & 0xFL) << 0;
    }

    public static long compressXYZ(long x, long z, long flags) {
        return (x & 0x3FFFFFFFL) << 34 | (z & 0x3FFFFFFFL) << 4 | (flags & 0xFL) << 0;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeInt(this.blocks.length);
        for (Long2ObjectMap<PreviewBlock> ySec : this.blocks) {
            ObjectSet entrySet = ySec.long2ObjectEntrySet();
            oos.writeInt(entrySet.size());
            for (Long2ObjectMap.Entry x : entrySet) {
                oos.writeLong(x.getLongKey());
                oos.writeObject(x.getValue());
            }
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.blocks = new Long2ObjectMap[(this.yMax - this.yMin >> 3) + 1];
        int serializedSize = ois.readInt();
        if (serializedSize != this.blocks.length) {
            throw new IOException("serializedSize != sections.length: " + serializedSize + " != " + this.blocks.length);
        }
        for (int i = 0; i < this.blocks.length; ++i) {
            this.blocks[i] = new Long2ObjectOpenHashMap(1024, 0.5f);
            int size = ois.readInt();
            for (int j = 0; j < size; ++j) {
                long key = ois.readLong();
                PreviewBlock section = (PreviewBlock)ois.readObject();
                this.blocks[i].put(key, (Object)section);
            }
        }
    }

    public List<Short> compressionStatistics() {
        ArrayList<Short> res = new ArrayList<Short>();
        for (Long2ObjectMap<PreviewBlock> x : this.blocks) {
            for (PreviewBlock block : x.values()) {
                for (PreviewSection section : block.sections()) {
                    if (!(section instanceof PreviewSectionCompressed)) continue;
                    PreviewSectionCompressed cSection = (PreviewSectionCompressed)section;
                    res.add(cSection.mapSize());
                }
            }
        }
        return res;
    }
}

