/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.backend.storage;

import java.io.Serializable;
import java.util.BitSet;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_3341;
import net.minecraft.class_5742;

public abstract class PreviewSection
implements Serializable {
    public static final int SHIFT = 6;
    public static final int SIZE = 64;
    public static final int OFFSET = 32;
    public static final int MASK = -64;
    public static final int HALF_SHIFT = 1;
    public static final int HALF_SIZE = 32;
    public static final int QUART_TO_SECTION_SHIFT = 2;
    public static final int SECTION_SIZE = 16;
    private final int quartX;
    private final int quartZ;
    private final int chunkX;
    private final int chunkZ;
    private final BitSet completed = new BitSet(512);

    protected PreviewSection(int quartX, int quartZ) {
        this.quartX = quartX & 0xFFFFFFC0;
        this.quartZ = quartZ & 0xFFFFFFC0;
        this.chunkX = this.quartX >> 2;
        this.chunkZ = this.quartZ >> 2;
    }

    public abstract int size();

    public abstract short get(int var1, int var2);

    public abstract void set(int var1, int var2, short var3);

    public abstract List<PreviewStruct> structures();

    public abstract void addStructure(PreviewStruct var1);

    public synchronized boolean isCompleted(class_1923 chunkPos) {
        return this.completed.get((chunkPos.field_9181 - this.chunkX) * 16 + (chunkPos.field_9180 - this.chunkZ));
    }

    public synchronized void markCompleted(class_1923 chunkPos) {
        this.completed.set((chunkPos.field_9181 - this.chunkX) * 16 + (chunkPos.field_9180 - this.chunkZ));
    }

    public AccessData calcQuartOffsetData(int minQuartX, int minQuartZ, int maxQuartX, int maxQuartZ) {
        int accessMinX = minQuartX - this.quartX;
        int accessMinZ = minQuartZ - this.quartZ;
        int accessMaxX = maxQuartX - this.quartX;
        int accessMaxZ = maxQuartZ - this.quartZ;
        return new AccessData(accessMinX, accessMinZ, Math.min(accessMaxX, 64), Math.min(accessMaxZ, 64), accessMaxX > 64, accessMaxZ > 64);
    }

    public int quartX() {
        return this.quartX;
    }

    public int quartZ() {
        return this.quartZ;
    }

    public int blockX() {
        return class_5742.method_33101((int)this.quartX);
    }

    public int blockZ() {
        return class_5742.method_33101((int)this.quartZ);
    }

    public record AccessData(int minX, int minZ, int maxX, int maxZ, boolean continueX, boolean continueZ) implements Serializable
    {
    }

    public record PreviewStruct(class_2338 center, short structureId, class_3341 boundingBox) {
    }
}

