/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.backend.color;

import java.security.InvalidParameterException;
import java.util.List;
import net.minecraft.class_2960;

public class ColorMap {
    private final class_2960 key;
    private final String name;
    private final Color[] colors;

    public ColorMap(class_2960 key, String name, Color[] colors) {
        this.key = key;
        this.name = name;
        this.colors = colors;
    }

    public class_2960 key() {
        return this.key;
    }

    public String name() {
        return this.name;
    }

    public ColorMap(class_2960 key, RawColorMap raw) {
        this.key = key;
        this.name = raw.name;
        if (raw.data.size() < 2) {
            throw new InvalidParameterException(this.name + ": All colormaps MUST have at least 2 entries");
        }
        this.colors = new Color[raw.data.size()];
        for (int i = 0; i < raw.data.size(); ++i) {
            List<Float> entry = raw.data.get(i);
            if (entry.size() != 3) {
                throw new InvalidParameterException(this.name + ": All entries in a colormap data MUST have exactly 3 elements: [R, G, B]!");
            }
            if (entry.stream().anyMatch(x -> (double)x.floatValue() < 0.0 || (double)x.floatValue() > 1.0)) {
                throw new InvalidParameterException(this.name + ": All values in a colormap data MUST be between 0.0 and 1.0 (inclusive)");
            }
            this.colors[i] = new Color(entry.get(0).floatValue(), entry.get(1).floatValue(), entry.get(2).floatValue());
        }
    }

    public Color get(float position) {
        if (position < 0.0f) {
            return this.colors[0];
        }
        if (position > 1.0f) {
            return this.colors[this.colors.length - 1];
        }
        float pos = position * (float)(this.colors.length - 1);
        int floor = (int)pos;
        if (pos == (float)floor) {
            return this.colors[floor];
        }
        if (pos == (float)(floor + 1)) {
            return this.colors[floor + 1];
        }
        return ColorMap.lerp(this.colors[floor], this.colors[floor + 1], pos - (float)floor);
    }

    public int getARGB(float position) {
        Color c = this.get(position);
        int R = (int)(c.r * 255.0f) & 0xFF;
        int G = (int)(c.g * 255.0f) & 0xFF;
        int B = (int)(c.b * 255.0f) & 0xFF;
        return R << 0 | G << 8 | B << 16 | 0xFF000000;
    }

    public int[] bake(int yMin, int yMax, int yVisMin, int yVisMax) {
        int[] res = new int[yMax - yMin];
        float visRange = (float)yVisMax - (float)yVisMin;
        for (int i = yMin; i < yMax; ++i) {
            res[i - yMin] = this.getARGB((float)(i - yVisMin) / visRange);
        }
        return res;
    }

    static float[] RGBToXYZ(float[] out, float r, float g, float b) {
        float R = ((double)r > 0.04045 ? (float)Math.pow((r + 0.055f) / 1.055f, 2.4f) : r / 12.92f) * 100.0f;
        float G = ((double)g > 0.04045 ? (float)Math.pow((g + 0.055f) / 1.055f, 2.4f) : g / 12.92f) * 100.0f;
        float B = ((double)b > 0.04045 ? (float)Math.pow((b + 0.055f) / 1.055f, 2.4f) : b / 12.92f) * 100.0f;
        out[0] = R * 0.4124564f + G * 0.3575761f + B * 0.1804375f;
        out[1] = R * 0.2126729f + G * 0.7151522f + B * 0.072175f;
        out[2] = R * 0.0193339f + G * 0.119192f + B * 0.9503041f;
        return out;
    }

    static float[] XYZToLab(float[] out, float x, float y, float z) {
        float a = x / 95.047f;
        float b = y * 0.01f;
        float c = z / 108.883f;
        float j = 0.13793103f;
        a = (double)a > 0.008856 ? (float)Math.cbrt(a) : 7.787f * a + 0.13793103f;
        b = (double)b > 0.008856 ? (float)Math.cbrt(b) : 7.787f * b + 0.13793103f;
        c = (double)c > 0.008856 ? (float)Math.cbrt(c) : 7.787f * c + 0.13793103f;
        out[0] = 116.0f * b - 16.0f;
        out[1] = 500.0f * (a - b);
        out[2] = 200.0f * (b - c);
        return out;
    }

    static float[] LabToXYZ(float[] out, float L, float a, float b) {
        out[1] = (L + 16.0f) / 116.0f;
        out[0] = a / 500.0f + out[1];
        out[2] = out[1] - b / 200.0f;
        for (int i = 0; i < 3; ++i) {
            if (out[i] > 0.20689304f) {
                int n = i;
                out[n] = out[n] * (out[i] * out[i]);
                continue;
            }
            out[i] = (out[i] - 0.13793103f) / 7.787f;
        }
        out[0] = out[0] * 95.047f;
        out[1] = out[1] * 100.0f;
        out[2] = out[2] * 108.883f;
        return out;
    }

    static float[] XYZToRGB(float[] out, float x, float y, float z) {
        float X = x / 100.0f;
        float Y = y / 100.0f;
        float Z = z / 100.0f;
        out[0] = X * 3.2404542f + Y * -1.5371385f + Z * -0.4985314f;
        out[1] = X * -0.969266f + Y * 1.8760108f + Z * 0.041556f;
        out[2] = X * 0.0556434f + Y * -0.2040259f + Z * 1.0572252f;
        for (int i = 0; i < 3; ++i) {
            out[i] = (double)out[i] > 0.0031308 ? 1.055f * (float)Math.pow(out[i], 0.4166666666666667) - 0.055f : 12.92f * out[i];
        }
        return out;
    }

    public static float[] LabToRGB(float L, float a, float b) {
        float[] out = new float[3];
        return ColorMap.XYZToRGB(ColorMap.LabToXYZ(out, L, a, b), out[0], out[1], out[2]);
    }

    public static float[] RGBToLab(float r, float g, float b) {
        float[] out = new float[3];
        return ColorMap.XYZToLab(ColorMap.RGBToXYZ(out, r, g, b), out[0], out[1], out[2]);
    }

    public static float clamp(float val, float min, float max) {
        return Math.min(Math.max(val, min), max);
    }

    public static float lerp(float low, float high, float amt) {
        amt = ColorMap.clamp(amt, 0.0f, 1.0f);
        return low * amt + high * (1.0f - amt);
    }

    public static Color lerp(Color lower, Color upper, float amount) {
        float[] lowerLab = ColorMap.RGBToLab(lower.r, lower.g, lower.b);
        float[] upperLab = ColorMap.RGBToLab(upper.r, upper.g, upper.b);
        float[] rgb = ColorMap.LabToRGB(ColorMap.lerp(upperLab[0], lowerLab[0], amount), ColorMap.lerp(upperLab[1], lowerLab[1], amount), ColorMap.lerp(upperLab[2], lowerLab[2], amount));
        return new Color(ColorMap.clamp(rgb[0], 0.0f, 1.0f), ColorMap.clamp(rgb[1], 0.0f, 1.0f), ColorMap.clamp(rgb[2], 0.0f, 1.0f));
    }

    public record Color(float r, float g, float b) {
    }

    public record RawColorMap(String name, List<List<Float>> data) {
    }
}

