/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.backend.color;

import caeruleusTait.world.preview.WorldPreview;
import caeruleusTait.world.preview.backend.color.BaseMultiJsonResourceReloadListener;
import caeruleusTait.world.preview.backend.color.PreviewData;
import caeruleusTait.world.preview.backend.color.PreviewMappingData;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

public class BiomeColorMapReloadListener
extends BaseMultiJsonResourceReloadListener {
    public BiomeColorMapReloadListener() {
        super("biome_colors.json");
    }

    protected void apply(Map<class_2960, List<JsonElement>> object, class_3300 resourceManager, class_3695 profiler) {
        WorldPreview worldPreview = WorldPreview.get();
        PreviewMappingData previewMappingData = worldPreview.biomeColorMap();
        previewMappingData.clearBiomes();
        WorldPreview.LOGGER.debug("Loading color resource entries");
        for (Map.Entry<class_2960, List<JsonElement>> entry : object.entrySet()) {
            WorldPreview.LOGGER.debug(" - loading entries from {}", (Object)entry.getKey());
            for (JsonElement j : entry.getValue()) {
                Map<class_2960, PreviewMappingData.ColorEntry> curr = BiomeColorMapReloadListener.parseColorData(entry.getKey().method_12836(), j, PreviewData.DataSource.RESOURCE);
                previewMappingData.update(curr);
            }
        }
        if (!Files.exists(worldPreview.userColorConfigFile(), new LinkOption[0])) {
            return;
        }
        previewMappingData.makeBiomeResourceOnlyBackup();
        WorldPreview.LOGGER.debug(" - loading entries from {}", (Object)worldPreview.userColorConfigFile());
        JsonElement el = null;
        try {
            el = JsonParser.parseString((String)Files.readString(worldPreview.userColorConfigFile()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Map<class_2960, PreviewMappingData.ColorEntry> curr = BiomeColorMapReloadListener.parseColorData("", el, PreviewData.DataSource.CONFIG);
        previewMappingData.update(curr);
    }

    public static Map<class_2960, PreviewMappingData.ColorEntry> parseColorData(String namespace, JsonElement jsonElement, PreviewData.DataSource dataSource) {
        HashMap<class_2960, PreviewMappingData.ColorEntry> res = new HashMap<class_2960, PreviewMappingData.ColorEntry>();
        JsonObject obj = jsonElement.getAsJsonObject();
        for (Map.Entry entry : obj.entrySet()) {
            PreviewMappingData.ColorEntry value;
            class_2960 location;
            block5: {
                location = ((String)entry.getKey()).indexOf(58) < 0 ? new class_2960(namespace, (String)entry.getKey()) : new class_2960((String)entry.getKey());
                value = new PreviewMappingData.ColorEntry();
                JsonElement rawEl = (JsonElement)entry.getValue();
                value.dataSource = dataSource;
                try {
                    JsonObject raw = rawEl.getAsJsonObject();
                    JsonElement nameEl = raw.get("name");
                    JsonElement colorEl = raw.get("color");
                    JsonElement rEl = raw.get("r");
                    JsonElement gEl = raw.get("g");
                    JsonElement bEl = raw.get("b");
                    String string = value.name = nameEl == null ? null : nameEl.getAsString();
                    if (colorEl != null) {
                        value.color = colorEl.getAsInt() & 0xFFFFFF;
                        break block5;
                    }
                    if (rEl != null && gEl != null && bEl != null) {
                        int r = rEl.getAsInt() & 0xFF;
                        int g = gEl.getAsInt() & 0xFF;
                        int b = bEl.getAsInt() & 0xFF;
                        value.color = r << 16 | g << 8 | b;
                        break block5;
                    }
                    throw new IllegalStateException("No color was provided!");
                }
                catch (IllegalStateException | NullPointerException | UnsupportedOperationException e) {
                    WorldPreview.LOGGER.warn("   - {}: Invalid color entry format: {}", (Object)location, (Object)e.getMessage());
                    continue;
                }
            }
            WorldPreview.LOGGER.debug("   - {}: {}", (Object)location, (Object)String.format("0x%06X", value.color & 0xFFFFFF));
            res.put(location, value);
        }
        return res;
    }
}

