/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.backend;

import caeruleusTait.world.preview.RenderSettings;
import caeruleusTait.world.preview.WorldPreview;
import caeruleusTait.world.preview.WorldPreviewConfig;
import caeruleusTait.world.preview.backend.color.PreviewData;
import caeruleusTait.world.preview.backend.sampler.ChunkSampler;
import caeruleusTait.world.preview.backend.storage.PreviewStorage;
import caeruleusTait.world.preview.backend.storage.PreviewStorageCacheManager;
import caeruleusTait.world.preview.backend.worker.FullChunkWorkUnit;
import caeruleusTait.world.preview.backend.worker.HeightmapWorkUnit;
import caeruleusTait.world.preview.backend.worker.IntersectionWorkUnit;
import caeruleusTait.world.preview.backend.worker.LayerChunkWorkUnit;
import caeruleusTait.world.preview.backend.worker.SampleUtils;
import caeruleusTait.world.preview.backend.worker.SlowHeightmapWorkUnit;
import caeruleusTait.world.preview.backend.worker.SlowIntersectionWorkUnit;
import caeruleusTait.world.preview.backend.worker.StructStartWorkUnit;
import caeruleusTait.world.preview.backend.worker.WorkBatch;
import caeruleusTait.world.preview.backend.worker.WorkUnit;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.IOException;
import java.net.Proxy;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SplittableRandom;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import net.minecraft.class_1923;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_3300;
import net.minecraft.class_5285;
import net.minecraft.class_5363;
import net.minecraft.class_5539;
import net.minecraft.class_7659;
import net.minecraft.class_7712;
import net.minecraft.class_7780;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class WorkManager {
    public static final int Y_BLOCK_SHIFT = 3;
    public static final int Y_BLOCK_STRIDE = 8;
    private final Object completedSynchro = new Object();
    private class_5285 worldOptions;
    private class_5363 levelStem;
    private class_2874 dimensionType;
    private class_2794 chunkGenerator;
    private class_1966 biomeSource;
    private ChunkSampler chunkSampler;
    private SampleUtils sampleUtils;
    private PreviewData previewData;
    private PreviewStorage previewStorage;
    private PreviewStorageCacheManager previewStorageCacheManager;
    private final RenderSettings renderSettings;
    private final WorldPreviewConfig config;
    private final List<WorkBatch> currentBatches = new ArrayList<WorkBatch>();
    private final List<Future<?>> futures = new ArrayList();
    private final List<Future<?>> queueFutures = new ArrayList();
    private final SplittableRandom random = new SplittableRandom();
    private ExecutorService executorService;
    private ExecutorService queueChunksService;
    private class_1923 lastQueuedTopLeft;
    private class_1923 lastQueuedBotRight;
    private int lastY;
    private boolean queueIsRunning = false;
    private boolean shouldEarlyAbortQueuing = false;

    public WorkManager(RenderSettings renderSettings, WorldPreviewConfig config) {
        this.config = config;
        this.renderSettings = renderSettings;
    }

    public synchronized void changeWorldGenState(class_5363 _levelStem, class_7780<class_7659> _registryAccess, PreviewData _previewData, class_5285 _worldOptions, class_7712 _worldDataConfiguration, PreviewStorageCacheManager _previewStorageCacheManager, Proxy proxy, @Nullable Path tempDataPackDir, @Nullable MinecraftServer server) {
        this.cancel();
        this.worldOptions = _worldOptions;
        this.levelStem = _levelStem;
        this.dimensionType = (class_2874)this.levelStem.comp_1012().comp_349();
        this.chunkGenerator = this.levelStem.comp_1013();
        this.biomeSource = this.chunkGenerator.method_12098();
        this.previewStorageCacheManager = _previewStorageCacheManager;
        this.chunkSampler = this.renderSettings.samplerType.create(this.renderSettings.quartStride());
        this.previewData = _previewData;
        class_5539 levelHeightAccessor = class_5539.method_39034((int)this.dimensionType.comp_651(), (int)this.dimensionType.comp_652());
        try {
            this.sampleUtils = server == null ? new SampleUtils(this.biomeSource, this.chunkGenerator, _registryAccess, this.worldOptions, this.levelStem, levelHeightAccessor, _worldDataConfiguration, proxy, tempDataPackDir) : new SampleUtils(server, this.biomeSource, this.chunkGenerator, this.worldOptions, this.levelStem, levelHeightAccessor);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void postChangeWorldGenState() {
        this.previewStorage = this.previewStorageCacheManager.loadPreviewStorage(this.worldOptions.method_28028(), this.yMin(), this.yMax());
        this.executorService = Executors.newFixedThreadPool(this.config.numThreads());
        this.queueChunksService = Executors.newSingleThreadExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownExecutors() {
        if (this.executorService == null) {
            return;
        }
        this.shouldEarlyAbortQueuing = true;
        List<WorkBatch> list = this.currentBatches;
        synchronized (list) {
            this.currentBatches.forEach(WorkBatch::cancel);
            this.currentBatches.clear();
        }
        try {
            ArrayList allFutures = new ArrayList();
            List<Future<?>> list2 = this.futures;
            synchronized (list2) {
                allFutures.addAll(this.queueFutures);
                allFutures.addAll(this.futures);
            }
            for (Future future : allFutures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        this.executorService.shutdownNow();
        this.queueChunksService.shutdownNow();
    }

    public void cancel() {
        this.shutdownExecutors();
        Executor serverThreadPoolExecutor = WorldPreview.get().serverThreadPoolExecutor();
        if (this.sampleUtils != null) {
            try {
                if (serverThreadPoolExecutor != null) {
                    CompletableFuture.runAsync(() -> {
                        try {
                            this.sampleUtils.close();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }, serverThreadPoolExecutor).get();
                } else {
                    this.sampleUtils.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.previewStorageCacheManager != null) {
            this.previewStorageCacheManager.storePreviewStorage(this.worldOptions.method_28028(), this.previewStorage);
        }
        this.worldOptions = null;
        this.levelStem = null;
        this.dimensionType = null;
        this.chunkGenerator = null;
        this.sampleUtils = null;
        this.previewStorage = null;
        this.lastQueuedTopLeft = null;
        this.lastQueuedBotRight = null;
        this.lastY = Integer.MIN_VALUE;
        this.queueIsRunning = false;
        this.futures.clear();
        this.executorService = null;
        this.queueChunksService = null;
        this.previewStorageCacheManager = null;
    }

    private boolean requeueOnYOnlyChange() {
        return !this.config.buildFullVertChunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueRange(class_2338 topLeftBlock, class_2338 bottomRightBlock) {
        class_1923 topLeft = new class_1923(topLeftBlock);
        class_1923 bottomRight = new class_1923(bottomRightBlock);
        if (this.executorService == null || topLeft.equals((Object)this.lastQueuedTopLeft) && bottomRight.equals((Object)this.lastQueuedBotRight) && (topLeftBlock.method_10264() == this.lastY || !this.requeueOnYOnlyChange())) {
            return;
        }
        if (this.queueIsRunning) {
            this.shouldEarlyAbortQueuing = true;
            return;
        }
        this.lastQueuedTopLeft = topLeft;
        this.lastQueuedBotRight = bottomRight;
        this.lastY = topLeftBlock.method_10264();
        List<Future<?>> list = this.futures;
        synchronized (list) {
            this.queueFutures.add(this.queueChunksService.submit(() -> this.queueRangeWrapper(topLeftBlock, bottomRightBlock)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueRangeWrapper(class_2338 topLeftBlock, class_2338 bottomRightBlock) {
        this.queueIsRunning = true;
        this.shouldEarlyAbortQueuing = false;
        try {
            this.queueRangeReal(topLeftBlock, bottomRightBlock);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.queueIsRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueRangeReal(class_2338 topLeftBlock, class_2338 bottomRightBlock) {
        class_1923 shifted;
        int numChunks;
        int sectionSizeExponent;
        Object queuedChunks;
        Instant start = Instant.now();
        class_1923 topLeft = new class_1923(topLeftBlock);
        class_1923 bottomRight = new class_1923(bottomRightBlock);
        List<Object> list = this.currentBatches;
        synchronized (list) {
            this.currentBatches.forEach(WorkBatch::cancel);
            this.currentBatches.clear();
        }
        list = this.futures;
        synchronized (list) {
            for (Future<?> f : this.futures) {
                try {
                    f.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            this.futures.clear();
        }
        List<class_1923> chunks = class_1923.method_19281((class_1923)topLeft, (class_1923)bottomRight).toList();
        int units = 0;
        units += this.queueForLevel(chunks, topLeftBlock.method_10264(), 4096, this::workUnitFactory);
        if (this.config.sampleStructures && !this.shouldEarlyAbortQueuing) {
            units += this.queueForLevel(chunks, 0, 256, (pos, y) -> new StructStartWorkUnit(this.sampleUtils, (class_1923)pos, this.previewData));
        }
        if (this.config.sampleHeightmap && !this.shouldEarlyAbortQueuing && this.sampleUtils.noiseGeneratorSettings() != null) {
            queuedChunks = new LongOpenHashSet(chunks.size());
            ArrayList<class_1923> heightMapChunks = new ArrayList<class_1923>(chunks.size());
            sectionSizeExponent = 4;
            numChunks = 16;
            for (class_1923 c : chunks) {
                shifted = new class_1923(c.field_9181 >> 4 << 4, c.field_9180 >> 4 << 4);
                if (!queuedChunks.add(shifted.method_8324())) continue;
                heightMapChunks.add(shifted);
            }
            units += this.queueForLevel(heightMapChunks, 0, 1, (pos, y) -> new HeightmapWorkUnit(this.chunkSampler, this.sampleUtils, (class_1923)pos, 16, this.previewData));
        } else if (this.config.sampleHeightmap && !this.shouldEarlyAbortQueuing) {
            units += this.queueForLevel(chunks, 0, 64, (pos, y) -> new SlowHeightmapWorkUnit(this.chunkSampler, this.sampleUtils, (class_1923)pos, this.previewData));
        }
        if (this.config.sampleIntersections && !this.shouldEarlyAbortQueuing && this.sampleUtils.noiseGeneratorSettings() != null) {
            queuedChunks = new LongOpenHashSet(chunks.size());
            ArrayList<class_1923> intersectChunks = new ArrayList<class_1923>(chunks.size());
            sectionSizeExponent = 4;
            numChunks = 16;
            for (class_1923 c : chunks) {
                shifted = new class_1923(c.field_9181 >> 4 << 4, c.field_9180 >> 4 << 4);
                if (!queuedChunks.add(shifted.method_8324())) continue;
                intersectChunks.add(shifted);
            }
            units += this.queueForLevel(intersectChunks, 0, 1, (pos, y) -> new IntersectionWorkUnit(this.chunkSampler, this.sampleUtils, (class_1923)pos, 16, this.previewData, 8));
        } else if (this.config.sampleIntersections && !this.shouldEarlyAbortQueuing) {
            units += this.queueForLevel(chunks, 0, 64, (pos, y) -> new SlowIntersectionWorkUnit(this.chunkSampler, this.sampleUtils, (class_1923)pos, this.previewData, this.yMin(), this.yMax(), 8));
        }
        if (this.config.backgroundSampleVertChunk && !this.config.buildFullVertChunk) {
            queuedChunks = this.genAdjacentYLevels(topLeftBlock.method_10264()).iterator();
            while (queuedChunks.hasNext()) {
                int y2 = (Integer)queuedChunks.next();
                if (this.shouldEarlyAbortQueuing) break;
                units += this.queueForLevel(chunks, y2, 4096, this::workUnitFactory);
            }
        }
        Instant end = Instant.now();
        WorldPreview.LOGGER.info("Queued {} chunks for generation using {} batches [{} ms] {}", new Object[]{units, this.currentBatches.size(), Duration.between(start, end).abs().toMillis(), this.shouldEarlyAbortQueuing ? "{early abort}" : ""});
    }

    private WorkUnit workUnitFactory(class_1923 pos, int y) {
        if (this.config.buildFullVertChunk) {
            return new FullChunkWorkUnit(this.chunkSampler, pos, this.sampleUtils, this.previewData, this.yMin(), this.yMax(), 8);
        }
        return new LayerChunkWorkUnit(this.chunkSampler, pos, this.sampleUtils, this.previewData, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int queueForLevel(List<class_1923> chunks, int y, int maxBatchSize, BiFunction<class_1923, Integer, WorkUnit> workUnitFactoryFunc) {
        WorkUnit[] toQueue = new WorkUnit[chunks.size()];
        int size = 0;
        Object object = this.completedSynchro;
        synchronized (object) {
            for (class_1923 chunkPos : chunks) {
                WorkUnit workUnit = workUnitFactoryFunc.apply(chunkPos, y);
                if (workUnit.isCompleted()) continue;
                toQueue[size++] = workUnit;
            }
        }
        if (size == 0) {
            return 0;
        }
        for (int i = size - 1; i > 1; --i) {
            int randomIndexToSwap = this.random.nextInt(size);
            WorkUnit temp = toQueue[randomIndexToSwap];
            toQueue[randomIndexToSwap] = toQueue[i];
            toQueue[i] = temp;
        }
        int batchSize = maxBatchSize == 1 ? 1 : Math.max(8, Math.min(maxBatchSize, size / 4096));
        WorkBatch[] batches = new WorkBatch[batchSize == 1 ? size : size / batchSize + 1];
        if (batchSize > 1) {
            int batchIdx = 0;
            batches[batchIdx] = new WorkBatch(new ArrayList<WorkUnit>(batchSize), this.completedSynchro, this.previewData);
            for (int i = 0; i < size; ++i) {
                batches[batchIdx].workUnits.add(toQueue[i]);
                if (batches[batchIdx].workUnits.size() < batchSize) continue;
                batches[++batchIdx] = new WorkBatch(new ArrayList<WorkUnit>(batchSize), this.completedSynchro, this.previewData);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                batches[i] = new WorkBatch(List.of(toQueue[i]), this.completedSynchro, this.previewData);
            }
        }
        List<Object> list = this.futures;
        synchronized (list) {
            for (WorkBatch batch : batches) {
                this.futures.add(this.executorService.submit(batch::process));
            }
        }
        list = this.currentBatches;
        synchronized (list) {
            this.currentBatches.addAll(Arrays.asList(batches));
        }
        return size;
    }

    private List<Integer> genAdjacentYLevels(int y) {
        int yMin = this.yMin();
        int yMax = this.yMax();
        ArrayList<Integer> res = new ArrayList<Integer>();
        int max = this.dimensionType.comp_652() / 8 + 1;
        for (int i = 1; i <= max; ++i) {
            int y1 = y + i * 8;
            int y2 = y - i * 8;
            if (y2 >= yMin) {
                res.add(y2);
            }
            if (y1 <= yMax) {
                res.add(y1);
            }
            if (y1 > yMax && y2 < yMin) break;
        }
        return res;
    }

    public int yMin() {
        return this.dimensionType == null ? 0 : this.dimensionType.comp_651();
    }

    public int yMax() {
        return this.yMin() + (this.dimensionType == null ? 256 : this.dimensionType.comp_652());
    }

    public PreviewStorage previewStorage() {
        return this.previewStorage;
    }

    public boolean isSetup() {
        return this.executorService != null;
    }

    public WorldPreviewConfig config() {
        return this.config;
    }

    public class_3300 sampleResourceManager() {
        return this.sampleUtils.resourceManager();
    }

    public SampleUtils sampleUtils() {
        return this.sampleUtils;
    }
}

