/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview;

import caeruleusTait.world.preview.RenderSettings;
import caeruleusTait.world.preview.WorldPreviewConfig;
import caeruleusTait.world.preview.backend.WorkManager;
import caeruleusTait.world.preview.backend.color.PreviewMappingData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldPreview
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"world_preview");
    private static WorldPreview INSTANCE;
    private Path configDir;
    private Path configFile;
    private Path renderConfigFile;
    private Path missingColorsFile;
    private Path missingStructuresFile;
    private Path userColorConfigFile;
    private Gson gson;
    private WorldPreviewConfig cfg;
    private WorkManager workManager;
    private PreviewMappingData previewMappingData;
    private RenderSettings renderSettings;

    public static WorldPreview get() {
        return INSTANCE;
    }

    public void onInitialize() {
        INSTANCE = this;
        this.gson = new GsonBuilder().serializeNulls().setPrettyPrinting().create();
        this.configDir = FabricLoader.getInstance().getConfigDir().resolve("world_preview");
        if (!Files.exists(this.configDir, new LinkOption[0])) {
            this.configDir.toFile().mkdirs();
        }
        this.configFile = this.configDir.resolve("config.json");
        this.renderConfigFile = this.configDir.resolve("renderConfig.json");
        this.missingColorsFile = this.configDir.resolve("missing-colors.json");
        this.missingStructuresFile = this.configDir.resolve("missing-structures.json");
        this.userColorConfigFile = this.configDir.resolve("biome-colors.json");
        this.loadConfig();
        this.workManager = new WorkManager(this.renderSettings, this.cfg);
        this.previewMappingData = new PreviewMappingData();
    }

    public Executor serverThreadPoolExecutor() {
        return null;
    }

    public void loaderSpecificSetup(MinecraftServer minecraftServer) {
    }

    public void loaderSpecificTeardown(MinecraftServer minecraftServer) {
    }

    public WorldPreviewConfig cfg() {
        return this.cfg;
    }

    public WorkManager workManager() {
        return this.workManager;
    }

    public PreviewMappingData biomeColorMap() {
        return this.previewMappingData;
    }

    public RenderSettings renderSettings() {
        return this.renderSettings;
    }

    public Path userColorConfigFile() {
        return this.userColorConfigFile;
    }

    public Path configDir() {
        return this.configDir;
    }

    public void loadConfig() {
        LOGGER.info("Loading config file: {}", (Object)this.configFile);
        try {
            this.cfg = !Files.exists(this.configFile, new LinkOption[0]) ? new WorldPreviewConfig() : (WorldPreviewConfig)this.gson.fromJson(Files.readString(this.configFile), WorldPreviewConfig.class);
            this.renderSettings = !Files.exists(this.renderConfigFile, new LinkOption[0]) ? new RenderSettings() : (RenderSettings)this.gson.fromJson(Files.readString(this.renderConfigFile), RenderSettings.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void saveConfig() {
        LOGGER.info("Saving config file: {}", (Object)this.configFile);
        try {
            Files.writeString(this.configFile, (CharSequence)(this.gson.toJson((Object)this.cfg) + "\n"), new OpenOption[0]);
            Files.writeString(this.renderConfigFile, (CharSequence)(this.gson.toJson((Object)this.renderSettings) + "\n"), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeMissingColors(List<String> missing) {
        try {
            Files.deleteIfExists(this.missingColorsFile);
            if (missing.isEmpty()) {
                return;
            }
            LOGGER.warn("No color mapping for {} biomes found. The list of biomes without a color mapping can be found in {}", (Object)missing.size(), (Object)this.missingColorsFile);
            String raw = this.gson.toJson(missing);
            Files.writeString(this.missingColorsFile, (CharSequence)(raw + "\n"), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeMissingStructures(List<String> missing) {
        try {
            Files.deleteIfExists(this.missingStructuresFile);
            if (missing.isEmpty()) {
                return;
            }
            LOGGER.warn("No structure data for {} structure found. The list of structures without data can be found in {}", (Object)missing.size(), (Object)this.missingStructuresFile);
            String raw = this.gson.toJson(missing);
            Files.writeString(this.missingStructuresFile, (CharSequence)(raw + "\n"), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeUserColorConfig(Map<class_2960, PreviewMappingData.ColorEntry> userColorConfig) {
        record Entry(int r, int g, int b, boolean cave) {
        }
        Map<String, Entry> writeData = userColorConfig.entrySet().stream().collect(Collectors.toMap(x -> ((class_2960)x.getKey()).toString(), x -> {
            PreviewMappingData.ColorEntry raw = (PreviewMappingData.ColorEntry)x.getValue();
            int r = raw.color >> 16 & 0xFF;
            int g = raw.color >> 8 & 0xFF;
            int b = raw.color & 0xFF;
            return new Entry(r, g, b, raw.cave.orElseThrow());
        }));
        String raw = this.gson.toJson(writeData);
        try {
            Files.writeString(this.userColorConfigFile, (CharSequence)(raw + "\n"), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int nativeColor(int orig) {
        return orig | 0xFF000000;
    }
}

