/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview;

import caeruleusTait.world.preview.WorldPreview;
import caeruleusTait.world.preview.backend.sampler.ChunkSampler;
import caeruleusTait.world.preview.backend.sampler.FullQuartSampler;
import caeruleusTait.world.preview.backend.sampler.QuarterQuartSampler;
import caeruleusTait.world.preview.backend.sampler.SingleQuartSampler;
import java.util.function.IntFunction;
import net.minecraft.class_2338;
import net.minecraft.class_2960;

public class RenderSettings {
    private class_2338 center = new class_2338(0, 0, 0);
    private int quartExpand = 1;
    private int quartStride = 1;
    public SamplerType samplerType = SamplerType.AUTO;
    public class_2960 dimension = null;
    public boolean hideAllStructures = false;
    public transient boolean showHeightMap = false;
    public transient boolean showIntersections = false;

    public class_2338 center() {
        return this.center;
    }

    public void setCenter(class_2338 center) {
        this.center = center;
    }

    public void resetCenter() {
        this.center = new class_2338(0, WorldPreview.get().workManager().yMax(), 0);
    }

    public void incrementY() {
        int nextY = Math.min(this.center.method_10264() + 8, WorldPreview.get().workManager().yMax()) / 8 * 8;
        this.center = new class_2338(this.center.method_10263(), nextY, this.center.method_10260());
    }

    public void decrementY() {
        int nextY = Math.max(this.center.method_10264() - 8, WorldPreview.get().workManager().yMin()) / 8 * 8;
        this.center = new class_2338(this.center.method_10263(), nextY, this.center.method_10260());
    }

    public int quartExpand() {
        return this.quartExpand;
    }

    public int quartStride() {
        return this.quartStride;
    }

    public int pixelsPerChunk() {
        return 4 * this.quartExpand / this.quartStride;
    }

    public void setPixelsPerChunk(int blocksPerChunk) {
        switch (blocksPerChunk) {
            case 16: {
                this.quartExpand = 4;
                this.quartStride = 1;
                break;
            }
            case 8: {
                this.quartExpand = 2;
                this.quartStride = 1;
                break;
            }
            case 4: {
                this.quartExpand = 1;
                this.quartStride = 1;
                break;
            }
            case 2: {
                this.quartExpand = 1;
                this.quartStride = 2;
                break;
            }
            case 1: {
                this.quartExpand = 1;
                this.quartStride = 4;
                break;
            }
            default: {
                throw new RuntimeException("Invalid blocksPerChunk=" + blocksPerChunk);
            }
        }
    }

    public static enum SamplerType {
        AUTO(x -> switch (x) {
            case 1 -> new FullQuartSampler();
            case 2 -> new QuarterQuartSampler();
            case 4 -> new SingleQuartSampler();
            default -> throw new RuntimeException("Unsupported quart stride: " + x);
        }),
        FULL(x -> new FullQuartSampler()),
        QUARTER(x -> new QuarterQuartSampler()),
        SINGLE(x -> new SingleQuartSampler());

        private final IntFunction<ChunkSampler> samplerFactory;

        private SamplerType(IntFunction<ChunkSampler> samplerFactory) {
            this.samplerFactory = samplerFactory;
        }

        public ChunkSampler create(int quartStride) {
            return this.samplerFactory.apply(quartStride);
        }
    }
}

