/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.noise.samplers.noise.simplex;

import com.dfsek.terra.addons.noise.samplers.noise.simplex.SimplexStyleSampler;

public class SimplexSampler
extends SimplexStyleSampler {
    private static final Double2[] GRAD_2D = new Double2[]{new Double2(-1.0, -1.0), new Double2(1.0, -1.0), new Double2(-1.0, 1.0), new Double2(1.0, 1.0), new Double2(0.0, -1.0), new Double2(-1.0, 0.0), new Double2(0.0, 1.0), new Double2(1.0, 0.0)};
    private static final Double3[] GRAD_3D = new Double3[]{new Double3(1.0, 1.0, 0.0), new Double3(-1.0, 1.0, 0.0), new Double3(1.0, -1.0, 0.0), new Double3(-1.0, -1.0, 0.0), new Double3(1.0, 0.0, 1.0), new Double3(-1.0, 0.0, 1.0), new Double3(1.0, 0.0, -1.0), new Double3(-1.0, 0.0, -1.0), new Double3(0.0, 1.0, 1.0), new Double3(0.0, -1.0, 1.0), new Double3(0.0, 1.0, -1.0), new Double3(0.0, -1.0, -1.0), new Double3(1.0, 1.0, 0.0), new Double3(0.0, -1.0, 1.0), new Double3(-1.0, 1.0, 0.0), new Double3(0.0, -1.0, -1.0)};
    private static final double F2 = 0.5;
    private static final double F3 = 0.3333333333333333;
    private static final double G2 = 0.25;
    private static final double G3 = 0.16666666666666666;
    private static final double G33 = -0.5;
    private static final int X_PRIME = 1619;
    private static final int Y_PRIME = 31337;
    private static final int Z_PRIME = 6971;

    private static double gradCoord3D(int seed, int x, int y, int z, double xd, double yd, double zd) {
        int hash = seed;
        hash ^= 1619 * x;
        hash ^= 31337 * y;
        hash ^= 6971 * z;
        hash = hash * hash * hash * 60493;
        hash = hash >> 13 ^ hash;
        Double3 g = GRAD_3D[hash & 0xF];
        return xd * g.x + yd * g.y + zd * g.z;
    }

    private static double gradCoord2D(int seed, int x, int y, double xd, double yd) {
        int hash = seed;
        hash ^= 1619 * x;
        hash ^= 31337 * y;
        hash = hash * hash * hash * 60493;
        hash = hash >> 13 ^ hash;
        Double2 g = GRAD_2D[hash & 7];
        return xd * g.x + yd * g.y;
    }

    @Override
    public double getNoiseRaw(long sl, double x, double y) {
        double n2;
        double n1;
        double n0;
        int j1;
        int i1;
        double Y0;
        double y0;
        int j;
        int seed = (int)sl;
        double t = (x + y) * 0.5;
        int i = SimplexSampler.fastFloor(x + t);
        double X0 = (double)i - (t = (double)(i + (j = SimplexSampler.fastFloor(y + t))) * 0.25);
        double x0 = x - X0;
        if (x0 > (y0 = y - (Y0 = (double)j - t))) {
            i1 = 1;
            j1 = 0;
        } else {
            i1 = 0;
            j1 = 1;
        }
        double x1 = x0 - (double)i1 + 0.25;
        double y1 = y0 - (double)j1 + 0.25;
        double x2 = x0 - 1.0 + 0.5;
        double y2 = y0 - 1.0 + 0.5;
        t = 0.5 - x0 * x0 - y0 * y0;
        if (t < 0.0) {
            n0 = 0.0;
        } else {
            t *= t;
            n0 = t * t * SimplexSampler.gradCoord2D(seed, i, j, x0, y0);
        }
        t = 0.5 - x1 * x1 - y1 * y1;
        if (t < 0.0) {
            n1 = 0.0;
        } else {
            t *= t;
            n1 = t * t * SimplexSampler.gradCoord2D(seed, i + i1, j + j1, x1, y1);
        }
        t = 0.5 - x2 * x2 - y2 * y2;
        if (t < 0.0) {
            n2 = 0.0;
        } else {
            t *= t;
            n2 = t * t * SimplexSampler.gradCoord2D(seed, i + 1, j + 1, x2, y2);
        }
        return 50.0 * (n0 + n1 + n2);
    }

    @Override
    public double getNoiseRaw(long sl, double x, double y, double z) {
        double n3;
        double n2;
        double n1;
        double n0;
        int k2;
        int j2;
        int i2;
        int k1;
        int j1;
        int i1;
        int seed = (int)sl;
        double t = (x + y + z) * 0.3333333333333333;
        int i = SimplexSampler.fastFloor(x + t);
        int j = SimplexSampler.fastFloor(y + t);
        int k = SimplexSampler.fastFloor(z + t);
        t = (double)(i + j + k) * 0.16666666666666666;
        double x0 = x - ((double)i - t);
        double y0 = y - ((double)j - t);
        double z0 = z - ((double)k - t);
        if (x0 >= y0) {
            if (y0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 1;
                k2 = 0;
            } else if (x0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            } else {
                i1 = 0;
                j1 = 0;
                k1 = 1;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            }
        } else if (y0 < z0) {
            i1 = 0;
            j1 = 0;
            k1 = 1;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else if (x0 < z0) {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 1;
            j2 = 1;
            k2 = 0;
        }
        double x1 = x0 - (double)i1 + 0.16666666666666666;
        double y1 = y0 - (double)j1 + 0.16666666666666666;
        double z1 = z0 - (double)k1 + 0.16666666666666666;
        double x2 = x0 - (double)i2 + 0.3333333333333333;
        double y2 = y0 - (double)j2 + 0.3333333333333333;
        double z2 = z0 - (double)k2 + 0.3333333333333333;
        double x3 = x0 + -0.5;
        double y3 = y0 + -0.5;
        double z3 = z0 + -0.5;
        t = 0.6 - x0 * x0 - y0 * y0 - z0 * z0;
        if (t < 0.0) {
            n0 = 0.0;
        } else {
            t *= t;
            n0 = t * t * SimplexSampler.gradCoord3D(seed, i, j, k, x0, y0, z0);
        }
        t = 0.6 - x1 * x1 - y1 * y1 - z1 * z1;
        if (t < 0.0) {
            n1 = 0.0;
        } else {
            t *= t;
            n1 = t * t * SimplexSampler.gradCoord3D(seed, i + i1, j + j1, k + k1, x1, y1, z1);
        }
        t = 0.6 - x2 * x2 - y2 * y2 - z2 * z2;
        if (t < 0.0) {
            n2 = 0.0;
        } else {
            t *= t;
            n2 = t * t * SimplexSampler.gradCoord3D(seed, i + i2, j + j2, k + k2, x2, y2, z2);
        }
        t = 0.6 - x3 * x3 - y3 * y3 - z3 * z3;
        if (t < 0.0) {
            n3 = 0.0;
        } else {
            t *= t;
            n3 = t * t * SimplexSampler.gradCoord3D(seed, i + 1, j + 1, k + 1, x3, y3, z3);
        }
        return 32.0 * (n0 + n1 + n2 + n3);
    }

    private static class Double3 {
        public final double x;
        public final double y;
        public final double z;

        public Double3(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    private static class Double2 {
        public final double x;
        public final double y;

        public Double2(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

