/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.noise.lib.paralithic.functions.natives;

import com.dfsek.terra.addons.noise.lib.paralithic.functions.natives.NativeFunction;

public class NativeMath {
    private static final Class<?> MATH = Math.class;
    public static NativeFunction POW = () -> MATH.getMethod("pow", Double.TYPE, Double.TYPE);
    public static NativeFunction MAX = () -> NativeMath.class.getMethod("fastMax", Double.TYPE, Double.TYPE);
    public static NativeFunction MIN = () -> NativeMath.class.getMethod("fastMin", Double.TYPE, Double.TYPE);
    public static NativeFunction SIN = () -> MATH.getMethod("sin", Double.TYPE);
    public static NativeFunction COS = () -> MATH.getMethod("cos", Double.TYPE);
    public static NativeFunction TAN = () -> MATH.getMethod("tan", Double.TYPE);
    public static NativeFunction ROUND = () -> MATH.getMethod("round", Double.TYPE);
    public static NativeFunction FLOOR = () -> NativeMath.class.getMethod("fastFloor", Double.TYPE);
    public static NativeFunction CEIL = () -> NativeMath.class.getMethod("fastCeil", Double.TYPE);
    public static NativeFunction SQRT = () -> MATH.getMethod("sqrt", Double.TYPE);
    public static NativeFunction SINH = () -> MATH.getMethod("sinh", Double.TYPE);
    public static NativeFunction COSH = () -> MATH.getMethod("cosh", Double.TYPE);
    public static NativeFunction TANH = () -> MATH.getMethod("tanh", Double.TYPE);
    public static NativeFunction ASIN = () -> MATH.getMethod("asin", Double.TYPE);
    public static NativeFunction ACOS = () -> MATH.getMethod("acos", Double.TYPE);
    public static NativeFunction ATAN = () -> MATH.getMethod("atan", Double.TYPE);
    public static NativeFunction ATAN2 = () -> MATH.getMethod("atan2", Double.TYPE, Double.TYPE);
    public static NativeFunction DEG = () -> MATH.getMethod("toDegrees", Double.TYPE);
    public static NativeFunction RAD = () -> MATH.getMethod("toRadians", Double.TYPE);
    public static NativeFunction ABS = () -> NativeMath.class.getMethod("fastAbs", Double.TYPE);
    public static NativeFunction LOG = () -> MATH.getMethod("log10", Double.TYPE);
    public static NativeFunction LN = () -> MATH.getMethod("log", Double.TYPE);
    public static NativeFunction EXP = () -> MATH.getMethod("exp", Double.TYPE);
    public static NativeFunction SIGN = () -> MATH.getMethod("signum", Double.TYPE);
    public static NativeFunction SIGMOID = () -> NativeMath.class.getMethod("sigmoid", Double.TYPE, Double.TYPE);
    public static NativeFunction POW2 = () -> NativeMath.class.getMethod("pow2", Double.TYPE);
    public static NativeFunction INT_POW = () -> NativeMath.class.getMethod("intPow", Double.TYPE, Double.TYPE);

    public static double pow2(double a) {
        return a * a;
    }

    public static double sigmoid(double a, double b) {
        return 1.0 / Math.exp(-1.0 * a * b);
    }

    public static double fastMin(double a, double b) {
        return a < b ? a : b;
    }

    public static double fastMax(double a, double b) {
        return a > b ? a : b;
    }

    public static double fastAbs(double f) {
        return f < 0.0 ? -f : f;
    }

    public static double fastCeil(double f) {
        long i = (long)f;
        if ((double)i < f) {
            ++i;
        }
        return i;
    }

    public static double fastFloor(double f) {
        return f >= 0.0 ? (double)((long)f) : (double)((long)f - 1L);
    }

    public static double intPow(double x, double yd) {
        long y = (long)yd;
        double result = 1.0;
        while (y > 0L) {
            if ((y & 1L) == 0L) {
                x *= x;
                y >>>= 1;
                continue;
            }
            result *= x;
            --y;
        }
        return result;
    }
}

