/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.noise.config.templates.noise;

import com.dfsek.tectonic.api.config.template.annotations.Default;
import com.dfsek.tectonic.api.config.template.annotations.Value;
import com.dfsek.terra.addons.noise.config.DimensionApplicableNoiseSampler;
import com.dfsek.terra.addons.noise.config.templates.FunctionTemplate;
import com.dfsek.terra.addons.noise.config.templates.SamplerTemplate;
import com.dfsek.terra.addons.noise.lib.paralithic.eval.tokenizer.ParseException;
import com.dfsek.terra.addons.noise.lib.paralithic.functions.Function;
import com.dfsek.terra.addons.noise.paralithic.defined.UserDefinedFunction;
import com.dfsek.terra.addons.noise.paralithic.noise.NoiseFunction2;
import com.dfsek.terra.addons.noise.paralithic.noise.NoiseFunction3;
import com.dfsek.terra.addons.noise.samplers.noise.ExpressionFunction;
import com.dfsek.terra.api.config.meta.Meta;
import com.dfsek.terra.api.noise.NoiseSampler;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExpressionFunctionTemplate
extends SamplerTemplate<ExpressionFunction> {
    private final Map<String, DimensionApplicableNoiseSampler> otherFunctions;
    private final Map<String, FunctionTemplate> globalFunctions;
    @Value(value="variables")
    @Default
    private @Meta Map<String, @Meta Double> vars = new HashMap<String, Double>();
    @Value(value="expression")
    private @Meta String expression;
    @Value(value="samplers")
    @Default
    private @Meta LinkedHashMap<String, @Meta DimensionApplicableNoiseSampler> samplers = new LinkedHashMap();
    @Value(value="functions")
    @Default
    private @Meta LinkedHashMap<String, @Meta FunctionTemplate> functions = new LinkedHashMap();

    public ExpressionFunctionTemplate(Map<String, DimensionApplicableNoiseSampler> otherFunctions, Map<String, FunctionTemplate> samplers) {
        this.otherFunctions = otherFunctions;
        this.globalFunctions = samplers;
    }

    public NoiseSampler get() {
        try {
            Map<String, Function> noiseFunctionMap = this.generateFunctions();
            return new ExpressionFunction(noiseFunctionMap, this.expression, this.vars);
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to parse expression.", e);
        }
    }

    private Map<String, Function> generateFunctions() throws ParseException {
        HashMap<String, Function> noiseFunctionMap = new HashMap<String, Function>();
        for (Map.Entry<String, FunctionTemplate> entry : this.globalFunctions.entrySet()) {
            noiseFunctionMap.put(entry.getKey(), UserDefinedFunction.newInstance(entry.getValue()));
        }
        for (Map.Entry<String, FunctionTemplate> entry : this.functions.entrySet()) {
            noiseFunctionMap.put(entry.getKey(), UserDefinedFunction.newInstance(entry.getValue()));
        }
        this.otherFunctions.forEach((id, function) -> {
            if (function.getDimensions() == 2) {
                noiseFunctionMap.put((String)id, new NoiseFunction2(function.getSampler()));
            } else {
                noiseFunctionMap.put((String)id, new NoiseFunction3(function.getSampler()));
            }
        });
        this.samplers.forEach((id, function) -> {
            if (function.getDimensions() == 2) {
                noiseFunctionMap.put((String)id, new NoiseFunction2(function.getSampler()));
            } else {
                noiseFunctionMap.put((String)id, new NoiseFunction3(function.getSampler()));
            }
        });
        return noiseFunctionMap;
    }
}

