/*
 * Decompiled with CFR 0.152.
 */
package traben.tconfig.gui.entries;

import com.demonwav.mcdev.annotations.Translatable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_357;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.tconfig.gui.entries.TConfigEntryNullSafe;

public class TConfigEntryEnumSlider<E extends Enum<E>>
extends TConfigEntryNullSafe<E> {
    private final EnumSliderWidget<E> widget;
    private boolean appendNullValue = false;

    public TConfigEntryEnumSlider(@Translatable String text, @Translatable String tooltip, Supplier<E> getter, Consumer<E> setter, E defaultValue, Class<E> enumClass) {
        super(text, tooltip, getter, setter, defaultValue);
        if (defaultValue == null) {
            this.appendNullValue = true;
        }
        this.widget = new EnumSliderWidget(this, this.getText(), (Enum)getter.get(), this.getTooltip(), enumClass);
    }

    public TConfigEntryEnumSlider(@Translatable String text, @Translatable String tooltip, Supplier<E> getter, Consumer<E> setter, @NotNull E defaultValue) {
        this(text, tooltip, getter, setter, defaultValue, ((Enum)defaultValue).getDeclaringClass());
    }

    public TConfigEntryEnumSlider(@Translatable String text, Supplier<E> getter, Consumer<E> setter, @NotNull E defaultValue) {
        this(text, null, getter, setter, defaultValue, ((Enum)defaultValue).getDeclaringClass());
    }

    public TConfigEntryEnumSlider(@Translatable String text, Supplier<E> getter, Consumer<E> setter, E defaultValue, Class<E> enumClass) {
        this(text, null, getter, setter, defaultValue, enumClass);
    }

    @Override
    public TConfigEntryNullSafe<E> allowNullValue() {
        this.appendNullValue = true;
        return this;
    }

    @Override
    protected E getValueFromWidget() {
        return this.widget.getValue();
    }

    @Override
    public class_339 getWidget(int x, int y, int width, int height) {
        this.widget.method_46421(x);
        this.widget.method_46419(y);
        this.widget.method_25358(width);
        this.widget.field_22759 = height;
        return this.widget;
    }

    @Override
    void setWidgetToDefaultValue() {
        this.widget.setValue((Enum)this.defaultValue);
    }

    @Override
    void resetWidgetToInitialValue() {
        this.widget.setValue((Enum)this.getter.get());
    }

    public static class EnumSliderWidget<T extends Enum<?>>
    extends class_357 {
        private final T[] enumValues;
        private final String title;
        final /* synthetic */ TConfigEntryEnumSlider this$0;

        public EnumSliderWidget(class_2561 text, T initialValue, class_7919 tooltip, Class<T> enumClass) {
            this.this$0 = this$0;
            super(0, 0, 20, 20, text, 1.0);
            this.enumValues = (Enum[])enumClass.getEnumConstants();
            this.title = text.getString() + ": ";
            this.method_47400(tooltip);
            this.setValue(initialValue);
        }

        @Nullable
        private T getValue() {
            if (this.getIndex() >= this.enumValues.length) {
                return null;
            }
            return this.enumValues[this.getIndex()];
        }

        private void setValue(T value) {
            this.field_22753 = value == null ? 1.0 : (double)((Enum)value).ordinal() / (double)this.getChoiceCount();
            this.method_25346();
        }

        protected void method_25346() {
            this.field_22753 = (double)this.getIndex() / (double)this.getChoiceCount();
            T value2 = this.getValue();
            this.method_25355(class_2561.method_30163((String)(this.title + (value2 != this.this$0.getter.get() ? "\u00a7a" : "") + String.valueOf(value2 == null ? "---" : value2))));
        }

        protected void method_25344() {
        }

        private int getChoiceCount() {
            return this.enumValues.length - (this.this$0.appendNullValue ? 0 : 1);
        }

        private int getIndex() {
            return (int)Math.round(this.field_22753 * (double)this.getChoiceCount());
        }
    }
}

