/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.texture_handlers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1079;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3532;
import net.minecraft.class_7764;
import net.minecraft.class_7771;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFSprite {
    public final boolean isETFAltered;
    private final class_1058 sprite;
    private final class_1058 emissiveSprite;

    public ETFSprite(@NotNull class_1058 originalSprite, @NotNull ETFTexture etfTexture) {
        Optional resource;
        class_2960 emissiveId;
        class_7764 contents;
        if (etfTexture.getVariantNumber() != 0) {
            class_2960 variantId = etfTexture.getTextureIdentifier(null);
            Optional resource2 = class_310.method_1551().method_1478().method_14486(variantId);
            if (resource2.isPresent()) {
                class_1058 possibleVariant = null;
                contents = ETFSprite.load(ETFUtils2.res(String.valueOf(variantId) + "-etf_sprite"), (class_3298)resource2.get());
                try {
                    if (contents != null) {
                        possibleVariant = new class_1058(variantId, contents, contents.method_45807(), contents.method_45815(), 0, 0);
                    }
                }
                finally {
                    if (contents != null) {
                        contents.close();
                    }
                }
                this.sprite = Objects.requireNonNullElse(possibleVariant, originalSprite);
            } else {
                this.sprite = originalSprite;
            }
        } else {
            this.sprite = originalSprite;
        }
        this.isETFAltered = !this.sprite.equals(originalSprite);
        class_1058 possibleEmissive = null;
        if (etfTexture.eSuffix != null && (emissiveId = etfTexture.getEmissiveIdentifierOfCurrentState()) != null && (resource = class_310.method_1551().method_1478().method_14486(emissiveId)).isPresent()) {
            contents = ETFSprite.load(ETFUtils2.res(String.valueOf(emissiveId) + "-etf_sprite"), (class_3298)resource.get());
            try {
                if (contents != null) {
                    possibleEmissive = new class_1058(emissiveId, contents, contents.method_45807(), contents.method_45815(), 0, 0);
                }
            }
            finally {
                if (contents != null) {
                    contents.close();
                }
            }
        }
        this.emissiveSprite = possibleEmissive;
    }

    @Nullable
    public static class_7764 load(class_2960 id, class_3298 resource) {
        class_1011 nativeImage;
        class_1079 animationResourceMetadata;
        try {
            animationResourceMetadata = resource.method_14481().method_43041((class_3270)class_1079.field_5337).orElse(class_1079.field_21768);
        }
        catch (Exception var8) {
            return null;
        }
        try (InputStream inputStream = resource.method_14482();){
            nativeImage = class_1011.method_4309((InputStream)inputStream);
        }
        catch (IOException var10) {
            return null;
        }
        class_7771 spriteDimensions = new class_7771(nativeImage.method_4307(), nativeImage.method_4323());
        if (class_3532.method_48117((int)nativeImage.method_4307(), (int)spriteDimensions.comp_1049()) && class_3532.method_48117((int)nativeImage.method_4323(), (int)spriteDimensions.comp_1050())) {
            return new class_7764(id, spriteDimensions, nativeImage, animationResourceMetadata);
        }
        nativeImage.close();
        return null;
    }

    @NotNull
    public class_1058 getEmissive() {
        return this.emissiveSprite;
    }

    public boolean isEmissive() {
        return this.emissiveSprite != null;
    }

    @NotNull
    public class_1058 getSpriteVariant() {
        return this.sprite;
    }
}

