/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.telepistons;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Random;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.model.BakedModelManagerHelper;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Telepistons
implements ModInitializer {
    public static class_2960 pistonArmModel;
    public static class_1087 pistonArmBakedModel;
    public static Random random;
    public static boolean emitSteam;
    public static boolean steamOverride;
    public static int particleCount;
    public static boolean squishArm;
    public static Vector3f squishFactorsX;
    public static Vector3f squishFactorsY;
    public static Vector3f squishFactorsZ;
    private static final float HALF_TURN = (float)Math.PI;
    private static final float QUART_TURN = 1.5707964f;
    private static final Vector3f UP;
    private static final Vector3f FORWARD;
    private static final Vector3f RIGHT;

    public void onInitialize() {
        class_2960 scissorPack = new class_2960("telepistons", "scissor_pistons");
        class_2960 bellowsPack = new class_2960("telepistons", "bellows_pistons");
        class_2960 stickySidesPack = new class_2960("telepistons", "sticky_sides");
        class_2960 enableSteam = new class_2960("telepistons", "enable_steam");
        FabricLoader.getInstance().getModContainer("telepistons").ifPresent(container -> {
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)scissorPack, (ModContainer)container, (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)bellowsPack, (ModContainer)container, (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)stickySidesPack, (ModContainer)container, (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)enableSteam, (ModContainer)container, (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED);
        });
        pistonArmModel = new class_2960("telepistons", "block/piston_arm");
        ModelLoadingRegistry.INSTANCE.registerModelProvider((modelManager, out) -> out.accept(pistonArmModel));
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("telepistons", "models");
            }

            public void method_14491(class_3300 manager) {
                JsonObject settings;
                JsonObject json;
                BufferedReader streamReader;
                InputStream stream;
                Map resourceMap = manager.method_14488("models", path -> path.toString().endsWith("piston_arm.json"));
                for (Map.Entry entry : resourceMap.entrySet()) {
                    try {
                        stream = ((class_3298)manager.method_14486((class_2960)entry.getKey()).get()).method_14482();
                        try {
                            streamReader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                            json = class_3518.method_15255((Reader)streamReader);
                            settings = json.get("telepistons").getAsJsonObject();
                            squishArm = settings.get("squish").getAsBoolean();
                            particleCount = Math.max(settings.get("particles").getAsInt(), 0);
                            if (squishArm) {
                                JsonArray factorArr = settings.get("squishedScale").getAsJsonArray();
                                squishFactorsZ = new Vector3f(factorArr.remove(0).getAsFloat(), factorArr.remove(0).getAsFloat(), factorArr.remove(0).getAsFloat());
                                squishFactorsX = new Vector3f(squishFactorsZ.z(), squishFactorsZ.y(), squishFactorsZ.x());
                                squishFactorsY = new Vector3f(squishFactorsZ.x(), squishFactorsZ.z(), squishFactorsZ.y());
                            }
                            System.out.println("[Telepistons] Read settings successfully");
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        particleCount = 0;
                        squishArm = false;
                        System.out.println("Error:\n" + e);
                        System.out.println("[Telepistons] Error while trying to read settings, using standard values");
                    }
                }
                resourceMap = manager.method_14488("models", path -> path.toString().endsWith("piston_particle.json"));
                steamOverride = false;
                for (Map.Entry entry : resourceMap.entrySet()) {
                    try {
                        stream = ((class_3298)manager.method_14486((class_2960)entry.getKey()).get()).method_14482();
                        try {
                            streamReader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                            json = class_3518.method_15255((Reader)streamReader);
                            settings = json.get("telepistons").getAsJsonObject();
                            steamOverride = settings.get("particleOverride").getAsBoolean();
                            System.out.println("[Telepistons] Read particle setting successfully");
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        System.out.println("[Telepistons] Particle setting file erroneous");
                    }
                }
                emitSteam = steamOverride && particleCount > 0;
                pistonArmBakedModel = BakedModelManagerHelper.getModel((class_1092)class_310.method_1551().method_1554(), (class_2960)pistonArmModel);
            }
        });
    }

    public static Quaternionf getRotationQuaternion(class_2350 dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11036 -> new Quaternionf(new AxisAngle4f(1.5707964f, (Vector3fc)RIGHT));
            case class_2350.field_11033 -> new Quaternionf(new AxisAngle4f(-1.5707964f, (Vector3fc)RIGHT));
            case class_2350.field_11043 -> new Quaternionf();
            case class_2350.field_11035 -> new Quaternionf(new AxisAngle4f((float)Math.PI, (Vector3fc)UP));
            case class_2350.field_11034 -> new Quaternionf(new AxisAngle4f(-1.5707964f, (Vector3fc)UP));
            case class_2350.field_11039 -> new Quaternionf(new AxisAngle4f(1.5707964f, (Vector3fc)UP));
        };
    }

    static {
        random = new Random();
        steamOverride = true;
        UP = new Vector3f(0.0f, 1.0f, 0.0f);
        FORWARD = new Vector3f(0.0f, 0.0f, 1.0f);
        RIGHT = new Vector3f(1.0f, 0.0f, 0.0f);
    }
}

