/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.mixins;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.AsyncLocator;
import brightspark.asynclocator.platform.Services;
import net.minecraft.class_1297;
import net.minecraft.class_1433;
import net.minecraft.class_2338;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_6862;
import net.minecraft.class_7045;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(targets={"net.minecraft.world.entity.animal.Dolphin$DolphinSwimToTreasureGoal"})
public class DolphinSwimToTreasureGoalMixin {
    @Final
    @Shadow
    private class_1433 field_6752;
    @Shadow
    private boolean field_6753;
    private AsyncLocator.LocateTask<class_2338> locateTask = null;

    @Inject(method={"start"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;findNearestMapStructure(Lnet/minecraft/tags/TagKey;Lnet/minecraft/core/BlockPos;IZ)Lnet/minecraft/core/BlockPos;")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void findTreasureAsync(CallbackInfo ci, class_3218 level, class_2338 blockpos) {
        if (!Services.CONFIG.dolphinTreasureEnabled()) {
            return;
        }
        ALConstants.logDebug("Intercepted DolphinSwimToTreasureGoal#start call", new Object[0]);
        this.handleFindTreasureAsync(level, blockpos);
        ci.cancel();
    }

    @Inject(method={"canContinueToUse"}, at={@At(value="HEAD")}, cancellable=true)
    public void continueToUseIfLocatingTreasure(CallbackInfoReturnable<Boolean> cir) {
        if (this.locateTask != null) {
            ALConstants.logDebug("Locating task ongoing - returning true for continueToUse()", new Object[0]);
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"stop"}, at={@At(value="HEAD")})
    public void stopLocatingTreasure(CallbackInfo ci) {
        if (this.locateTask != null) {
            ALConstants.logDebug("Locating task ongoing - cancelling during stop()", new Object[0]);
            this.locateTask.cancel();
            this.locateTask = null;
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    public void skipTickingIfLocatingTreasure(CallbackInfo ci) {
        if (this.locateTask != null) {
            ALConstants.logDebug("Locating task ongoing - skipping tick()", new Object[0]);
            ci.cancel();
        }
    }

    private void handleFindTreasureAsync(class_3218 level, class_2338 blockPos) {
        this.locateTask = AsyncLocator.locate(level, (class_6862<class_3195>)class_7045.field_37041, blockPos, 50, false).thenOnServerThread(pos -> this.handleLocationFound(level, (class_2338)pos));
    }

    private void handleLocationFound(class_3218 level, class_2338 pos) {
        this.locateTask = null;
        if (pos != null) {
            ALConstants.logInfo("Location found - updating dolphin treasure pos", new Object[0]);
            this.field_6752.method_6493(pos);
            level.method_8421((class_1297)this.field_6752, (byte)38);
        } else {
            ALConstants.logInfo("No location found - marking dolphin as stuck", new Object[0]);
            this.field_6753 = true;
        }
    }
}

