/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.logic;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.AsyncLocator;
import brightspark.asynclocator.logic.CommonLogic;
import brightspark.asynclocator.platform.Services;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import net.minecraft.class_1799;
import net.minecraft.class_20;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_6862;

public class ExplorationMapFunctionLogic {
    private static final Cache<class_1799, class_2561> MAP_NAME_CACHE = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(5L)).build();

    private ExplorationMapFunctionLogic() {
    }

    public static void cacheName(class_1799 stack, class_2561 name) {
        MAP_NAME_CACHE.put((Object)stack, (Object)name);
    }

    public static class_2561 getCachedName(class_1799 stack) {
        class_2561 name = (class_2561)MAP_NAME_CACHE.getIfPresent((Object)stack);
        MAP_NAME_CACHE.invalidate((Object)stack);
        return name;
    }

    public static void handleLocationFound(class_1799 mapStack, class_3218 level, class_2338 pos, int scale, class_20.class_21 destinationType, class_2338 invPos) {
        if (pos == null) {
            ALConstants.logInfo("No location found - invalidating map stack", new Object[0]);
            Services.EXPLORATION_MAP_FUNCTION_LOGIC.invalidateMap(mapStack, level, invPos);
        } else {
            ALConstants.logInfo("Location found - updating treasure map in chest", new Object[0]);
            Services.EXPLORATION_MAP_FUNCTION_LOGIC.updateMap(mapStack, level, pos, scale, destinationType, invPos, ExplorationMapFunctionLogic.getCachedName(mapStack));
        }
    }

    public static class_1799 updateMapAsync(class_3218 level, class_2338 blockPos, int scale, int searchRadius, boolean skipKnownStructures, class_20.class_21 destinationType, class_6862<class_3195> destination) {
        class_1799 mapStack = CommonLogic.createEmptyMap();
        AsyncLocator.locate(level, destination, blockPos, searchRadius, skipKnownStructures).thenOnServerThread(pos -> ExplorationMapFunctionLogic.handleLocationFound(mapStack, level, pos, scale, destinationType, blockPos));
        return mapStack;
    }
}

