/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.cicada.api.conversation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import nl.enjarai.cicada.api.conversation.ConversationManager;
import nl.enjarai.cicada.api.conversation.Line;
import nl.enjarai.cicada.api.conversation.conditions.LineCondition;
import nl.enjarai.cicada.api.util.random.Weighted;
import org.jetbrains.annotations.Nullable;

public class Conversation
implements Weighted {
    private final ConversationManager conversationManager;
    private final List<LineCondition> conditions = Collections.synchronizedList(new ArrayList());
    private final List<Line> lines = Collections.synchronizedList(new ArrayList());
    private final List<String> participants = Collections.synchronizedList(new ArrayList());
    private int priority = 0;
    private int currentOverride = 0;
    private int participantCount = 0;

    public Conversation(ConversationManager conversationManager) {
        this.conversationManager = conversationManager;
    }

    public void addCondition(LineCondition condition) {
        this.conditions.add(condition);
    }

    public void addLine(Line line) {
        this.lines.add(line);
    }

    public void addParticipant(@Nullable String participant) {
        if (participant != null) {
            this.participants.add(participant);
        }
    }

    public List<String> getParticipants() {
        return this.participants;
    }

    public void addPriority(int priority, int override) {
        if (override > this.currentOverride) {
            this.priority = priority;
            this.currentOverride = override;
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public void addParticipantCount(int participantCount) {
        this.participantCount += participantCount;
    }

    public int getParticipantCount() {
        return this.participantCount;
    }

    public ConversationManager getConversationManager() {
        return this.conversationManager;
    }

    public void complete() {
        this.lines.sort(Comparator.comparingInt(Line::getOrder));
    }

    public boolean shouldRun() {
        return this.conditions.stream().allMatch(condition -> condition.test(this));
    }

    public void run() {
        this.lines.stream().filter(Line::isConditionMet).forEach(Line::run);
    }

    @Override
    public double getWeight() {
        return this.getPriority();
    }
}

