/*
 * Decompiled with CFR 0.152.
 */
package com.lion.villagersplus.platform.fabric;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lion.villagersplus.VillagersPlus;
import com.lion.villagersplus.tradeoffers.TradeOfferManager;
import com.lion.villagersplus.tradeoffers.TradeOfferRegistryLoader;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_4309;
import net.minecraft.class_7367;
import net.minecraft.class_7923;

public class TradeOfferResourceListener
extends class_4309
implements IdentifiableResourceReloadListener {
    public TradeOfferResourceListener() {
        super(new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setLenient().create(), "villager_trades");
    }

    public class_2960 getFabricId() {
        return new class_2960("villagersplus", "villager_data_loader");
    }

    protected void apply(Map<class_2960, JsonElement> loader, class_3300 manager, class_3695 profiler) {
        for (class_3262 pack : manager.method_29213().collect(Collectors.toList())) {
            try {
                for (class_3852 villager : class_7923.field_41195.method_10220().collect(Collectors.toList())) {
                    this.loadAndMergeTradeOffers(pack, villager);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadAndMergeTradeOffers(class_3262 pack, class_3852 villager) throws IOException {
        class_7367 tradeInputStreamSupplier;
        String id = villager.comp_818();
        if (id.contains(":")) {
            id = id.split(":")[1];
        }
        if ((tradeInputStreamSupplier = pack.method_14405(class_3264.field_14190, new class_2960("villagersplus", "villager_trades/" + id + ".json"))) == null || tradeInputStreamSupplier.get() == null) {
            return;
        }
        VillagersPlus.LOGGER.info("Deserializing datapack added trades of profession: villagersplus:" + villager + " from " + pack.method_14409());
        JsonObject tradeData = (JsonObject)new Gson().fromJson((Reader)new InputStreamReader((InputStream)tradeInputStreamSupplier.get()), JsonObject.class);
        TradeOfferManager.deserializeJson(tradeData);
        HashMap<class_3852, Int2ObjectOpenHashMap<class_3853.class_1652[]>> datapackTrades = TradeOfferRegistryLoader.getRegistryForLoading();
        class_3853.field_17067.forEach((profession, defaultProfessionTrades) -> {
            Int2ObjectOpenHashMap datapackProfessionTrades = datapackTrades.getOrDefault(profession, new Int2ObjectOpenHashMap());
            datapackProfessionTrades.forEach((level, datapackLevelTrades) -> {
                class_3853.class_1652[] defaultLevelTrades = (class_3853.class_1652[])defaultProfessionTrades.get(level);
                class_3853.class_1652[] mergedTrades = (class_3853.class_1652[])Stream.concat(defaultLevelTrades != null ? Arrays.stream(defaultLevelTrades) : Stream.empty(), Arrays.stream(datapackLevelTrades)).distinct().toArray(class_3853.class_1652[]::new);
                defaultProfessionTrades.put(level, (Object)mergedTrades);
            });
        });
    }
}

