/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.tile_entity;

import java.util.ArrayList;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import xerca.xercamusic.client.MusicManagerClient;
import xerca.xercamusic.client.SoundController;
import xerca.xercamusic.common.MusicManager;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.block.BlockMusicBox;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.item.ItemMusicSheet;
import xerca.xercamusic.common.packets.clientbound.MusicBoxUpdatePacket;
import xerca.xercamusic.common.tile_entity.BlockEntities;

public class TileEntityMusicBox
extends class_2586 {
    private boolean isPlaying = false;
    private boolean oldPoweredState = false;
    private boolean isPowering = false;
    private boolean firstBlockUpdate = true;
    private class_1799 noteStack = class_1799.field_8037;
    private IItemInstrument instrument;
    private final ArrayList<NoteEvent> notes = new ArrayList();
    private byte mBPS;
    private float mVolume;
    private int poweringAge = 0;
    private int playingAge = 0;
    private int mLengthBeats = 0;
    private SoundController soundController = null;

    public TileEntityMusicBox(class_2338 blockPos, class_2680 blockState) {
        super(BlockEntities.MUSIC_BOX, blockPos, blockState);
        if (((Boolean)blockState.method_11654((class_2769)BlockMusicBox.POWERED)).booleanValue()) {
            this.oldPoweredState = true;
        }
    }

    public void method_11007(@NotNull class_2487 parent) {
        super.method_11007(parent);
        if (!this.noteStack.method_7960()) {
            class_2487 noteTag = new class_2487();
            this.noteStack.method_7953(noteTag);
            parent.method_10566("note", (class_2520)noteTag);
        }
        if (this.instrument != null) {
            class_2960 resourcelocation = class_7923.field_41178.method_10221((Object)((class_1792)this.instrument));
            parent.method_10582("instrument_id", resourcelocation.toString());
        }
    }

    public void method_11014(@NotNull class_2487 parent) {
        super.method_11014(parent);
        if (parent.method_10573("note", 10)) {
            class_2487 noteTag = parent.method_10562("note");
            class_1799 note = class_1799.method_7915((class_2487)noteTag);
            this.setNoteStack(note, false);
        }
        if (parent.method_10573("instrument_id", 8)) {
            this.setInstrument((class_1792)class_7923.field_41178.method_10223(new class_2960(parent.method_10558("instrument_id"))));
        }
    }

    @NotNull
    public class_2487 method_16887() {
        return this.method_38242();
    }

    private void stopPowering() {
        class_2680 state = this.method_11010();
        if (this.field_11863 != null) {
            this.field_11863.method_8501(this.field_11867, (class_2680)state.method_11657((class_2769)BlockMusicBox.POWERING, (Comparable)Boolean.valueOf(false)));
        }
        this.isPowering = false;
        this.poweringAge = 0;
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, TileEntityMusicBox t) {
        class_2487 comp;
        if (level != null && !t.noteStack.method_7960() && t.notes.isEmpty() && t.noteStack.method_7985() && (comp = t.noteStack.method_7969()) != null && comp.method_10545("id") && comp.method_10545("ver") && comp.method_10545("bps") && comp.method_10545("l")) {
            UUID id = comp.method_25926("id");
            int ver = comp.method_10550("ver");
            if (level.field_9236) {
                MusicManagerClient.checkMusicDataAndRun(id, ver, () -> {
                    MusicManager.MusicData data = MusicManagerClient.getMusicData(id, ver);
                    if (data != null) {
                        t.notes.clear();
                        t.notes.addAll(data.notes);
                    }
                });
            } else if (level.method_8503() != null) {
                MusicManager.MusicData data = MusicManager.getMusicData(id, ver, level.method_8503());
                if (data != null) {
                    t.notes.clear();
                    t.notes.addAll(data.notes);
                } else {
                    XercaMusic.LOGGER.info("Clearing tag data from unknown music sheet");
                    t.noteStack.method_7980(new class_2487());
                }
            }
        }
        if (t.isPowering) {
            if (t.poweringAge >= 10) {
                t.stopPowering();
                return;
            }
            ++t.poweringAge;
        }
        if (t.noteStack.method_7960() || t.instrument == null) {
            if (t.soundController != null) {
                t.soundController.setStop();
            }
            t.isPlaying = false;
            return;
        }
        if (((Boolean)state.method_11654((class_2769)BlockMusicBox.POWERED)).booleanValue()) {
            if (!t.oldPoweredState) {
                t.isPlaying = !t.isPlaying;
                t.poweringAge = 0;
                t.oldPoweredState = true;
                t.playingAge = 0;
                if (t.isPlaying) {
                    TileEntityMusicBox.musicStart(t, blockPos);
                } else if (t.soundController != null) {
                    t.soundController.setStop();
                }
            }
        } else if (t.oldPoweredState) {
            t.oldPoweredState = false;
        }
        if (t.isPlaying) {
            ++t.playingAge;
            if (t.playingAge >= t.beatsToTicks(t.mLengthBeats)) {
                TileEntityMusicBox.musicOver(t, state);
            }
        }
    }

    private int beatsToTicks(int beats) {
        return Math.round((float)beats * 20.0f / (float)this.mBPS);
    }

    public static void musicOver(TileEntityMusicBox t, class_2680 state) {
        t.poweringAge = 0;
        t.isPlaying = false;
        t.isPowering = true;
        if (t.field_11863 != null) {
            class_2350 rightSide = ((class_2350)state.method_11654((class_2769)BlockMusicBox.field_11177)).method_10170();
            t.field_11863.method_8501(t.field_11867, (class_2680)state.method_11657((class_2769)BlockMusicBox.POWERING, (Comparable)Boolean.valueOf(true)));
            class_2338 neighbor = t.field_11867.method_10093(rightSide);
            t.field_11863.method_8492(neighbor, t.method_11010().method_26204(), t.field_11867);
            t.field_11863.method_8508(neighbor, t.method_11010().method_26204(), rightSide.method_10153());
        }
    }

    public static void musicStart(TileEntityMusicBox t, class_2338 blockPos) {
        if (t.field_11863 != null && t.field_11863.field_9236) {
            if (t.soundController != null) {
                t.soundController.setStop();
            }
            t.soundController = new SoundController(t.notes, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), t.instrument, t.mBPS, t.mVolume, t);
            t.soundController.start();
        }
    }

    public class_1799 getNoteStack() {
        return this.noteStack;
    }

    public void setNoteStack(class_1799 noteStack, boolean updateClient) {
        if (noteStack.method_7909() instanceof ItemMusicSheet) {
            if (updateClient && this.field_11863 != null && !this.field_11863.field_9236) {
                this.updateClient(noteStack, (class_1792)this.instrument);
            }
            this.noteStack = noteStack;
            if (noteStack.method_7985() && noteStack.method_7969() != null && noteStack.method_7969().method_10545("id") && noteStack.method_7969().method_10545("ver") && noteStack.method_7969().method_10545("l")) {
                class_2487 comp = noteStack.method_7969();
                this.mBPS = (byte)(comp.method_10545("bps") ? (int)comp.method_10571("bps") : 8);
                this.mVolume = comp.method_10545("vol") ? comp.method_10583("vol") : 1.0f;
                this.mLengthBeats = comp.method_10550("l");
            } else {
                this.notes.clear();
            }
            this.method_5431();
        }
    }

    public void removeNoteStack() {
        if (!this.noteStack.method_7960()) {
            if (this.field_11863 != null && !this.field_11863.field_9236) {
                this.updateClient(class_1799.field_8037, (class_1792)this.instrument);
            }
            this.noteStack = class_1799.field_8037;
            this.notes.clear();
            this.method_5431();
        }
    }

    public IItemInstrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(class_1792 instrument) {
        if (instrument instanceof IItemInstrument) {
            if (this.field_11863 != null && !this.field_11863.field_9236) {
                this.updateClient(null, instrument);
            }
            this.instrument = (IItemInstrument)instrument;
            this.method_5431();
        }
    }

    public void removeInstrument() {
        if (this.instrument != null) {
            if (this.field_11863 != null && !this.field_11863.field_9236) {
                this.updateClient(null, null);
            }
            this.instrument = null;
            this.method_5431();
        }
    }

    private void updateClient(class_1799 noteStack, class_1792 itemInstrument) {
        MusicBoxUpdatePacket packet = new MusicBoxUpdatePacket(this.field_11867, noteStack, itemInstrument);
        for (class_3222 player : PlayerLookup.tracking((class_2586)this)) {
            XercaMusic.sendToClient(player, packet);
        }
    }

    public class_2622 getUpdatePacket() {
        if (this.firstBlockUpdate) {
            this.firstBlockUpdate = false;
            if (this.field_11863 != null && ((Boolean)this.method_11010().method_11654((class_2769)BlockMusicBox.POWERING)).booleanValue()) {
                this.stopPowering();
            }
            return class_2622.method_38585((class_2586)this);
        }
        return null;
    }

    public void method_11012() {
        if (this.soundController != null) {
            this.soundController.setStop();
        }
        super.method_11012();
    }
}

