/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets.serverbound;

import java.util.ArrayList;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.packets.IPacket;
import xerca.xercamusic.common.packets.serverbound.ImportMusicSendPacket;

public class MusicUpdatePacket
implements IPacket {
    public static final class_2960 ID = new class_2960("xercamusic", "music_update");
    private FieldFlag availability;
    private ArrayList<NoteEvent> notes;
    private short lengthBeats;
    private byte bps;
    private float volume;
    private boolean signed;
    private String title;
    private byte prevInstrument;
    private boolean prevInsLocked;
    private UUID id;
    private int version;
    private byte highlightInterval;
    private boolean messageIsValid;

    public MusicUpdatePacket(FieldFlag availability, ArrayList<NoteEvent> notes, short lengthBeats, byte bps, float volume, boolean signed, String title, byte prevInstrument, boolean prevInsLocked, UUID id, int version, byte highlightInterval) throws ImportMusicSendPacket.NotesTooLargeException {
        this.availability = availability;
        this.lengthBeats = lengthBeats;
        this.bps = bps;
        this.volume = volume;
        this.signed = signed;
        this.title = title;
        this.prevInstrument = prevInstrument;
        this.prevInsLocked = prevInsLocked;
        this.id = id;
        this.version = version;
        this.highlightInterval = highlightInterval;
        this.notes = notes;
        if (availability.hasNotes && this.notes != null && this.notes.size() > 5000) {
            throw new ImportMusicSendPacket.NotesTooLargeException(notes, id);
        }
    }

    public MusicUpdatePacket() {
        this.messageIsValid = false;
    }

    public static MusicUpdatePacket decode(class_2540 buf) {
        MusicUpdatePacket result = new MusicUpdatePacket();
        try {
            int eventCount;
            FieldFlag flag;
            result.availability = flag = FieldFlag.fromInt(buf.readInt());
            if (flag.hasTitle) {
                result.title = buf.method_10800(255);
            }
            if (flag.hasSigned) {
                result.signed = buf.readBoolean();
            }
            if (flag.hasBps) {
                result.bps = buf.readByte();
            }
            if (flag.hasVolume) {
                result.volume = buf.readFloat();
            }
            if (flag.hasLength) {
                result.lengthBeats = buf.readShort();
            }
            if (flag.hasNotes && (eventCount = buf.readInt()) != 0) {
                result.notes = new ArrayList(eventCount);
                for (int i = 0; i < eventCount; ++i) {
                    result.notes.add(NoteEvent.fromBuffer(buf));
                }
            }
            if (flag.hasPrevIns) {
                result.prevInstrument = buf.readByte();
            }
            if (flag.hasPrevInsLocked) {
                result.prevInsLocked = buf.readBoolean();
            }
            if (flag.hasId) {
                result.id = buf.method_10790();
            }
            if (flag.hasVersion) {
                result.version = buf.readInt();
            }
            if (flag.hasHlInterval) {
                result.highlightInterval = buf.readByte();
            }
        }
        catch (IndexOutOfBoundsException ioe) {
            System.err.println("Exception while reading MusicUpdatePacket: " + ioe);
            return null;
        }
        result.messageIsValid = true;
        return result;
    }

    @Override
    public class_2540 encode() {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(this.availability.toInt());
        if (this.availability.hasTitle) {
            buf.method_10814(this.title);
        }
        if (this.availability.hasSigned) {
            buf.writeBoolean(this.signed);
        }
        if (this.availability.hasBps) {
            buf.writeByte((int)this.bps);
        }
        if (this.availability.hasVolume) {
            buf.writeFloat(this.volume);
        }
        if (this.availability.hasLength) {
            buf.writeShort((int)this.lengthBeats);
        }
        if (this.availability.hasNotes) {
            if (this.notes != null) {
                buf.writeInt(this.notes.size());
                for (NoteEvent event : this.notes) {
                    event.encodeToBuffer(buf);
                }
            } else {
                buf.writeInt(0);
            }
        }
        if (this.availability.hasPrevIns) {
            buf.writeByte((int)this.prevInstrument);
        }
        if (this.availability.hasPrevInsLocked) {
            buf.writeBoolean(this.prevInsLocked);
        }
        if (this.availability.hasId) {
            buf.method_10797(this.id);
        }
        if (this.availability.hasVersion) {
            buf.writeInt(this.version);
        }
        if (this.availability.hasHlInterval) {
            buf.writeByte((int)this.highlightInterval);
        }
        return buf;
    }

    public ArrayList<NoteEvent> getNotes() {
        return this.notes;
    }

    public short getLengthBeats() {
        return this.lengthBeats;
    }

    public byte getBps() {
        return this.bps;
    }

    public float getVolume() {
        return this.volume;
    }

    public boolean getSigned() {
        return this.signed;
    }

    public String getTitle() {
        return this.title;
    }

    public byte getPrevInstrument() {
        return this.prevInstrument;
    }

    public boolean getPrevInsLocked() {
        return this.prevInsLocked;
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public byte getHighlightInterval() {
        return this.highlightInterval;
    }

    public void setHighlightInterval(byte highlightInterval) {
        this.highlightInterval = highlightInterval;
    }

    public FieldFlag getAvailability() {
        return this.availability;
    }

    public void setAvailability(FieldFlag availability) {
        this.availability = availability;
    }

    @Override
    public class_2960 getID() {
        return ID;
    }

    public static class FieldFlag {
        private static final int notesFlag = 1;
        private static final int lengthFlag = 2;
        private static final int bpsFlag = 4;
        private static final int volumeFlag = 8;
        private static final int signedFlag = 16;
        private static final int titleFlag = 32;
        private static final int prevInsFlag = 64;
        private static final int prevInsLockedFlag = 128;
        private static final int idFlag = 256;
        private static final int versionFlag = 512;
        private static final int hlIntervalFlag = 1024;
        public boolean hasNotes;
        public boolean hasLength;
        public boolean hasBps;
        public boolean hasVolume;
        public boolean hasSigned;
        public boolean hasTitle;
        public boolean hasPrevIns;
        public boolean hasPrevInsLocked;
        public boolean hasId;
        public boolean hasVersion;
        public boolean hasHlInterval;

        public FieldFlag(boolean hasNotes, boolean hasLength, boolean hasBps, boolean hasVolume, boolean hasSigned, boolean hasTitle, boolean hasPrevIns, boolean hasPrevInsLocked, boolean hasId, boolean hasVersion, boolean hasHlInterval) {
            this.hasNotes = hasNotes;
            this.hasLength = hasLength;
            this.hasBps = hasBps;
            this.hasVolume = hasVolume;
            this.hasSigned = hasSigned;
            this.hasTitle = hasTitle;
            this.hasPrevIns = hasPrevIns;
            this.hasPrevInsLocked = hasPrevInsLocked;
            this.hasId = hasId;
            this.hasVersion = hasVersion;
            this.hasHlInterval = hasHlInterval;
        }

        public FieldFlag() {
        }

        public int toInt() {
            return (this.hasNotes ? 1 : 0) | (this.hasLength ? 2 : 0) | (this.hasBps ? 4 : 0) | (this.hasVolume ? 8 : 0) | (this.hasSigned ? 16 : 0) | (this.hasTitle ? 32 : 0) | (this.hasPrevIns ? 64 : 0) | (this.hasPrevInsLocked ? 128 : 0) | (this.hasId ? 256 : 0) | (this.hasVersion ? 512 : 0) | (this.hasHlInterval ? 1024 : 0);
        }

        public static FieldFlag fromInt(int packed) {
            return new FieldFlag((packed & 1) != 0, (packed & 2) != 0, (packed & 4) != 0, (packed & 8) != 0, (packed & 0x10) != 0, (packed & 0x20) != 0, (packed & 0x40) != 0, (packed & 0x80) != 0, (packed & 0x100) != 0, (packed & 0x200) != 0, (packed & 0x400) != 0);
        }

        public boolean hasAny() {
            return this.hasNotes || this.hasLength || this.hasBps || this.hasVolume || this.hasSigned || this.hasTitle || this.hasPrevIns || this.hasPrevInsLocked || this.hasId || this.hasVersion || this.hasHlInterval;
        }

        public String toString() {
            return (this.hasNotes ? "Notes, " : "") + (this.hasLength ? "Length, " : "") + (this.hasBps ? "Bps, " : "") + (this.hasVolume ? "Volume, " : "") + (this.hasSigned ? "Signed, " : "") + (this.hasTitle ? "Title, " : "") + (this.hasPrevIns ? "PrevIns, " : "") + (this.hasPrevInsLocked ? "PrevInsLocked, " : "") + (this.hasId ? "Id, " : "") + (this.hasVersion ? "Version, " : "") + (this.hasHlInterval ? "HL Interval" : "");
        }
    }
}

