/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets.clientbound;

import java.util.ArrayList;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.packets.IPacket;

public class MusicDataResponsePacket
implements IPacket {
    public static final class_2960 ID = new class_2960("xercamusic", "music_data_response");
    private UUID id;
    private int version;
    private ArrayList<NoteEvent> notes;
    private boolean messageIsValid;

    public MusicDataResponsePacket(UUID id, int version, ArrayList<NoteEvent> notes) {
        this.id = id;
        this.version = version;
        this.notes = notes;
    }

    public MusicDataResponsePacket() {
        this.messageIsValid = false;
    }

    public static MusicDataResponsePacket decode(class_2540 buf) {
        MusicDataResponsePacket result = new MusicDataResponsePacket();
        try {
            result.id = buf.method_10790();
            result.version = buf.readInt();
            int eventCount = buf.readInt();
            result.notes = new ArrayList(eventCount);
            for (int i = 0; i < eventCount; ++i) {
                result.notes.add(NoteEvent.fromBuffer(buf));
            }
        }
        catch (IndexOutOfBoundsException ioe) {
            XercaMusic.LOGGER.error("Exception while reading MusicDataRequestPacket: " + ioe);
            return null;
        }
        result.messageIsValid = true;
        return result;
    }

    @Override
    public class_2540 encode() {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(this.getId());
        buf.writeInt(this.getVersion());
        buf.writeInt(this.notes.size());
        for (NoteEvent event : this.notes) {
            event.encodeToBuffer(buf);
        }
        return buf;
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public ArrayList<NoteEvent> getNotes() {
        return this.notes;
    }

    public void setNotes(ArrayList<NoteEvent> notes) {
        this.notes = notes;
    }

    @Override
    public class_2960 getID() {
        return ID;
    }
}

