/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_3222;
import xerca.xercamusic.client.MusicManagerClient;
import xerca.xercamusic.common.MusicManager;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.item.ItemMusicSheet;
import xerca.xercamusic.common.packets.clientbound.ExportMusicPacket;

public class CommandExport {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"musicexport").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(p -> CommandExport.musicExport((class_2168)p.getSource(), StringArgumentType.getString((CommandContext)p, (String)"name")))));
    }

    private static int musicExport(class_2168 stack, String name) {
        XercaMusic.LOGGER.debug("Music export called. name: " + name);
        if (stack.method_9228() == null) {
            XercaMusic.LOGGER.error("Command entity is not found");
            return 0;
        }
        class_1297 commander = stack.method_9228();
        if (!(commander instanceof class_3222)) {
            XercaMusic.LOGGER.error("Command entity is not a player");
            return 0;
        }
        class_3222 player = (class_3222)commander;
        ExportMusicPacket pack = new ExportMusicPacket(name);
        XercaMusic.sendToClient(player, pack);
        return 1;
    }

    public static boolean doExport(class_1657 player, String name) {
        String dir = "music_sheets";
        String filename = name + ".sheet";
        String filepath = dir + "/" + filename;
        File directory = new File(dir);
        if (!directory.exists()) {
            directory.mkdir();
        }
        for (class_1799 s : player.method_5877()) {
            if (!(s.method_7909() instanceof ItemMusicSheet) || !s.method_7985() || s.method_7969() == null) continue;
            class_2487 tag = s.method_7969().method_10553();
            if (tag.method_10545("id") && tag.method_10545("ver")) {
                UUID id = tag.method_25926("id");
                int ver = tag.method_10550("ver");
                MusicManagerClient.checkMusicDataAndRun(id, ver, () -> {
                    MusicManager.MusicData data = MusicManagerClient.getMusicData(id, ver);
                    if (data != null) {
                        NoteEvent.fillNBTFromArray(data.notes, tag);
                        try {
                            class_2507.method_10630((class_2487)tag, (File)new File(filepath));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            return true;
        }
        return false;
    }
}

