/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.client;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;
import net.minecraft.class_310;
import xerca.xercamusic.client.GuiMusicSheet;
import xerca.xercamusic.common.XercaMusic;

public class MidiHandler {
    final ArrayList<MidiDevice> devices = new ArrayList();
    final Consumer<MidiData> noteOnHandler;
    final Consumer<Integer> noteOffHandler;
    final Consumer<GuiMusicSheet.MidiControl> midiControlHandler;
    public volatile int currentOctave;

    public MidiHandler(Consumer<MidiData> noteOnHandler, Consumer<Integer> noteOffHandler, Consumer<GuiMusicSheet.MidiControl> midiControlHandler) {
        MidiDevice.Info[] infos;
        this.noteOnHandler = noteOnHandler;
        this.noteOffHandler = noteOffHandler;
        this.midiControlHandler = midiControlHandler;
        for (MidiDevice.Info info : infos = MidiSystem.getMidiDeviceInfo()) {
            try {
                MidiDevice device = MidiSystem.getMidiDevice(info);
                XercaMusic.LOGGER.debug((Object)info);
                List<Transmitter> transmitters = device.getTransmitters();
                for (Transmitter transmitter : transmitters) {
                    transmitter.setReceiver(new MidiInputReceiver(device.getDeviceInfo().toString()));
                }
                Transmitter trans = device.getTransmitter();
                trans.setReceiver(new MidiInputReceiver(device.getDeviceInfo().toString()));
                device.open();
                this.devices.add(device);
                XercaMusic.LOGGER.debug(device.getDeviceInfo() + " was opened");
            }
            catch (MidiUnavailableException exception) {
                XercaMusic.LOGGER.debug("Midi unavailable: " + exception.getMessage());
            }
        }
    }

    public MidiHandler(Consumer<MidiData> noteOnHandler, Consumer<Integer> noteOffHandler) {
        this(noteOnHandler, noteOffHandler, null);
    }

    public void closeDevices() {
        for (MidiDevice device : this.devices) {
            if (!device.isOpen()) continue;
            device.close();
        }
    }

    public class MidiInputReceiver
    implements Receiver {
        public String name;
        public static final int NOTE_ON = 144;
        public static final int NOTE_OFF = 128;
        public static final int CONTROL = 176;
        public static final int DATA_RECORD = 107;
        public static final int DATA_PREVIEW = 106;
        public static final int DATA_STOP = 105;
        public static final int DATA_END = 104;
        public static final int DATA_BEGINNING = 103;
        static final float ym = 0.7f;
        static final float b = 0.1836735f;

        public MidiInputReceiver(String name) {
            this.name = name;
        }

        private static float volumeCurve(float x) {
            return (float)(Math.pow(0.1836735f, x) / -0.8163264989852905 - (double)-1.225f);
        }

        @Override
        public void send(MidiMessage msg, long timeStamp) {
            if (msg instanceof ShortMessage) {
                ShortMessage sm = (ShortMessage)msg;
                if (((ShortMessage)msg).getCommand() == 176 && MidiHandler.this.midiControlHandler != null) {
                    int data = sm.getData1();
                    switch (data) {
                        case 103: {
                            class_310.method_1551().method_20493(() -> MidiHandler.this.midiControlHandler.accept(GuiMusicSheet.MidiControl.BEGINNING));
                            break;
                        }
                        case 104: {
                            class_310.method_1551().method_20493(() -> MidiHandler.this.midiControlHandler.accept(GuiMusicSheet.MidiControl.END));
                            break;
                        }
                        case 105: {
                            class_310.method_1551().method_20493(() -> MidiHandler.this.midiControlHandler.accept(GuiMusicSheet.MidiControl.STOP));
                            break;
                        }
                        case 106: {
                            class_310.method_1551().method_20493(() -> MidiHandler.this.midiControlHandler.accept(GuiMusicSheet.MidiControl.PREVIEW));
                            break;
                        }
                        case 107: {
                            class_310.method_1551().method_20493(() -> MidiHandler.this.midiControlHandler.accept(GuiMusicSheet.MidiControl.RECORD));
                        }
                    }
                    return;
                }
                int key = sm.getData1() - 21 + 12 * MidiHandler.this.currentOctave;
                int velocity = sm.getData2();
                System.out.println("Note message " + (sm.getCommand() == 144 ? "on" : "off") + " key: " + key + " vel: " + velocity);
                if (key < 0 || key > 95) {
                    return;
                }
                if (sm.getCommand() == 144 && velocity > 0) {
                    float vel = (float)velocity / 128.0f;
                    float vol = MidiInputReceiver.volumeCurve(vel);
                    class_310.method_1551().method_20493(() -> MidiHandler.this.noteOnHandler.accept(new MidiData(key, vol)));
                } else if (sm.getCommand() == 128 || sm.getCommand() == 144 && velocity == 0) {
                    class_310.method_1551().method_20493(() -> MidiHandler.this.noteOffHandler.accept(key));
                }
            }
        }

        @Override
        public void close() {
        }
    }

    public record MidiData(int noteId, float volume) {
    }
}

