/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.services.modrinth;

import com.google.gson.reflect.TypeToken;
import dev.dediamondpro.resourcify.services.ISearchData;
import dev.dediamondpro.resourcify.services.IService;
import dev.dediamondpro.resourcify.services.ProjectType;
import dev.dediamondpro.resourcify.services.modrinth.ModrinthCategory;
import dev.dediamondpro.resourcify.services.modrinth.ModrinthMinecraftVersion;
import dev.dediamondpro.resourcify.services.modrinth.ModrinthSearchData;
import dev.dediamondpro.resourcify.services.modrinth.ModrinthService;
import dev.dediamondpro.resourcify.util.JsonUtil;
import dev.dediamondpro.resourcify.util.MultiThreadingKt;
import dev.dediamondpro.resourcify.util.NetworkUtilKt;
import dev.dediamondpro.resourcify.util.UtilsKt;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\n\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\r\u0010\u0003J\u000f\u0010\u000e\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u0003J5\u0010\u0011\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00100\u00100\u000f2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J!\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00100\u000fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001b\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0010H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJM\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0013\u0010#\u001a\u00020\u0007*\u00020\u0004H\u0002\u00a2\u0006\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b%\u0010&R$\u0010\t\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0\u0006\u0018\u00010\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\t\u0010(R$\u0010\b\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0\u0006\u0018\u00010\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\b\u0010(\u00a8\u0006*"}, d2={"Ldev/dediamondpro/resourcify/services/modrinth/ModrinthService;", "Ldev/dediamondpro/resourcify/services/IService;", "<init>", "()V", "Ldev/dediamondpro/resourcify/services/ProjectType;", "type", "", "", "minecraftVersions", "categories", "buildFacets", "(Ldev/dediamondpro/resourcify/services/ProjectType;Ljava/util/List;Ljava/util/List;)Ljava/lang/String;", "", "fetchCategories", "fetchMinecraftVersions", "Ljava/util/concurrent/CompletableFuture;", "", "getCategories", "(Ldev/dediamondpro/resourcify/services/ProjectType;)Ljava/util/concurrent/CompletableFuture;", "getMinecraftVersions", "()Ljava/util/concurrent/CompletableFuture;", "getName", "()Ljava/lang/String;", "getSortOptions", "()Ljava/util/Map;", "category", "localizeCategory", "(Ljava/lang/String;)Ljava/lang/String;", "query", "sortBy", "", "offset", "Ldev/dediamondpro/resourcify/services/ISearchData;", "search", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;ILdev/dediamondpro/resourcify/services/ProjectType;)Ldev/dediamondpro/resourcify/services/ISearchData;", "getProjectType", "(Ldev/dediamondpro/resourcify/services/ProjectType;)Ljava/lang/String;", "API", "Ljava/lang/String;", "Ldev/dediamondpro/resourcify/services/modrinth/ModrinthCategory;", "Ljava/util/concurrent/CompletableFuture;", "Ldev/dediamondpro/resourcify/services/modrinth/ModrinthMinecraftVersion;", "resourcify"})
@SourceDebugExtension(value={"SMAP\nModrinthService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModrinthService.kt\ndev/dediamondpro/resourcify/services/modrinth/ModrinthService\n+ 2 NetworkUtil.kt\ndev/dediamondpro/resourcify/util/NetworkUtilKt\n+ 3 JsonUtil.kt\ndev/dediamondpro/resourcify/util/JsonUtilKt\n*L\n1#1,137:1\n205#2,5:138\n205#2,5:145\n205#2,5:152\n35#3,2:143\n35#3,2:150\n35#3,2:157\n*S KotlinDebug\n*F\n+ 1 ModrinthService.kt\ndev/dediamondpro/resourcify/services/modrinth/ModrinthService\n*L\n48#1:138,5\n86#1:145,5\n112#1:152,5\n48#1:143,2\n86#1:150,2\n112#1:157,2\n*E\n"})
public final class ModrinthService
implements IService {
    @NotNull
    public static final ModrinthService INSTANCE = new ModrinthService();
    @NotNull
    public static final String API = "https://api.modrinth.com/v2";
    @Nullable
    private static CompletableFuture<List<ModrinthMinecraftVersion>> minecraftVersions;
    @Nullable
    private static CompletableFuture<List<ModrinthCategory>> categories;

    private ModrinthService() {
    }

    @Override
    @NotNull
    public String getName() {
        return "Modrinth";
    }

    @Override
    @Nullable
    public ISearchData search(@NotNull String query, @NotNull String sortBy2, @NotNull List<String> minecraftVersions, @NotNull List<String> categories, int offset2, @NotNull ProjectType type2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)sortBy2, (String)"sortBy");
        Intrinsics.checkNotNullParameter(minecraftVersions, (String)"minecraftVersions");
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        URL uRL = new URIBuilder("https://api.modrinth.com/v2/search").setParameter("query", query).setParameter("facets", this.buildFacets(type2, minecraftVersions, categories)).setParameter("limit", "20").setParameter("offset", String.valueOf(offset2)).setParameter("index", sortBy2).build().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"URIBuilder(\"${API}/searc\u2026         .build().toURL()");
        URL $this$getJson_u24default$iv = uRL;
        boolean useCache$iv = true;
        int attempts$iv = 3;
        Map headers$iv = MapsKt.emptyMap();
        boolean $i$f$getJson = false;
        String string = NetworkUtilKt.getString($this$getJson_u24default$iv, useCache$iv, attempts$iv, headers$iv);
        if (string != null) {
            String $this$fromJson$iv$iv = string;
            boolean $i$f$fromJson = false;
            Type type$iv$iv = new TypeToken<ModrinthSearchData>(){}.getType();
            object = JsonUtil.INSTANCE.getGson().fromJson($this$fromJson$iv$iv, type$iv$iv);
        } else {
            object = null;
        }
        return (ISearchData)object;
    }

    private final String buildFacets(ProjectType type2, List<String> minecraftVersions, List<String> categories) {
        StringBuilder stringBuilder;
        StringBuilder $this$buildFacets_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildFacets_u24lambda_u240.append("[");
        $this$buildFacets_u24lambda_u240.append((String)(switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1 -> "[\"project_type:mod\"],[\"categories=datapack\"]";
            case 2 -> "[\"project_type:shader\"],[\"categories=iris\"]";
            case 3 -> "[\"project_type:shader\"],[\"categories=optifine\"]";
            default -> "[\"project_type:" + INSTANCE.getProjectType(type2) + "\"]";
        }));
        if (!((Collection)categories).isEmpty()) {
            $this$buildFacets_u24lambda_u240.append(",");
            $this$buildFacets_u24lambda_u240.append(CollectionsKt.joinToString$default((Iterable)categories, (CharSequence)",", null, null, (int)0, null, (Function1)buildFacets.1.1.INSTANCE, (int)30, null));
        }
        if (!((Collection)minecraftVersions).isEmpty()) {
            $this$buildFacets_u24lambda_u240.append(",[");
            $this$buildFacets_u24lambda_u240.append(CollectionsKt.joinToString$default((Iterable)minecraftVersions, (CharSequence)",", null, null, (int)0, null, (Function1)buildFacets.1.2.INSTANCE, (int)30, null));
            $this$buildFacets_u24lambda_u240.append("]");
        }
        $this$buildFacets_u24lambda_u240.append("]");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public CompletableFuture<Map<String, String>> getMinecraftVersions() {
        this.fetchMinecraftVersions();
        CompletableFuture<List<ModrinthMinecraftVersion>> completableFuture = minecraftVersions;
        CompletableFuture<Map<String, String>> completableFuture2 = completableFuture != null ? completableFuture.thenApply(arg_0 -> ModrinthService.getMinecraftVersions$lambda$1(getMinecraftVersions.1.INSTANCE, arg_0)) : null;
        return completableFuture2 == null ? MultiThreadingKt.supply(ModrinthService::getMinecraftVersions$lambda$2) : completableFuture2;
    }

    private final void fetchMinecraftVersions() {
        if (minecraftVersions != null) {
            CompletableFuture<List<ModrinthMinecraftVersion>> completableFuture = minecraftVersions;
            boolean bl = completableFuture != null ? completableFuture.isDone() : false;
            if (bl) {
                CompletableFuture<List<ModrinthMinecraftVersion>> completableFuture2 = minecraftVersions;
                boolean bl2 = completableFuture2 != null ? !completableFuture2.isCompletedExceptionally() : false;
                if (bl2) {
                    return;
                }
            }
        }
        minecraftVersions = MultiThreadingKt.supplyAsync(ModrinthService::fetchMinecraftVersions$lambda$3);
    }

    @Override
    @NotNull
    public CompletableFuture<Map<String, Map<String, String>>> getCategories(@NotNull ProjectType type2) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        this.fetchCategories();
        CompletableFuture<List<ModrinthCategory>> completableFuture = categories;
        CompletableFuture<Map<String, Map<String, String>>> completableFuture2 = completableFuture != null ? completableFuture.thenApply(arg_0 -> ModrinthService.getCategories$lambda$4((Function1)new Function1<List<? extends ModrinthCategory>, Map<String, ? extends Map<String, ? extends String>>>(type2){
            final /* synthetic */ ProjectType $type;
            {
                this.$type = $type;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final Map<String, Map<String, String>> invoke(List<ModrinthCategory> it) {
                void $this$mapValuesTo$iv$iv;
                Map $this$groupByTo$iv$iv;
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullExpressionValue(it, (String)"it");
                Iterable iterable = it;
                ProjectType projectType = this.$type;
                boolean $i$f$filter22 = false;
                void var5_7 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo22 = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    ModrinthCategory category = (ModrinthCategory)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)category.getProjectType(), (Object)ModrinthService.access$getProjectType(ModrinthService.INSTANCE, projectType))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$groupBy$iv = (List)destination$iv$iv;
                boolean $i$f$groupBy = false;
                Iterable $i$f$filter22 = $this$groupBy$iv;
                Map destination$iv$iv2 = new LinkedHashMap<K, V>();
                boolean $i$f$groupByTo = false;
                Iterator<T> $i$f$filterTo22 = $this$groupByTo$iv$iv.iterator();
                while ($i$f$filterTo22.hasNext()) {
                    Object object;
                    T element$iv$iv = $i$f$filterTo22.next();
                    ModrinthCategory category = (ModrinthCategory)element$iv$iv;
                    boolean bl = false;
                    String key$iv$iv = ModrinthService.access$localizeCategory(ModrinthService.INSTANCE, category.getHeader());
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                    boolean $i$f$getOrPut = false;
                    V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList<E>();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                Map $this$mapValues$iv = destination$iv$iv2;
                boolean $i$f$mapValues = false;
                $this$groupByTo$iv$iv = $this$mapValues$iv;
                destination$iv$iv2 = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void $this$associateTo$iv$iv;
                    void it$iv$iv;
                    Map.Entry key$iv$iv = (Map.Entry)element$iv$iv$iv;
                    Map map2 = destination$iv$iv2;
                    boolean bl = false;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    K k = it$iv$iv.getKey();
                    Map map3 = map2;
                    boolean bl3 = false;
                    List categories = (List)entry.getValue();
                    Iterable $this$associate$iv = categories;
                    boolean $i$f$associate = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                    Iterable iterable2 = $this$associate$iv;
                    Map destination$iv$iv3 = new LinkedHashMap<K, V>(capacity$iv);
                    boolean $i$f$associateTo = false;
                    for (T element$iv$iv : $this$associateTo$iv$iv) {
                        Map map4 = destination$iv$iv3;
                        ModrinthCategory category = (ModrinthCategory)element$iv$iv;
                        boolean bl4 = false;
                        Pair pair = TuplesKt.to((Object)category.getName(), (Object)ModrinthService.access$localizeCategory(ModrinthService.INSTANCE, category.getName()));
                        map4.put(pair.getFirst(), pair.getSecond());
                    }
                    Map map5 = destination$iv$iv3;
                    map3.put(k, map5);
                }
                return destination$iv$iv2;
            }
        }, arg_0)) : null;
        return completableFuture2 == null ? MultiThreadingKt.supply(ModrinthService::getCategories$lambda$5) : completableFuture2;
    }

    private final String localizeCategory(String category) {
        String string = category.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return UtilsKt.localizeOrDefaultExtension("resourcify.categories." + StringsKt.replace$default((String)string, (String)" ", (String)"_", (boolean)false, (int)4, null), UtilsKt.capitalizeAll(category), new Object[0]);
    }

    private final void fetchCategories() {
        if (categories != null) {
            CompletableFuture<List<ModrinthCategory>> completableFuture = categories;
            boolean bl = completableFuture != null ? completableFuture.isDone() : false;
            if (bl) {
                CompletableFuture<List<ModrinthCategory>> completableFuture2 = categories;
                boolean bl2 = completableFuture2 != null ? !completableFuture2.isCompletedExceptionally() : false;
                if (bl2) {
                    return;
                }
            }
        }
        categories = MultiThreadingKt.supplyAsync(ModrinthService::fetchCategories$lambda$6).thenApply(arg_0 -> ModrinthService.fetchCategories$lambda$7(fetchCategories.2.INSTANCE, arg_0));
    }

    private final String getProjectType(ProjectType $this$getProjectType) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$getProjectType.ordinal()]) {
            case 4 -> "resourcepack";
            case 5 -> "resourcepack";
            case 1 -> "mod";
            case 2 -> "shader";
            case 3 -> "shader";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @NotNull
    public Map<String, String> getSortOptions() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"relevance", (Object)"resourcify.browse.sort.relevance"), TuplesKt.to((Object)"downloads", (Object)"resourcify.browse.sort.downloads"), TuplesKt.to((Object)"follows", (Object)"resourcify.browse.sort.follows"), TuplesKt.to((Object)"newest", (Object)"resourcify.browse.sort.newest"), TuplesKt.to((Object)"updated", (Object)"resourcify.browse.sort.updated")};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private static final Map getMinecraftVersions$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Map)$tmp0.invoke(p0);
    }

    private static final Map getMinecraftVersions$lambda$2() {
        return MapsKt.emptyMap();
    }

    /*
     * WARNING - void declaration
     */
    private static final List fetchMinecraftVersions$lambda$3() {
        Object object;
        void $this$getJson_u24default$iv;
        URL uRL = new URL("https://api.modrinth.com/v2/tag/game_version");
        boolean useCache$iv = false;
        int attempts$iv = 3;
        Map headers$iv = MapsKt.emptyMap();
        boolean $i$f$getJson = false;
        String string = NetworkUtilKt.getString((URL)$this$getJson_u24default$iv, useCache$iv, attempts$iv, headers$iv);
        if (string != null) {
            String $this$fromJson$iv$iv = string;
            boolean $i$f$fromJson = false;
            Type type$iv$iv = new TypeToken<List<? extends ModrinthMinecraftVersion>>(){}.getType();
            object = JsonUtil.INSTANCE.getGson().fromJson($this$fromJson$iv$iv, type$iv$iv);
        } else {
            object = null;
        }
        List list = (List)object;
        if (list == null) {
            throw new IllegalStateException("Failed to fetch Minecraft versions.".toString());
        }
        return list;
    }

    private static final Map getCategories$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Map)$tmp0.invoke(p0);
    }

    private static final Map getCategories$lambda$5() {
        return MapsKt.emptyMap();
    }

    /*
     * WARNING - void declaration
     */
    private static final List fetchCategories$lambda$6() {
        Object object;
        void $this$getJson_u24default$iv;
        URL uRL = new URL("https://api.modrinth.com/v2/tag/category");
        boolean useCache$iv = false;
        int attempts$iv = 3;
        Map headers$iv = MapsKt.emptyMap();
        boolean $i$f$getJson = false;
        String string = NetworkUtilKt.getString((URL)$this$getJson_u24default$iv, useCache$iv, attempts$iv, headers$iv);
        if (string != null) {
            String $this$fromJson$iv$iv = string;
            boolean $i$f$fromJson = false;
            Type type$iv$iv = new TypeToken<List<? extends ModrinthCategory>>(){}.getType();
            object = JsonUtil.INSTANCE.getGson().fromJson($this$fromJson$iv$iv, type$iv$iv);
        } else {
            object = null;
        }
        List list = (List)object;
        if (list == null) {
            throw new IllegalStateException("Failed to fetch categories.".toString());
        }
        return list;
    }

    private static final List fetchCategories$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$getProjectType(ModrinthService $this, ProjectType $receiver) {
        return $this.getProjectType($receiver);
    }

    public static final /* synthetic */ String access$localizeCategory(ModrinthService $this, String category) {
        return $this.localizeCategory(category);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProjectType.values().length];
            try {
                nArray[ProjectType.DATA_PACK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectType.IRIS_SHADER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectType.OPTIFINE_SHADER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectType.RESOURCE_PACK.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectType.AYCY_RESOURCE_PACK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

