/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.minemark.elements.impl.formatting;

import dev.dediamondpro.resourcify.libs.minemark.LayoutStyle;
import dev.dediamondpro.resourcify.libs.minemark.elements.ChildBasedElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.Element;
import dev.dediamondpro.resourcify.libs.minemark.elements.Inline;
import dev.dediamondpro.resourcify.libs.minemark.elements.creators.ElementCreator;
import dev.dediamondpro.resourcify.libs.minemark.style.Style;
import dev.dediamondpro.resourcify.libs.minemark.utils.ColorFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public class CssStyleElement<S extends Style, R>
extends ChildBasedElement<S, R>
implements Inline {
    private boolean isInline = true;

    public CssStyleElement(@NotNull S style, @NotNull LayoutStyle layoutStyle, @Nullable Element<S, R> parent, @NotNull String qName, @Nullable Attributes attributes) {
        super(style, layoutStyle, parent, qName, attributes);
        String[] parts;
        assert (attributes != null);
        String inlineCss = attributes.getValue("style");
        if (inlineCss == null) {
            return;
        }
        this.layoutStyle = this.layoutStyle.clone();
        block30: for (String part : parts = inlineCss.split(";")) {
            String[] propertyValue = part.split(":");
            if (propertyValue.length != 2) continue;
            String property = propertyValue[0].trim();
            String value = propertyValue[1].trim();
            switch (property) {
                case "color": {
                    this.layoutStyle.setTextColor(ColorFactory.web(value));
                    continue block30;
                }
                case "text-align": {
                    switch (value.toLowerCase()) {
                        case "left": {
                            this.layoutStyle.setAlignment(LayoutStyle.Alignment.LEFT);
                            this.isInline = false;
                            break;
                        }
                        case "center": {
                            this.layoutStyle.setAlignment(LayoutStyle.Alignment.CENTER);
                            this.isInline = false;
                            break;
                        }
                        case "right": {
                            this.layoutStyle.setAlignment(LayoutStyle.Alignment.RIGHT);
                            this.isInline = false;
                        }
                    }
                    continue block30;
                }
                case "text-decoration": {
                    String[] stringArray = value.split(" ");
                    int n = stringArray.length;
                    block31: for (int j = 0; j < n; ++j) {
                        String decoration;
                        switch (decoration = stringArray[j]) {
                            case "underline": {
                                this.layoutStyle.setUnderlined(true);
                                continue block31;
                            }
                            case "line-through": {
                                this.layoutStyle.setStrikethrough(true);
                            }
                        }
                    }
                    continue block30;
                }
                case "font-size": {
                    Float fontSize = null;
                    if (value.endsWith("px")) {
                        fontSize = Float.valueOf(style.getTextStyle().adaptFontSize(Float.parseFloat(value.substring(0, value.length() - 2))));
                    } else if (value.endsWith("%")) {
                        fontSize = Float.valueOf(layoutStyle.getFontSize() * (Float.parseFloat(value.substring(0, value.length() - 1)) / 100.0f));
                    }
                    if (fontSize == null) continue block30;
                    this.layoutStyle.setFontSize(fontSize.floatValue());
                }
            }
        }
    }

    @Override
    public boolean isInline() {
        return this.isInline;
    }

    public String toString() {
        return "CssStyleElement {" + this.attributes.getValue("style") + "}";
    }

    public static class CssStyleElementCreator<S extends Style, R>
    implements ElementCreator<S, R> {
        @Override
        public Element<S, R> createElement(S style, LayoutStyle layoutStyle, @NotNull Element<S, R> parent, @NotNull String qName, @NotNull Attributes attributes) {
            return new CssStyleElement<S, R>(style, layoutStyle, parent, qName, attributes);
        }

        @Override
        public boolean appliesTo(S style, LayoutStyle layoutStyle, @NotNull Element<S, R> parent, @NotNull String qName, @NotNull Attributes attributes) {
            return attributes.getValue("style") != null;
        }
    }
}

