/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.minemark.elements.impl.formatting;

import dev.dediamondpro.resourcify.libs.minemark.LayoutStyle;
import dev.dediamondpro.resourcify.libs.minemark.elements.ChildBasedElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.Element;
import dev.dediamondpro.resourcify.libs.minemark.elements.creators.ElementCreator;
import dev.dediamondpro.resourcify.libs.minemark.style.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public class AlignmentElement<S extends Style, R>
extends ChildBasedElement<S, R> {
    protected String alignment;

    public AlignmentElement(@NotNull S style, @NotNull LayoutStyle layoutStyle, @Nullable Element<S, R> parent, @NotNull String qName, @Nullable Attributes attributes) {
        super(style, layoutStyle, parent, qName, attributes);
        this.layoutStyle = this.layoutStyle.clone();
        String string = qName.equals("div") ? (attributes != null ? attributes.getValue("align") : null) : (this.alignment = qName);
        if (this.alignment == null) {
            return;
        }
        switch (this.alignment) {
            case "left": {
                this.layoutStyle.setAlignment(LayoutStyle.Alignment.LEFT);
                break;
            }
            case "center": {
                this.layoutStyle.setAlignment(LayoutStyle.Alignment.CENTER);
                break;
            }
            case "right": {
                this.layoutStyle.setAlignment(LayoutStyle.Alignment.RIGHT);
            }
        }
    }

    public String toString() {
        return "AlignmentElement {" + this.qName + "}";
    }

    public static class AlignmentElementCreator<S extends Style, R>
    implements ElementCreator<S, R> {
        @Override
        public Element<S, R> createElement(S style, LayoutStyle layoutStyle, @NotNull Element<S, R> parent, @NotNull String qName, @NotNull Attributes attributes) {
            return new AlignmentElement<S, R>(style, layoutStyle, parent, qName, attributes);
        }

        @Override
        public boolean appliesTo(S style, LayoutStyle layoutStyle, @NotNull Element<S, R> parent, @NotNull String qName, @NotNull Attributes attributes) {
            return qName.equals("center") || qName.equals("div") && attributes.getValue("align") != null;
        }
    }
}

