/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.minemark.elements.impl;

import dev.dediamondpro.resourcify.libs.minemark.LayoutData;
import dev.dediamondpro.resourcify.libs.minemark.LayoutStyle;
import dev.dediamondpro.resourcify.libs.minemark.elements.ChildMovingElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.Element;
import dev.dediamondpro.resourcify.libs.minemark.style.Style;
import java.awt.Color;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public abstract class CodeBlockElement<S extends Style, R>
extends ChildMovingElement<S, R> {
    protected final CodeBlockType codeBlockType;

    public CodeBlockElement(@NotNull S style, @NotNull LayoutStyle layoutStyle, @Nullable Element<S, R> parent, @NotNull String qName, @Nullable Attributes attributes) {
        super(style, layoutStyle, parent, qName, attributes);
        this.codeBlockType = layoutStyle.isPreFormatted() ? CodeBlockType.BLOCK : CodeBlockType.INLINE;
        this.layoutStyle = this.layoutStyle.clone();
        this.layoutStyle.setPartOfCodeBlock(true);
    }

    @Override
    @ApiStatus.Internal
    public void generateLayout(LayoutData layoutData, R renderData) {
        switch (this.codeBlockType) {
            case BLOCK: {
                super.generateLayout(layoutData, renderData);
                break;
            }
            case INLINE: {
                this.generateNewLayout(layoutData, renderData);
            }
        }
    }

    @Override
    protected void drawMarker(float x, float y, float markerWidth, float totalHeight, R renderData) {
        this.drawBlock(x, y, markerWidth, totalHeight, this.style.getCodeBlockStyle().getColor(), renderData);
    }

    protected abstract void drawBlock(float var1, float var2, float var3, float var4, Color var5, R var6);

    @Override
    protected float getMarkerWidth(LayoutData layoutData, R renderData) {
        return 0.0f;
    }

    @Override
    protected float getOutsidePadding(LayoutData layoutData, R renderData) {
        return this.style.getCodeBlockStyle().getBlockOutsidePadding();
    }

    @Override
    protected float getInsidePadding(LayoutData layoutData, R renderData) {
        return this.style.getCodeBlockStyle().getBlockInsidePadding();
    }

    @Override
    protected ChildMovingElement.MarkerType getMarkerType() {
        return ChildMovingElement.MarkerType.BLOCK;
    }

    public static enum CodeBlockType {
        INLINE,
        BLOCK;

    }
}

