/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.minemark.elements;

import dev.dediamondpro.resourcify.libs.minemark.LayoutData;
import dev.dediamondpro.resourcify.libs.minemark.LayoutStyle;
import dev.dediamondpro.resourcify.libs.minemark.elements.Element;
import dev.dediamondpro.resourcify.libs.minemark.elements.creators.ElementCreator;
import dev.dediamondpro.resourcify.libs.minemark.style.Style;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public class SingleTagMultiElement<S extends Style, R>
extends Element<S, R> {
    private Element<S, R> deepestChildElement = this;

    public SingleTagMultiElement(@NotNull S style, @NotNull LayoutStyle layoutStyle, @Nullable Element<S, R> parent, @NotNull String qName, @Nullable Attributes attributes) {
        super(style, layoutStyle, parent, qName, attributes);
    }

    @Override
    public void generateLayout(LayoutData layoutData, R renderData) {
        for (Element child : this.children) {
            child.generateLayout(layoutData, renderData);
        }
    }

    @Override
    @NotNull
    public ArrayList<Element<S, R>> getChildren() {
        if (this.deepestChildElement == this) {
            return this.children;
        }
        return this.deepestChildElement.getChildren();
    }

    @Override
    public LayoutStyle getLayoutStyle() {
        if (this.deepestChildElement == this) {
            return this.layoutStyle;
        }
        return this.deepestChildElement.getLayoutStyle();
    }

    public void addElement(@NotNull ElementCreator<S, R> elementCreator) {
        assert (this.parent != null);
        Element<Style, R> newElement = elementCreator.createElement(this.style, this.getLayoutStyle(), this.parent, this.qName, this.attributes);
        this.parent.getChildren().remove(newElement);
        this.deepestChildElement.getChildren().add(newElement);
        this.deepestChildElement = newElement;
    }
}

