/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.minemark.elements;

import dev.dediamondpro.resourcify.libs.minemark.LayoutData;
import dev.dediamondpro.resourcify.libs.minemark.LayoutStyle;
import dev.dediamondpro.resourcify.libs.minemark.style.Style;
import dev.dediamondpro.resourcify.libs.minemark.utils.MouseButton;
import java.io.Closeable;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public abstract class Element<S extends Style, R>
implements Closeable {
    @Nullable
    protected final Element<S, R> parent;
    protected final ArrayList<Element<S, R>> children = new ArrayList();
    protected final String qName;
    protected final Attributes attributes;
    protected final S style;
    protected LayoutStyle layoutStyle;

    public Element(@NotNull S style, @NotNull LayoutStyle layoutStyle, @Nullable Element<S, R> parent, @NotNull String qName, @Nullable Attributes attributes) {
        this.style = style;
        this.layoutStyle = layoutStyle;
        if (parent != null) {
            parent.getChildren().add(this);
        }
        this.parent = parent;
        this.qName = qName;
        this.attributes = attributes;
    }

    @ApiStatus.Internal
    public void drawInternal(float xOffset, float yOffset, float mouseX, float mouseY, R renderData) {
        for (Element<S, R> child : this.children) {
            child.drawInternal(xOffset, yOffset, mouseX, mouseY, renderData);
        }
    }

    @ApiStatus.Internal
    public void beforeDrawInternal(float xOffset, float yOffset, float mouseX, float mouseY, R renderData) {
        for (Element<S, R> child : this.children) {
            child.beforeDrawInternal(xOffset, yOffset, mouseX, mouseY, renderData);
        }
    }

    @ApiStatus.Internal
    public void onMouseClickedInternal(MouseButton button, float mouseX, float mouseY) {
        for (Element<S, R> child : this.children) {
            child.onMouseClickedInternal(button, mouseX, mouseY);
        }
    }

    @ApiStatus.Internal
    public abstract void generateLayout(LayoutData var1, R var2);

    public void regenerateLayout() {
        if (this.parent == null) {
            throw new IllegalStateException("No top level MineMarkElement found to regenerate layout with.");
        }
        this.parent.regenerateLayout();
    }

    @Override
    public void close() {
        for (Element<S, R> child : this.children) {
            child.close();
        }
    }

    public String buildTree(int depth) {
        StringBuilder builder = new StringBuilder();
        builder.append(this);
        for (Element<S, R> child : this.children) {
            builder.append("\n");
            for (int i2 = 0; i2 < depth; ++i2) {
                builder.append("  ");
            }
            builder.append("+ ");
            builder.append(child.buildTree(depth + 1));
        }
        return builder.toString();
    }

    @Nullable
    public Element<S, R> getParent() {
        return this.parent;
    }

    @NotNull
    public ArrayList<Element<S, R>> getChildren() {
        return this.children;
    }

    public LayoutStyle getLayoutStyle() {
        return this.layoutStyle;
    }
}

