/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.minemark;

import dev.dediamondpro.resourcify.libs.minemark.LayoutStyle;
import dev.dediamondpro.resourcify.libs.minemark.elements.Element;
import dev.dediamondpro.resourcify.libs.minemark.elements.EmptyElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.MineMarkElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.SingleTagMultiElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.creators.ElementCreator;
import dev.dediamondpro.resourcify.libs.minemark.elements.creators.TextElementCreator;
import dev.dediamondpro.resourcify.libs.minemark.style.Style;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class MineMarkHtmlParser<S extends Style, R>
extends DefaultHandler {
    private final List<ElementCreator<S, R>> elements;
    private final TextElementCreator<S, R> textElementCreator;
    private MineMarkElement<S, R> markDown;
    private Element<S, R> currentElement;
    private LayoutStyle layoutStyle;
    private S style;
    private StringBuilder textBuilder = new StringBuilder();
    private boolean isPreFormatted = false;

    protected MineMarkHtmlParser(TextElementCreator<S, R> textElementCreator, List<ElementCreator<S, R>> elements) {
        this.textElementCreator = textElementCreator;
        this.elements = elements;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        switch (qName) {
            case "minemark": {
                this.markDown = new MineMarkElement(this.style, this.layoutStyle, attributes);
                this.currentElement = this.markDown;
                return;
            }
            case "br": {
                this.textBuilder.append("\n");
                return;
            }
            case "pre": {
                this.isPreFormatted = true;
            }
        }
        this.addText();
        EmptyElement<S, R> newElement = this.createElement(this.style, this.currentElement.getLayoutStyle(), this.currentElement, qName, attributes);
        this.currentElement = newElement != null ? newElement : new EmptyElement<S, R>(this.style, this.currentElement.getLayoutStyle(), this.currentElement, qName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        switch (qName) {
            case "minemark": 
            case "br": {
                return;
            }
            case "pre": {
                this.isPreFormatted = false;
            }
        }
        this.addText();
        this.currentElement = this.currentElement.getParent();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        int newLength = length;
        if (this.isPreFormatted) {
            if (ch[start] == '\n') {
                --newLength;
            }
            if (ch[start + length - 1] == '\n') {
                --newLength;
            }
        } else {
            for (int i2 = start; i2 < start + length; ++i2) {
                if (ch[i2] != '\n') continue;
                --newLength;
            }
        }
        char[] modifiedCh = new char[newLength];
        int index = 0;
        for (int i3 = start; i3 < start + length; ++i3) {
            if (ch[i3] == '\n' && (!this.isPreFormatted || i3 == start || i3 == start + length - 1)) continue;
            modifiedCh[index++] = ch[i3];
        }
        this.textBuilder.append(modifiedCh);
    }

    private void addText() {
        String text = this.textBuilder.toString();
        if (text.isEmpty()) {
            return;
        }
        this.textElementCreator.createElement(this.textBuilder.toString(), this.style, this.currentElement.getLayoutStyle(), this.currentElement, "text", null);
        this.textBuilder = new StringBuilder();
    }

    private Element<S, R> createElement(S style, LayoutStyle layoutStyle, @NotNull Element<S, R> parent, @NotNull String qName, @NotNull Attributes attributes) {
        ElementCreator<S, R> elementCreator = null;
        Element<S, R> multipleElement = null;
        for (ElementCreator<S, R> element : this.elements) {
            if (!element.appliesTo(style, layoutStyle, parent, qName, attributes)) continue;
            if (elementCreator == null) {
                elementCreator = element;
                continue;
            }
            if (multipleElement == null) {
                multipleElement = new SingleTagMultiElement<S, R>(style, layoutStyle, parent, qName, attributes);
                ((SingleTagMultiElement)multipleElement).addElement(elementCreator);
            }
            ((SingleTagMultiElement)multipleElement).addElement(element);
        }
        return multipleElement != null ? multipleElement : (elementCreator != null ? elementCreator.createElement(style, layoutStyle, parent, qName, attributes) : null);
    }

    protected void setStyle(S style, LayoutStyle layoutStyle) {
        this.style = style;
        this.layoutStyle = layoutStyle;
    }

    protected MineMarkElement<S, R> getParsedResult() {
        return this.markDown;
    }

    protected void cleanUp() {
        this.markDown = null;
        this.currentElement = null;
        this.layoutStyle = null;
        this.style = null;
        this.textBuilder = new StringBuilder();
        this.isPreFormatted = false;
    }
}

