/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.elementa.components;

import dev.dediamondpro.resourcify.libs.elementa.UIComponent;
import dev.dediamondpro.resourcify.libs.elementa.components.UIPoint;
import dev.dediamondpro.resourcify.libs.elementa.dsl.UtilitiesKt;
import dev.dediamondpro.resourcify.libs.elementa.impl.Platform;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="Currently only supports convex polygons. Use with care! Or better, create a dedicated component for your use case.")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0017\u0018\u00002\u00020\u0001B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\b\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ!\u0010\f\u001a\u00020\u00002\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\n\"\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015R(\u0010\u0017\u001a\u00020\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0018\n\u0004\b\u0017\u0010\u0018\u0012\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Ldev/dediamondpro/resourcify/libs/elementa/components/UIShape;", "Ldev/dediamondpro/resourcify/libs/elementa/UIComponent;", "Ljava/awt/Color;", "color", "<init>", "(Ljava/awt/Color;)V", "Ldev/dediamondpro/resourcify/libs/elementa/components/UIPoint;", "point", "addVertex", "(Lgg/essential/elementa/components/UIPoint;)Lgg/essential/elementa/components/UIShape;", "", "points", "addVertices", "([Lgg/essential/elementa/components/UIPoint;)Lgg/essential/elementa/components/UIShape;", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "", "draw", "(Lgg/essential/universal/UMatrixStack;)V", "", "getVertices", "()Ljava/util/List;", "", "drawMode", "I", "getDrawMode", "()I", "setDrawMode", "(I)V", "getDrawMode$annotations", "()V", "vertices", "Ljava/util/List;", "Elementa"})
@SourceDebugExtension(value={"SMAP\nUIShape.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UIShape.kt\ngg/essential/elementa/components/UIShape\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1849#2,2:75\n*S KotlinDebug\n*F\n+ 1 UIShape.kt\ngg/essential/elementa/components/UIShape\n*L\n60#1:75,2\n*E\n"})
public class UIShape
extends UIComponent {
    @NotNull
    private List<UIPoint> vertices;
    private int drawMode;

    @JvmOverloads
    public UIShape(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.vertices = new ArrayList();
        this.drawMode = 9;
        this.setColor(UtilitiesKt.toConstraint(color));
    }

    public /* synthetic */ UIShape(Color color, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Color color2 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"WHITE");
            color = color2;
        }
        this(color);
    }

    public final int getDrawMode() {
        return this.drawMode;
    }

    public final void setDrawMode(int n) {
        this.drawMode = n;
    }

    @Deprecated(message="Only supports GL_POLYGON on 1.17+, implemented as TRIANGEL_FAN.")
    public static /* synthetic */ void getDrawMode$annotations() {
    }

    @NotNull
    public final UIShape addVertex(@NotNull UIPoint point) {
        UIShape uIShape;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        UIShape $this$addVertex_u24lambda_u240 = uIShape = this;
        boolean bl = false;
        $this$addVertex_u24lambda_u240.getParent().addChild(point);
        $this$addVertex_u24lambda_u240.vertices.add(point);
        return uIShape;
    }

    @NotNull
    public final UIShape addVertices(UIPoint ... points) {
        UIShape uIShape;
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        UIShape $this$addVertices_u24lambda_u241 = uIShape = this;
        boolean bl = false;
        $this$addVertices_u24lambda_u241.getParent().addChildren(Arrays.copyOf(points, points.length));
        CollectionsKt.addAll((Collection)$this$addVertices_u24lambda_u241.vertices, (Object[])points);
        return uIShape;
    }

    @NotNull
    public final List<UIPoint> getVertices() {
        return this.vertices;
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.beforeDrawCompat(matrixStack);
        Color color = this.getColor();
        if (color.getAlpha() == 0) {
            super.draw(matrixStack);
            return;
        }
        UGraphics.enableBlend();
        UGraphics.disableTexture2D();
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        UGraphics worldRenderer = UGraphics.getFromTessellator();
        UGraphics.tryBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        if (Platform.Companion.getPlatform$Elementa().getMcVersion() >= 11700) {
            worldRenderer.beginWithDefaultShader(UGraphics.DrawMode.TRIANGLE_FAN, UGraphics.CommonVertexFormats.POSITION_COLOR);
        } else {
            worldRenderer.begin(this.drawMode, UGraphics.CommonVertexFormats.POSITION_COLOR);
        }
        Iterable $this$forEach$iv = this.vertices;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UIPoint it = (UIPoint)element$iv;
            boolean bl = false;
            worldRenderer.pos(matrixStack, (double)it.getAbsoluteX(), (double)it.getAbsoluteY(), 0.0).color(red, green, blue, alpha).endVertex();
        }
        worldRenderer.drawDirect();
        UGraphics.enableTexture2D();
        UGraphics.disableBlend();
        super.draw(matrixStack);
    }

    @JvmOverloads
    public UIShape() {
        this(null, 1, null);
    }
}

