/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.gui;

import dev.dediamondpro.resourcify.libs.elementa.ElementaVersion;
import dev.dediamondpro.resourcify.libs.elementa.WindowScreen;
import dev.dediamondpro.resourcify.util.NetworkUtil;
import gg.essential.universal.UKeyboard;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UMinecraft;
import gg.essential.universal.UResolution;
import gg.essential.universal.UScreen;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 #2\u00020\u0001:\u0001#B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\bJ/\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J)\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001a\u0010\bJ\u001b\u0010\u001e\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010 R\u0016\u0010!\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"\u00a8\u0006$"}, d2={"Ldev/dediamondpro/resourcify/gui/PaginatedScreen;", "Ldev/dediamondpro/resourcify/libs/elementa/WindowScreen;", "", "adaptScale", "<init>", "(Z)V", "", "goBack", "()V", "goForward", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "", "mouseX", "mouseY", "", "partialTicks", "onDrawScreen", "(Lgg/essential/universal/UMatrixStack;IIF)V", "keyCode", "", "typedChar", "Lgg/essential/universal/UKeyboard$Modifiers;", "modifiers", "onKeyPressed", "(ICLgg/essential/universal/UKeyboard$Modifiers;)V", "onTick", "Lkotlin/Function0;", "Lnet/minecraft/class_437;", "screen", "replaceScreen", "(Lkotlin/jvm/functions/Function0;)V", "Z", "defaultScale", "I", "Companion", "resourcify"})
@SourceDebugExtension(value={"SMAP\nPaginatedScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaginatedScreen.kt\ndev/dediamondpro/resourcify/gui/PaginatedScreen\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n1#2:144\n*E\n"})
public abstract class PaginatedScreen
extends WindowScreen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean adaptScale;
    private int defaultScale;
    private static boolean replacingScreen;
    @NotNull
    private static final List<class_437> backScreens;
    @NotNull
    private static final List<class_437> forwardScreens;

    public PaginatedScreen(boolean adaptScale) {
        super(ElementaVersion.V5, false, false, false, 0, 26, null);
        this.adaptScale = adaptScale;
        this.defaultScale = -1;
        if (!replacingScreen) {
            class_437 class_4372 = UScreen.Companion.getCurrentScreen();
            if (class_4372 != null) {
                class_437 it = class_4372;
                boolean bl = false;
                backScreens.add(it);
            }
            forwardScreens.clear();
        }
    }

    public /* synthetic */ PaginatedScreen(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    @Override
    public void onDrawScreen(@NotNull UMatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        class_310 class_3102 = this.field_22787;
        Intrinsics.checkNotNull((Object)class_3102);
        this.method_25434(new class_332(this.field_22787, class_3102.method_22940().method_23000()));
        super.onDrawScreen(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void onTick() {
        int updatedScale;
        if (!this.adaptScale) {
            return;
        }
        if (this.defaultScale == -1) {
            this.defaultScale = UMinecraft.getGuiScale();
        }
        if ((updatedScale = PaginatedScreen.Companion.getGuiScale(this.defaultScale)) != (int)UResolution.getScaleFactor()) {
            this.setNewGuiScale(updatedScale);
            this.updateGuiScale();
            UMinecraft.setGuiScale((int)updatedScale);
            this.field_22789 = UResolution.getScaledWidth();
            this.field_22790 = UResolution.getScaledHeight();
        }
        super.onTick();
    }

    @Override
    public void onKeyPressed(int keyCode, char typedChar, @Nullable UKeyboard.Modifiers modifiers) {
        if (this.getWindow().getFocusedComponent() == null && keyCode == UKeyboard.KEY_ESCAPE) {
            this.goBack();
        } else {
            super.onKeyPressed(keyCode, typedChar, modifiers);
        }
    }

    public void goBack() {
        class_437 backScreen = (class_437)CollectionsKt.removeLastOrNull(backScreens);
        if (backScreen instanceof PaginatedScreen) {
            forwardScreens.add((class_437)this);
        } else {
            Companion.cleanUp();
        }
        UScreen.Companion.displayScreen(backScreen);
    }

    public void goForward() {
        class_437 class_4372 = (class_437)CollectionsKt.removeLastOrNull(forwardScreens);
        if (class_4372 == null) {
            return;
        }
        class_437 forwardScreen = class_4372;
        backScreens.add((class_437)this);
        UScreen.Companion.displayScreen(forwardScreen);
    }

    public final void replaceScreen(@NotNull Function0<? extends class_437> screen) {
        Intrinsics.checkNotNullParameter(screen, (String)"screen");
        replacingScreen = true;
        UScreen.Companion.displayScreen((class_437)screen.invoke());
        replacingScreen = false;
    }

    public PaginatedScreen() {
        this(false, 1, null);
    }

    static {
        backScreens = new ArrayList();
        forwardScreens = new ArrayList();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\u0003J\u0017\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0007R\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0013\u0010\u0011R\u0016\u0010\u0015\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Ldev/dediamondpro/resourcify/gui/PaginatedScreen$Companion;", "", "<init>", "()V", "", "guiScale", "calculateScaleFactor", "(I)I", "", "cleanUp", "defaultScale", "getGuiScale", "", "Lnet/minecraft/class_437;", "backScreens", "Ljava/util/List;", "getBackScreens", "()Ljava/util/List;", "forwardScreens", "getForwardScreens", "", "replacingScreen", "Z", "resourcify"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<class_437> getBackScreens() {
            return backScreens;
        }

        @NotNull
        public final List<class_437> getForwardScreens() {
            return forwardScreens;
        }

        public final void cleanUp() {
            this.getBackScreens().clear();
            this.getForwardScreens().clear();
            NetworkUtil.INSTANCE.clearCache();
        }

        private final int getGuiScale(int defaultScale) {
            int minScale = (int)Math.floor((float)UResolution.getWindowWidth() / 692.0f);
            return RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)minScale, (int)1), (int)this.calculateScaleFactor(defaultScale));
        }

        private final int calculateScaleFactor(int guiScale) {
            class_310 mc = UMinecraft.getMinecraft();
            return mc.method_22683().method_4476(guiScale, mc.method_1573());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

